// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/Util/hkMemUtil.h>
#include <Common/Base/Fwd/hkcstring.h>

using namespace std;

#if defined(HK_PLATFORM_WIIU)


#if 0 && (CAFE_OS_SDK_VERSION >= 20900)
#define CHECK_OSBLOCKMOVE(dst, src, nbytes, flush) OSBlockMove(dst, src, nbytes, flush)
#else
#define CHECK_OSBLOCKMOVE(dst, src, nbytes, flush) if(dst != src) { OSBlockMove(dst, src, nbytes, flush); } else
#endif
    void HK_CALL hkMemUtil::memCpy(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes)
    {
        // Ranges must not overlap
        HK_ASSERT_NO_MSG(0xd205cf23, hkMath::max2(hkUlong(dst), hkUlong(src)) >= (nbytes + hkMath::min2(hkUlong(dst), hkUlong(src))));
        CHECK_OSBLOCKMOVE(dst, src, nbytes, false);
    }

    void HK_CALL hkMemUtil::memSet(_Out_writes_bytes_all_(n) void* dst, const int c, hkLong nbytes)
    {
        OSBlockSet(dst, c, (size_t)nbytes);
    }

    void HK_CALL hkMemUtil::memCpyBackwards(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes)
    {
        CHECK_OSBLOCKMOVE(dst, src, nbytes, false);
    }

    void HK_CALL hkMemUtil::memMove(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes)
    {
        CHECK_OSBLOCKMOVE(dst, src, nbytes, false);
    }

#else

template<unsigned int N>
static void HK_INLINE memCopyBackwards(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes)
{
    HK_ASSERT_NO_MSG(0x341ec349, dst != src);
    HK_ASSERT_NO_MSG(0x4543e434, (dst > src) || ((static_cast<char*>(dst)+nbytes) <= src) );
    typedef typename hkMemUtil::TypeFromAlign<N>::type CopyType;
    HK_ASSERT_NO_MSG(0x70ffeb38, N == 1 || ( ((hkUlong)dst & (N-1)) == 0 && ((hkUlong)src & (N-1)) == 0 && (nbytes & (N-1)) == 0 ));
    const hkLong typeSize = static_cast<hkLong>(sizeof(CopyType));
    hkLong i, j;
    for( i = nbytes, j = nbytes/typeSize-1; i >= typeSize; i -= typeSize, --j )
    {
        static_cast<CopyType*>(dst)[j] = static_cast<const CopyType*>(src)[j];
    }
}

    HK_EXPORT_COMMON void HK_CALL hkMemUtil::memCpy(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes)
    {
        // Ranges must not overlap
        HK_ASSERT_NO_MSG(0xd205cf24, hkMath::max2(hkUlong(dst), hkUlong(src)) >= (nbytes + hkMath::min2(hkUlong(dst), hkUlong(src))));
        memcpy(dst, src, nbytes);
    }

    HK_EXPORT_COMMON void HK_CALL hkMemUtil::memSet(_Out_writes_bytes_all_(nbytes) void* dst, const int c, hkLong nbytes)
    {
        memset(dst, c, (unsigned)nbytes);
    }

    HK_EXPORT_COMMON void HK_CALL hkMemUtil::memCpyBackwards(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes)
    {
    #if defined(HK_PLATFORM_PSVITA)
        memmove(dst, src, nbytes);
    #else
        if( (nbytes & ~7) && (nbytes & 0x7) == 0 && ((hkUlong)dst & 0x7) == 0 && ((hkUlong)src & 0x7) == 0 )
        {
            memCopyBackwards<8>(dst, src, nbytes);
            dst = static_cast<char*>(dst) + (nbytes & ~7);
            src = static_cast<const char*>(src) + (nbytes & ~7);
            nbytes &= 7;
        }

        if( (nbytes & ~3) && (nbytes & 0x3) == 0 && ((hkUlong)dst & 0x3) == 0 && ((hkUlong)src & 0x3) == 0 )
        {
            memCopyBackwards<4>(dst, src, nbytes);
            dst = static_cast<char*>(dst) + (nbytes & ~3);
            src = static_cast<const char*>(src) + (nbytes & ~3);
            nbytes &= 3;
        }

        if( (nbytes & ~1) && (nbytes & 0x1) == 0 && ((hkUlong)dst & 0x1) == 0 && ((hkUlong)src & 0x1) == 0 )
        {
            memCopyBackwards<2>(dst, src, nbytes);
            dst = static_cast<char*>(dst) + (nbytes & ~1);
            src = static_cast<const char*>(src) + (nbytes & ~1);
            nbytes &= 1;
        }

        memCopyBackwards<1>(dst, src, nbytes);
    #endif
    }

    HK_EXPORT_COMMON void HK_CALL hkMemUtil::memMove(_Out_writes_bytes_all_(nbytes) void* dst, _In_reads_bytes_(nbytes) const void* src, hkLong nbytes)
    {
        if( dst > src )
        {
            memCpyBackwards(dst, src, nbytes);
        }
        else if( dst < src )
        {
            memmove(dst, src, nbytes);
        }
    }
#endif

    HK_EXPORT_COMMON int HK_CALL hkMemUtil::memCmp(_In_reads_bytes_(n) const void* a, _In_reads_bytes_(n) const void* b, hkLong n)
    {
        const hkUint8* ua = static_cast<const hkUint8*>(a);
        const hkUint8* ub = static_cast<const hkUint8*>(b);
        for( int i = 0; i < n; ++i )
        {
            if( ua[i] < ub[i] ) return -1;
            else if( ua[i] > ub[i] ) return +1;
        }
        return 0;
    }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
