// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE bool hkMemoryTrackerSnapshot::isFinalized() const
{
    return m_finalized;
}

HK_INLINE hkMemoryTrackerSnapshot::BlockIterator hkMemoryTrackerSnapshot::getBlockFor(_In_ const void* ptr) const
{
    HK_ASSERT(0x59708c4d, isFinalized(), "Snapshot is not final");
    return m_blockIndex.find(ptr, m_blocks);
}

HK_INLINE const hkMemoryTrackerSnapshot::Block& hkMemoryTrackerSnapshot::getBlock(BlockIterator it) const
{
    return m_blocks[it];
}

HK_INLINE bool hkMemoryTrackerSnapshot::containsLinks(BlockIterator block) const
{
    return m_linksFromBlock.hasKey(block);
}

HK_INLINE hkMemoryTrackerSnapshot::LinkIterator hkMemoryTrackerSnapshot::getLinksFor(hkMemoryTrackerSnapshot::BlockIterator it) const
{
    HK_ASSERT(0x4f49c619, isFinalized(), "Snapshot is not final");
    return LinkIterator(m_linksFromBlock, m_linksFromBlock.findKey(it), it);
}

HK_INLINE bool hkMemoryTrackerSnapshot::LinkIterator::advance()
{
    if (!m_map.isValid(m_it))
    {
        return false;
    }
    m_current = m_map.getValue(m_it);
    m_it = m_map.getNext(m_it, m_key);
    return true;
}

HK_INLINE hkMemoryTrackerSnapshot::BlockIterator hkMemoryTrackerSnapshot::LinkIterator::current() const
{
    return m_current;
}

HK_INLINE bool hkMemoryTrackerSnapshot::isEmpty() const { return m_blocks.isEmpty(); }

HK_INLINE hkMemoryTrackerSnapshot::BlockIterator hkMemoryTrackerSnapshot::begin() const
{
    return 0;
}

HK_INLINE hkMemoryTrackerSnapshot::BlockIterator hkMemoryTrackerSnapshot::end() const
{
    return m_blocks.getSize();
}

inline void hkMemoryTrackerSnapshot::addLinkedEasyOverhead(_In_ const void* ptr)
{
    const void* allocStart = hkMemoryRouter::getInstance().getEasyAllocStartAddress(
        hkMemoryRouter::getInstance().heap(), ptr);
    int overheadSize = hkLosslessCast<int>(hkGetByteOffset(allocStart, ptr));
    addLinkedBlock(
        hkMemoryTrackerSnapshot::Block("buffer_easyAlloc", allocStart, overheadSize), true);
}

inline void hkMemoryTrackerSnapshot::addLinkedAlignedOverhead(_In_ const void* ptr)
{
    const void* allocStart = hkMemoryRouter::getInstance().getAlignedAllocStartAddress(
        hkMemoryRouter::getInstance().heap(), ptr);
    int overheadSize = hkLosslessCast<int>(hkGetByteOffset(allocStart, ptr));
    addLinkedBlock(
        hkMemoryTrackerSnapshot::Block("buffer_alignedAlloc", allocStart, overheadSize), true);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
