// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Memory/Tracker/hkMemoryTrackerSnapshot.h>

    /// This utility generates a report containing type, callstack and size information.
    /// It also generates a graph describing the relationship between blocks
    ///
    /// This utility is intended to be invoked by Visual Debugger client
class HK_EXPORT_COMMON hkMemoryTrackerReportUtil
{
    public:
        HK_DECLARE_CLASS(hkMemoryTrackerReportUtil, New);

            /// Line-oriented succinct report suitable for streaming over a socket
        static void HK_CALL generateReport(const hkMemorySnapshot& memorySnapshot,
                                           const hkMemoryTrackerSnapshot& trackerSnapshot,
                                           hkOstream& stream);

            /// Acquires a joint snapshot.
            /// If memoryTracker is HK_NULL, the tracker snapshot will not be filled.
        static void HK_CALL takeSnapshots(_In_opt_ const hkMemoryTracker* memoryTracker,
                                          hkMemorySnapshot& memorySnapshot,
                                          hkMemoryTrackerSnapshot& trackerSnapshot);

            /// Acquires a joint snapshot and prints a report on file.
            /// If memoryTracker is HK_NULL, the report will contain only information
            /// about the memory system allocations (without block information).
        static void HK_CALL takeSnapshotsAndGenerateReport(_In_opt_ const hkMemoryTracker* memoryTracker, _In_z_ const char* filename);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
