// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect { class Type; }
namespace hkReflect { namespace Detail { class TrackerRegNode; }; }

#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/Memory/Tracker/hkMemoryTracker.h>

    /// Maps each hkMemoryTracker::Handle to the corresponding hkReflect::Type.
class HK_EXPORT_COMMON hkMemoryTrackerRegistry : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkMemoryTrackerRegistry, New, Singleton);

#if defined(HK_MEMORY_TRACKER_ENABLE)
        hkMemoryTrackerRegistry();

        void addEntries(_In_ const hkReflect::Detail::TrackerRegNode* head);
        void removeEntries(_In_ const hkReflect::Detail::TrackerRegNode* head);

        _Ret_maybenull_ const hkReflect::Type* typeFromHandle(hkMemoryTracker::Handle handle) const { return m_typeFromHandle.getWithDefault(handle, HK_NULL); }

    protected:

        void fixup(_Inout_ hkReflect::Type* type) const;
        void fixupPtr(_Inout_ const hkReflect::Type** typePtr) const;
#endif

    protected:

        typedef hkHashMap<hkMemoryTracker::Handle, const hkReflect::Type*> Map;
        Map m_typeFromHandle;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
