// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>

#include <Common/Base/Memory/Tracker/hkMemoryTrackerRegistry.h>
#include <Common/Base/Object/hkSingleton.h>

#if defined(HK_MEMORY_TRACKER_ENABLE)
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>

hkMemoryTrackerRegistry::hkMemoryTrackerRegistry()
{
}

void hkMemoryTrackerRegistry::fixupPtr(_Inout_ const hkReflect::Type** typePtr) const
{
    if (*typePtr != HK_NULL && *typePtr != hkReflect::getType<void*>()) 
    {
        Map::Iterator it = m_typeFromHandle.findKey((hkMemoryTracker::Handle)(*typePtr));
        if (m_typeFromHandle.isValid(it))
        {
            *typePtr = m_typeFromHandle.getValue(it);
        }
        else
        {
            *typePtr = hkReflect::getType<hkReflect::Detail::Opaque>();
        }
    }
}

void hkMemoryTrackerRegistry::fixup(_Inout_ hkReflect::Type* type) const
{
    fixupPtr(const_cast<const hkReflect::Type**>(hkReflect::TypeDetail::addressParent(type)));
    if (const hkReflect::Type** subType = hkReflect::TypeDetail::localAddressOptional<hkReflect::Opt::SUBTYPE>(type))
    {
        fixupPtr(subType);
    }
    if (const hkReflect::Detail::DeclsArray* decls = hkReflect::TypeDetail::localGetOptional<hkReflect::Opt::DECLS>(type))
    {
        for (int i = 0; i < decls->getNumDataFields(); ++i)
        {
            hkReflect::Type* field = const_cast<hkReflect::Type*>(decls->getField(i).getType().get());
            fixupPtr(const_cast<const hkReflect::Type**>(hkReflect::TypeDetail::addressParent(field)));
        }
    }
}

void hkMemoryTrackerRegistry::addEntries(_In_ const hkReflect::Detail::TrackerRegNode* head)
{
    for (const hkReflect::Detail::TrackerRegNode* node = head; node; node = node->getNext())
    {
        if (node->getHandle())
        {
            if (node->getHandle() != HK_TRACKER_GET_HANDLE_UNCHECKED(hkReflect::Detail::NotTracked))
            {
#ifdef HK_DEBUG
                HK_ASSERT_NO_MSG(0x6e55ffdc, node->getHandle());
                const hkReflect::Type* existing = m_typeFromHandle.getWithDefault(node->getHandle(), HK_NULL);
                HK_ASSERTV(0x3187d01f, !existing, "Duplicate handle {} for types {} and {}.", node->getHandle(), existing->getFullName(), node->getType()->getFullName());
#endif
                m_typeFromHandle.insert(node->getHandle(), node->getType());
            }
            else
            {
                
                HK_BREAKPOINT(0);
            }
        }
    }

    for (const hkReflect::Detail::TrackerRegNode* node = head; node; node = node->getNext())
    {
        if (node->mustFixup())
        {
            fixup(node->getType());
        }
    }
}

void hkMemoryTrackerRegistry::removeEntries(_In_ const hkReflect::Detail::TrackerRegNode* head)
{
    

    for (const hkReflect::Detail::TrackerRegNode* node = head; node; node = node->getNext())
    {
        if (node->getHandle() && node->getHandle() != HK_TRACKER_GET_HANDLE_UNCHECKED(hkReflect::Detail::NotTracked))
        {
            HK_ON_DEBUG(hkResult contained = )m_typeFromHandle.remove(node->getHandle());
            HK_ASSERT_NO_MSG(0x755bb8d2, contained.isSuccess());
        }
    }

    
}

#endif

HK_SINGLETON_IMPLEMENTATION(hkMemoryTrackerRegistry);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
