// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Memory/Tracker/hkMemoryTracker.h>
#include <Common/Base/Container/Hash/hkHashMap.h>

class HK_EXPORT_COMMON hkDefaultMemoryTracker : public hkMemoryTracker
{
    public:
        HK_DECLARE_PLACEMENT_ALLOCATOR();

            /// Ctor
        hkDefaultMemoryTracker(_In_ hkMemoryAllocator* allocator);
        ~hkDefaultMemoryTracker();

        virtual void addBlock(_In_z_ const char* name, const BlockType& type, _In_opt_bytecount_(size) const void* ptr, hk_size_t size, bool onHeap) HK_OVERRIDE;
        virtual void removeBlock(_In_opt_ const void* ptr) HK_OVERRIDE;
        virtual hkResult getSnapshot(hkMemoryTrackerSnapshot& snapshot) const HK_OVERRIDE;
        hkMemoryAllocator& getAllocator() { return *m_allocator; }

    protected:

        struct HK_EXPORT_COMMON Info
        {
            Info() : size(0), name(HK_NULL), type() {}
            Info(hk_size_t sz, _In_z_ const char* n, const BlockType& ty) : size(sz), name(n), type(ty) {}
            hk_size_t size;
            const char* name;
            BlockType type;
        };

        struct HK_EXPORT_COMMON PrivateAllocator
        {
            hkMemoryAllocator& get(_In_opt_ void*) { return static_cast<hkDefaultMemoryTracker&>(getInstance()).getAllocator(); }
        };

    protected:

        
        typedef hkMap<const void*, Info, hkMapOperations<const void*>, PrivateAllocator> InfoFromBlockMap;
        void addToMap(_In_ const void* ptr, const Info& info, InfoFromBlockMap& map);
        void fillSnapshot(const InfoFromBlockMap& map, hkMemoryTrackerSnapshot& snapshot, bool onHeap) const;

    protected:

        mutable hkCriticalSection m_criticalSection;
        hkMemoryAllocator* m_allocator;

        InfoFromBlockMap m_blocks;
        InfoFromBlockMap m_outsideHeap;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
