// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Memory/Tracker/hkMemoryTrackerSnapshot.h>
#include <Common/Base/Memory/Tracker/Default/hkDefaultMemoryTracker.h>
#include <Common/Base/Container/String/hkStringBuf.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Memory/Tracker/hkMemoryTrackerRegistry.h>
#include <Common/Base/Types/Properties/hkRefCountedProperties.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>

#include <Common/Base/Container/PointerMap/hkMap.hxx>

#if defined(HK_MEMORY_TRACKER_ENABLE)


hkDefaultMemoryTracker::hkDefaultMemoryTracker(_In_ hkMemoryAllocator* allocator)
    : m_allocator(allocator)
{
}

hkDefaultMemoryTracker::~hkDefaultMemoryTracker()
{
    if (m_blocks.getSize() != 0)
    {
        
        hkMemoryInitUtil::outputDebugString("Some of the pointers in hkDefaultMemoryTracker were not removed\n", HK_NULL);
    }
}

#define SINGLE_THREADED_BLOCK() \
    hkCriticalSectionLock lock(&m_criticalSection)

inline void hkDefaultMemoryTracker::addToMap(_In_ const void* ptr, const Info& info, InfoFromBlockMap& map)
{
    SINGLE_THREADED_BLOCK();

#if defined(HK_DEBUG)
    Info prev;
    if (map.get(ptr, &prev).isSuccess())
    {
        HK_ASSERT(0xa2b70c1, 0, "Pointer was not freed");
    }
#endif
    map.insert(ptr, info);
}

void hkDefaultMemoryTracker::addBlock(_In_z_ const char* name, const BlockType& type, _In_opt_bytecount_(size) const void* ptr, hk_size_t size, bool onHeap)
{
    if(ptr==HK_NULL) { return; }

    HK_ASSERT_NO_MSG(0x3bffa286, name != HK_NULL || type.isValid());
    HK_ASSERT_NO_MSG(0xd9b9b00, size > 0);
    Info info(size, name, type);
    if (onHeap)
    {
        addToMap(ptr, info, m_blocks);
    }
    else
    {
        addToMap(ptr, info, m_outsideHeap);
    }
}

void hkDefaultMemoryTracker::removeBlock(_In_opt_ const void* ptr)
{
    if(ptr==HK_NULL) { return; }

    SINGLE_THREADED_BLOCK();

    hkResult removed = m_blocks.remove(ptr);
    if (!removed.isSuccess())
    {
        removed = m_outsideHeap.remove(ptr);
    }
    HK_ASSERT(0x9aedcde,removed.isSuccess(), "Pointer is not tracked");
}

void hkDefaultMemoryTracker::fillSnapshot(const InfoFromBlockMap& map, hkMemoryTrackerSnapshot& snapshot, bool onHeap) const
{
    // Fill the map with the tracked top-level blocks.
    for (InfoFromBlockMap::Iterator it = map.getIterator();
        map.isValid(it); it = map.getNext(it))
    {
        const void* ptr = map.getKey(it);
        const Info& info = map.getValue(it);

        // Resolve handles into types.
        const hkReflect::Type* blockType = info.type.asType() ? info.type.asType() :
            hkMemoryTrackerRegistry::getInstance().typeFromHandle(info.type.asHandle());

        snapshot.addBlock(hkMemoryTrackerSnapshot::Block(info.name, ptr, hkLosslessCast<int>(info.size), blockType), onHeap);
    }
}

hkResult hkDefaultMemoryTracker::getSnapshot(hkMemoryTrackerSnapshot& snapshot) const
{
    SINGLE_THREADED_BLOCK();

    

    fillSnapshot(m_blocks, snapshot, true);
    fillSnapshot(m_outsideHeap, snapshot, false);

    snapshot.finalize();

    return HK_SUCCESS;
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
