// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Memory/Allocator/FreeList/hkFreeListAllocator.h>

hkMemorySystem::FrameInfo::FrameInfo(int physics2012SolverBufferSize, int stackAllocatorSizeHint)
: m_physics2012SolverBufferSize(physics2012SolverBufferSize), m_stackAllocatorSizeHint(stackAllocatorSizeHint)
{
}

hkMemorySystem* hkMemorySystem::s_instance;

void HK_CALL hkMemorySystem::replaceInstance(_In_opt_ hkMemorySystem* m)
{
    s_instance = m;
}

hkMemorySystem& HK_CALL hkMemorySystem::getInstance()
{
    return *s_instance;
}

_Ret_maybenull_ hkMemorySystem* HK_CALL hkMemorySystem::getInstancePtr()
{
    return s_instance;
}

hkMemorySystem::~hkMemorySystem()
{
}

static void printDetailedStatistics(_In_z_ const char* what, hkOstream& ostr, hkMemoryAllocator::MemoryStatistics& u, hk_size_t softLimit = hkFreeListAllocator::SOFT_LIMIT_MAX )
{
    hk_size_t allocated = hkMath::max2( u.m_allocated, u.m_inUse );
    int overHead = int(allocated - u.m_inUse - u.m_available);
    hkReal relOvhd = overHead / hkReal(u.m_inUse + u.m_available);

    if ( softLimit == 0 || softLimit == hkFreeListAllocator::SOFT_LIMIT_MAX )
    {
        softLimit = allocated;
    }

    hk_size_t available = hk_size_t((1.0f - relOvhd) * softLimit);
    hk_size_t   reserved = allocated - softLimit;

    hkReal relFactor = 100.0f / hkMath::min2( softLimit, available);

    ostr.printf("\t%s:\n", what);
    ostr.printf("            totalSize:   %10i\n", allocated);
    if ( softLimit < allocated )
    {
        ostr.printf("\n            - reserved:  %10i (%4.1f%%)\n", reserved,  100.0f * reserved  / available);
        ostr.printf("            = softlimit: %10i\n", softLimit);
    }
    ostr.printf("            - overhead:  %10i (%4.1f%%)\n", overHead,  100.0f * overHead / softLimit);
    ostr.printf("            = available: %10i\n", available);

    ostr.printf("              used:      %10i (%4.1f%%)\n",    u.m_inUse,      u.m_inUse * relFactor );
    ostr.printf("              free:      %10i (%4.1f%%)\n",    u.m_available,  u.m_available * relFactor );
    ostr.printf("              peak:      %10i (%4.1f%%)\n\n",  u.m_peakInUse,  u.m_peakInUse * relFactor );
}

void hkMemorySystem::garbageCollectThread(hkMemoryRouter&)
{
}

void hkMemorySystem::garbageCollectShared()
{
}

void hkMemorySystem::garbageCollect()
{
    garbageCollectThread(hkMemoryRouter::getInstance());
    garbageCollectShared();
}

hkResult hkMemorySystem::setHeapSoftLimit(int nbytes)
{
    return HK_FAILURE;
}

int hkMemorySystem::getHeapSoftLimit() const
{
    return -1;
}

bool hkMemorySystem::solverCanAllocSingleBlock( int numBytes )
{
    return true;
}

bool hkMemorySystem::heapCanAllocTotal( int numBytes )
{
    return true;
}

hkMemorySystem::LockedMemoryAllocator::LockedMemoryAllocator(hkMemoryAllocator& chainedAlloc)
    : m_chainedAllocator(chainedAlloc)
{
}

_Ret_notnull_ _Post_writable_byte_size_(numBytes) void* hkMemorySystem::LockedMemoryAllocator::blockAlloc(int numBytes)
{
    hkCriticalSectionLock l(&m_section);
    return m_chainedAllocator.blockAlloc(numBytes);
}

void hkMemorySystem::LockedMemoryAllocator::blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes)
{
    hkCriticalSectionLock l(&m_section);
    m_chainedAllocator.blockFree(p, numBytes);
}

_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkMemorySystem::LockedMemoryAllocator::bufAlloc(int& reqNumBytesInOut)
{
    hkCriticalSectionLock l(&m_section);
    return m_chainedAllocator.bufAlloc(reqNumBytesInOut);
}

void hkMemorySystem::LockedMemoryAllocator::bufFree(_In_opt_bytecount_(numBytes) void* p, int numBytes)
{
    hkCriticalSectionLock l(&m_section);
    m_chainedAllocator.bufFree(p, numBytes);
}

_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkMemorySystem::LockedMemoryAllocator::bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut)
{
    hkCriticalSectionLock l(&m_section);
    return m_chainedAllocator.bufRealloc(pold, oldNumBytes, reqNumBytesInOut);
}

void hkMemorySystem::LockedMemoryAllocator::blockAllocBatch(_Out_writes_all_(numPtrs) void** ptrsOut, int numPtrs, int blockSize)
{
    hkCriticalSectionLock l(&m_section);
    m_chainedAllocator.blockAllocBatch(ptrsOut, numPtrs, blockSize);
}

void hkMemorySystem::LockedMemoryAllocator::blockFreeBatch(_In_reads_(numPtrs) void** ptrsIn, int numPtrs, int blockSize)
{
    hkCriticalSectionLock l(&m_section);
    m_chainedAllocator.blockFreeBatch(ptrsIn, numPtrs, blockSize);
}

void hkMemorySystem::LockedMemoryAllocator::getMemoryStatistics(MemoryStatistics& u) const
{
    hkCriticalSectionLock l(&m_section);
    m_chainedAllocator.getMemoryStatistics(u);
}

int hkMemorySystem::LockedMemoryAllocator::getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const
{
    hkCriticalSectionLock l(&m_section);
    return m_chainedAllocator.getAllocatedSize(obj, nbytes);
}

void hkMemorySystem::LockedMemoryAllocator::resetPeakMemoryStatistics()
{
    hkCriticalSectionLock l(&m_section);
    m_chainedAllocator.resetPeakMemoryStatistics();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
