// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/Memory/System/Optimizer/hkOptimizerMemorySystem.h>

namespace hkMemoryInitUtil_Optimizer
{
    HK_ALIGN16( static hkUint8 s_buffer[sizeof(hkOptimizerMemorySystem)] );
}

_Ret_notnull_ hkMemoryRouter* HK_CALL hkMemoryInitUtil::initOptimizer(_In_ hkMemoryAllocator *memoryAllocator, const hkMemorySystem::FrameInfo& info)
{
    using namespace hkMemoryInitUtil_Optimizer;
    HK_ASSERT_NO_MSG( 0x3242a432, s_system == HK_NULL );
    hkOptimizerMemorySystem* system = new (s_buffer) hkOptimizerMemorySystem;
    s_system = system;

    system->init( memoryAllocator, outputDebugString, HK_NULL, hkOptimizerMemorySystem::DETECT_ALL );
    hkMemorySystem::replaceInstance( system );

    return system->mainInit( info );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
