// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/Memory/Allocator/Checking/hkLeakDetectAllocator.h>
#include <Common/Base/Memory/System/FreeList/hkFreeListMemorySystem.h>

namespace hkMemoryInitUtil_LeakDetect
{
    struct Buffer
    {
        HK_ALIGN16( hkUint8 m_allocator[sizeof(hkLeakDetectAllocator)] );
        HK_ALIGN16( hkUint8 m_system[sizeof(hkFreeListMemorySystem)] );
    } s_buffer;

    static hkResult onQuit()
    {
        // System already destroyed
        HK_ASSERT_NO_MSG( 0x3242a432, hkMemoryInitUtil::s_system == HK_NULL );

        // Destroy allocator
        {
            hkLeakDetectAllocator* allocator = reinterpret_cast<hkLeakDetectAllocator*>( &s_buffer.m_allocator );
            allocator->quit();
            allocator->~hkLeakDetectAllocator();
        }

        return HK_SUCCESS;
    }
}

_Ret_notnull_ hkMemoryRouter* HK_CALL hkMemoryInitUtil::initLeakDetect(_In_  hkMemoryAllocator *memoryAllocator, const hkMemorySystem::FrameInfo& info)
{
    using namespace hkMemoryInitUtil_LeakDetect;
    HK_ASSERT_NO_MSG( 0x3242a432, s_system == HK_NULL );

    // Init the leak allocator
    hkLeakDetectAllocator* allocator = new (s_buffer.m_allocator) hkLeakDetectAllocator;
    allocator->init( memoryAllocator, memoryAllocator, outputDebugString, HK_NULL );

    // Create memory system, without thread memory
    hkFreeListMemorySystem::SetupFlags flags = hkFreeListMemorySystem::SetupFlags(hkFreeListMemorySystem::DEFAULT_SETUP_FLAGS & ~hkFreeListMemorySystem::USE_THREAD_MEMORY);
    hkFreeListMemorySystem* system = new (s_buffer.m_system) hkFreeListMemorySystem( memoryAllocator, allocator, HK_NULL, flags );
    s_system = system;

    hkMemorySystem::replaceInstance( system );
    s_onQuitFunc = onQuit;

    return system->mainInit( info );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
