// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/Memory/Allocator/FreeList/hkFreeListAllocator.h>
#include <Common/Base/Memory/Allocator/LargeBlock/hkLargeBlockAllocator.h>
#include <Common/Base/Memory/System/FreeList/hkFreeListMemorySystem.h>

HK_DETAIL_DIAG_MSVC_PUSH();

// Some of the deprecated interface passes through here
HK_DETAIL_DIAG_MSVC_OFF(4996);

namespace hkMemoryInitUtil_FreeList
{
    struct Buffer
    {
        HK_ALIGN16( hkUint8 m_largeBlock[sizeof(hkLargeBlockAllocator)] );
        HK_ALIGN16( hkUint8 m_allocator[sizeof(hkFreeListAllocator)] );
        HK_ALIGN16( hkUint8 m_system[sizeof(hkFreeListMemorySystem)] );
    } s_buffer;

    static hkMemoryAllocator* s_largeBlockAllocator = HK_NULL;
    static hkMemoryAllocator* s_freeListAllocator = HK_NULL;

    static hkResult onQuit()
    {
        hkResult result = HK_SUCCESS;

        // System already destroyed
        HK_ASSERT_NO_MSG( 0x3242a432, hkMemoryInitUtil::s_system == HK_NULL );

        // Destroy allocators
        if( s_freeListAllocator )
        {
            hkMemoryAllocator::MemoryStatistics stats;
            s_freeListAllocator->getMemoryStatistics(stats);
            if (stats.m_inUse > 0)
            {
                result = HK_FAILURE;
            }

            s_freeListAllocator->~hkMemoryAllocator();
            s_freeListAllocator = HK_NULL;
        }
        if( s_largeBlockAllocator )
        {
            s_largeBlockAllocator->~hkMemoryAllocator();
            s_largeBlockAllocator = HK_NULL;
        }

        return result;
    }
}

_Ret_notnull_ hkMemoryRouter* HK_CALL hkMemoryInitUtil::initFreeListLargeBlock(_In_ hkMemoryAllocator *memoryAllocator, const hkMemorySystem::FrameInfo& info, _In_opt_ const hkFreeListAllocator::Cinfo* cinfo, hkFreeListMemorySystem::SetupFlags flags )
{
    using namespace hkMemoryInitUtil_FreeList;
    HK_ASSERT_NO_MSG( 0x3242a432, s_system == HK_NULL );

    hkLargeBlockAllocator* largeBlockAllocator = new (s_buffer.m_largeBlock) hkLargeBlockAllocator( memoryAllocator );
    hkFreeListAllocator* allocator = new (s_buffer.m_allocator) hkFreeListAllocator( largeBlockAllocator, largeBlockAllocator, cinfo );
    hkFreeListMemorySystem* system = new (s_buffer.m_system) hkFreeListMemorySystem( memoryAllocator, allocator, allocator, flags );

    s_system = system;
    s_largeBlockAllocator = largeBlockAllocator;
    s_freeListAllocator = allocator;

    hkMemorySystem::replaceInstance( system );
    s_onQuitFunc = onQuit;

    return system->mainInit( info );
}

_Ret_notnull_ hkMemoryRouter* HK_CALL hkMemoryInitUtil::initFreeList(_In_ hkMemoryAllocator *memoryAllocator, _In_opt_ hkMemoryAllocator::ExtendedInterface *memoryAllocatorExtended, const hkMemorySystem::FrameInfo& info, _In_opt_ const hkFreeListAllocator::Cinfo* cinfo, hkFreeListMemorySystem::SetupFlags flags)
{
    using namespace hkMemoryInitUtil_FreeList;
    HK_ASSERT_NO_MSG( 0x3242a432, s_system == HK_NULL );

    hkFreeListAllocator* allocator = new (s_buffer.m_allocator) hkFreeListAllocator( memoryAllocator, memoryAllocatorExtended, cinfo );
    hkFreeListMemorySystem* system = new (s_buffer.m_system) hkFreeListMemorySystem( memoryAllocator, allocator, allocator, flags );

    s_system = system;
    s_freeListAllocator = allocator;

    hkMemorySystem::replaceInstance( system );
    s_onQuitFunc = onQuit;

    return system->mainInit( info );
}

_Ret_notnull_ hkMemoryRouter* HK_CALL hkMemoryInitUtil::initHeapAllocator(_In_ hkMemoryAllocator *memoryAllocator, _In_opt_ hkMemoryAllocator *heapAllocator, _In_opt_ hkMemoryAllocator::ExtendedInterface* heapInterface, const hkMemorySystem::FrameInfo& info)
{
    using namespace hkMemoryInitUtil_FreeList;
    HK_ASSERT_NO_MSG( 0x3242a432, s_system == HK_NULL );

    hkFreeListMemorySystem* system = new (s_buffer.m_system) hkFreeListMemorySystem( memoryAllocator, heapAllocator, heapInterface );
    s_system = system;

    hkMemorySystem::replaceInstance( system );

    return system->mainInit( info );
}

HK_DETAIL_DIAG_MSVC_POP();

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
