// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
#include <Common/Base/Memory/System/Checking/hkCheckingMemorySystem.h>

#include <Common/Base/Memory/Allocator/Checking/hkGuardingAllocator.h>

namespace hkMemoryInitUtil_Checking
{
    HK_ALIGN16( static hkUint8 s_systemBuffer[sizeof(hkCheckingMemorySystem)] );
    HK_ALIGN16( static hkUint8 s_guardingBuffer[sizeof(hkGuardingAllocator)]);
}

_Ret_notnull_ hkMemoryRouter* HK_CALL hkMemoryInitUtil::initChecking(_In_  hkMemoryAllocator *memoryAllocator, const hkMemorySystem::FrameInfo& info, CheckLevel checkLevel)
{
    using namespace hkMemoryInitUtil_Checking;
    HK_ASSERT_NO_MSG( 0x3242a432, s_system == HK_NULL );
    hkCheckingMemorySystem* system = new (s_systemBuffer) hkCheckingMemorySystem;
    s_system = system;

    hkCheckingMemorySystem::CheckBits checkBits = hkCheckingMemorySystem::CHECK_DEFAULT;

    switch (checkLevel)
    {
        case CHECK_NOSTACK:
            checkBits = static_cast<hkCheckingMemorySystem::CheckBits>
                (hkCheckingMemorySystem::CHECK_LEAKS | hkCheckingMemorySystem::CHECK_PAD_BLOCK | hkCheckingMemorySystem::CHECK_DELAYED_FREE);
            break;
        case CHECK_FASTEST:
            checkBits = hkCheckingMemorySystem::CHECK_LEAKS;
            break;
        case CHECK_DEFAULT:
            break;
    }

    system->init( memoryAllocator, outputDebugString, HK_NULL, checkBits );
    hkMemorySystem::replaceInstance( system );

    return system->mainInit( info );
}

_Ret_notnull_ hkMemoryRouter* HK_CALL hkMemoryInitUtil::initGuarding(const hkMemorySystem::FrameInfo& info, CheckLevel checkLevel)
{
    using namespace hkMemoryInitUtil_Checking;
#if defined(HK_PLATFORM_WIN64)
    HK_ASSERT_NO_MSG(0x3242a432, s_system == HK_NULL);
    hkCheckingMemorySystem* system = new (s_systemBuffer) hkCheckingMemorySystem;
    hkMemoryAllocator* memoryAllocator = new (s_guardingBuffer) hkGuardingAllocator;
    s_system = system;

    // We never want CHECK_PAD_BLOCK or CHECK_DELAYED_FREE as this is already taken care of by the guarding allocator.
    hkCheckingMemorySystem::CheckBits checkBits = static_cast<hkCheckingMemorySystem::CheckBits>(hkCheckingMemorySystem::CHECK_LEAKS|hkCheckingMemorySystem::CHECK_CALLSTACK);

    switch (checkLevel)
    {
    case CHECK_NOSTACK:
    case CHECK_FASTEST:
        checkBits = hkCheckingMemorySystem::CHECK_LEAKS;
        break;

    case CHECK_DEFAULT:
        break;
    }

    system->init(memoryAllocator, outputDebugString, HK_NULL, checkBits);
    hkMemorySystem::replaceInstance(system);

    return system->mainInit(info);
#else
    return initChecking(hkMallocAllocator::m_defaultMallocAllocator, info, checkLevel);
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
