// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>
#include <Common/Base/Memory/Allocator/Solver/hkSolverAllocator.h>

    /// Sample memory system which forwards all requests to a single base allocator.
    /// This implementation won't perform well because of contention and has no
    /// provisions for dealing with fragmentation.
class HK_EXPORT_COMMON hkSimpleMemorySystem : public hkMemorySystem
{
    public:
        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));

            /// Set of allocators to use.
            /// Set m_solverAllocator to NULL to use the default hkSolverAllocator
            /// which allocates blocks from m_heapAllocator
        struct HK_EXPORT_COMMON MemoryAllocators
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,MemoryAllocators);
            MemoryAllocators(_In_opt_ hkMemoryAllocator *tempAllocator = HK_NULL, _In_opt_ hkMemoryAllocator *heapAllocator = HK_NULL,
                _In_opt_ hkMemoryAllocator *debugAllocator = HK_NULL, _In_opt_ hkMemoryAllocator *solverAllocator = HK_NULL);

            hkMemoryAllocator* m_tempAllocator;
            hkMemoryAllocator* m_heapAllocator;
            hkMemoryAllocator* m_debugAllocator;
            hkMemoryAllocator* m_solverAllocator;
        };

            ///
        hkSimpleMemorySystem();

        virtual _Ret_notnull_ hkMemoryRouter* mainInit(const FrameInfo& info, Flags f=FLAG_ALL) HK_OVERRIDE;
        virtual hkResult mainQuit(Flags f=FLAG_ALL) HK_OVERRIDE;
        virtual void threadInit(hkMemoryRouter& r, _In_z_ const char* name, Flags f=FLAG_ALL) HK_OVERRIDE;
        virtual void threadQuit(hkMemoryRouter& r, Flags f=FLAG_ALL) HK_OVERRIDE;

            /// Get the aggregated statistics.
        virtual void getMemoryStatistics(MemoryStatistics& stats) HK_OVERRIDE;
            /// Print statistics for the allocators.
        virtual void printStatistics(hkOstream& ostr) const HK_OVERRIDE;

            /// Set the base allocator. The solver allocator will use the default hkSolverAllocator.
            /// Note that memory statistics will be wrong because all allocation types will forward
            /// to this single allocator.
        void setAllocator(_In_ hkMemoryAllocator* a);

            /// This allows settings different allocators for different allocation types.
            /// If a solver allocator is set, the user is responsible for providing it with a buffer
            /// m_solverAllocator = NULL will use the default solver allocator with a buffer from the heap.
        void setAllocators(const MemoryAllocators& allocators);
            /// Get all allocators
        MemoryAllocators& getAllocators();

        virtual _Ret_maybenull_ hkMemoryAllocator* getUncachedLockedHeapAllocator() HK_OVERRIDE;

    protected:

        FrameInfo m_frameInfo;
        hkMemoryRouter m_mainRouter;
        hkSolverAllocator m_solverAllocator;
        MemoryAllocators m_allocators;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
