// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Memory/Allocator/Solver/hkSolverAllocator.h>
#include <Common/Base/Memory/Allocator/TempDetect/hkTempDetectAllocator.h>
#include <Common/Base/Memory/Allocator/Lifo/hkLifoAllocator.h>

    /// Watches memory allocations and suggests ways to improve allocation patterns.
    /// This is slower than the default memory system. It is intended for use in debug mode
    /// to detect situations which could use better memory allocation patterns.
    /// Currently the only check implemented is to suggest heap allocations which should
    /// be moved to temp allocations.
class HK_EXPORT_COMMON hkOptimizerMemorySystem : public hkMemorySystem
{
    public:
        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));

        typedef void (HK_CALL *OutputStringFunc)(_In_z_ const char* s, _In_opt_ void* userData);

        enum DetectBits
        {
            DETECT_NONE = 0,
            DETECT_TEMP = 1,
            DETECT_LIFO = 2,

            DETECT_ALL = DETECT_TEMP | DETECT_LIFO
        };
        typedef hkFlags<DetectBits, hkUint32> DetectFlags;

        struct LifoCheckAllocator : public hkMemoryAllocator
        {
            virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
            virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes) HK_OVERRIDE;
            virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut) HK_OVERRIDE;
            virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
            virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;

            void init(_In_ hkMemoryAllocator* base, OutputStringFunc func, _In_opt_ void* funcArg);
            void quit();
            hkArrayBase<void*> m_allocs;
            hkMemoryAllocator* m_allocator;
            OutputStringFunc m_outputFunc;
            void* m_outputFuncArg;
            hkStackTracer* m_tracer; // borrowed ref from m_tempDetect.m_tracer
        };

        struct ThreadData
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,ThreadData);

            ThreadData() : m_inUse(false), m_next(HK_NULL) {}

            LifoCheckAllocator m_lifoChecker;
            hkBool m_inUse;
            ThreadData* m_next;
        };

        hkOptimizerMemorySystem();

        virtual _Ret_notnull_ hkMemoryRouter* mainInit(const FrameInfo& info, Flags f = FLAG_ALL) HK_OVERRIDE;
        virtual hkResult mainQuit(Flags f=FLAG_ALL) HK_OVERRIDE;
        virtual void threadInit(hkMemoryRouter& r, _In_z_ const char* name, Flags f=FLAG_ALL) HK_OVERRIDE;
        virtual void threadQuit(hkMemoryRouter& r, Flags f=FLAG_ALL) HK_OVERRIDE;

        virtual void getMemoryStatistics(MemoryStatistics& stats) HK_OVERRIDE;
        virtual void printStatistics(hkOstream& ostr) const HK_OVERRIDE;
        virtual void getHeapStatistics(hkMemoryAllocator::MemoryStatistics& stats);

        void init(_In_ hkMemoryAllocator* a, OutputStringFunc output, _In_opt_ void* outputUserData, DetectFlags detect);
        _Ret_maybenull_ hkMemoryAllocator* getAllocator() { return m_baseAllocator; }
        void setAllocator(_In_ hkMemoryAllocator* a) { HK_ASSERT_NO_MSG(0x62b32838, m_baseAllocator==HK_NULL); m_baseAllocator = a; }
        virtual _Ret_maybenull_ hkMemoryAllocator* getUncachedLockedHeapAllocator() HK_OVERRIDE;

    protected:

        FrameInfo m_frameInfo;
        hkMemoryAllocator* m_baseAllocator;
        hkMemoryRouter m_mainRouter;
        hkSolverAllocator m_solverAllocator;
        hkTempDetectAllocator m_tempDetector;
        OutputStringFunc m_outputFunc;
        void* m_outputFuncArg;
        DetectFlags m_detect;

        // Linked list of thread local data. Extra elements can be allocated on demand.
        ThreadData m_threadDatas[8];
        hkCriticalSection m_threadDataCriticalSection;

    private:

        ThreadData& newThreadData();
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
