// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Memory/System/hkMemorySystem.h>

    /// A listener for debug memory system actions
class HK_EXPORT_COMMON hkDebugMemorySystemListener
{
public:
        /// Called when a new allocation is made
    virtual void allocNotify(_In_ const void* p) {}

        /// Called when an allocation is freed
    virtual void deallocNotify(_In_ const void* p) {}

        /// Called during leak report generation when an object leaks
    virtual void leakNotify(_In_ const void* p) {}
};

    /// Interface for debug memory operations.
class HK_EXPORT_COMMON hkDebugMemorySystem : public hkMemorySystem
{
public:

    HK_DECLARE_PLACEMENT_ALLOCATOR();

        /// Override so that the debug methods are accessible.
    virtual hkDebugMemorySystem* getDebugInterface() HK_OVERRIDE { return this; }

        /// Special return values for findBaseAddress.
    enum BaseAddressResuls
    {
            /// The base address for the requested block could not be located.
        ADDRESS_NOT_FOUND = -1,

            /// The hkMemorySystem implementation doesn't support this interface.
        INTERFACE_NOT_SUPPORTED = -2,
    };

        /// Optional interface to search for the originally allocated memory block within
        /// which the supplied memory block is located. This method returns the originally allocated
        /// memory block's base address. It will assert if it cannot find a matching block.
        /// Returns INTERFACE_NOT_SUPPORTED if the operation is not supported.
    virtual _Ret_notnull_ const void* findBaseAddress(_In_bytecount_(nbytes) const void* p, int nbytes) { return (const void*)(INTERFACE_NOT_SUPPORTED); }

        /// Optional interface to ensure block is not freed until unlocked.
        /// Multiple locks stack. If this method is implemented, attempts to free
        /// this block without first unlocking will assert.
    virtual void lockBaseAddress(_In_ const void* baseAddress) = 0;

        /// Optional interface to unlock a previously locked block.
    virtual void unlockBaseAddress(_In_ const void* baseAddress) = 0;

        /// Optional interface to associate a piece of data with an allocation.
        /// The meaning of the tag depends on the caller.
    virtual void tagAddress(_In_ const void* baseAddress, _In_opt_z_ const char* tag) = 0;

        /// Log a user-specified string.
        /// This can be used to help narrow down memory leaks to specific areas.
        /// It is up to the implementation to store the string if desired.
    virtual void addBookmark(_In_z_ const char* bookmarkName) = 0;

        /// Determines whether callstack checking is currently enabled
        /// by the memory system.
    virtual hkBool32 isCheckCallstackEnabled() const = 0;

        /// Turns callstack checking on or off, if the memory system
        /// supports it. Has no effect if the memory system does not
        /// support callstack checking. This function should only be
        /// used to temporarily disable callstack checking; it must
        /// not enable callstack checking if callstack checking was not
        /// initially enabled, and after it is disabled, it must be
        /// reenabled before the memory system is destroyed.
    virtual void setCheckCallstackEnabled(bool enabled) = 0;

        /// Set a listener for memory events.
    virtual void setDebugMemorySystemListener(_In_opt_ hkDebugMemorySystemListener* listener) = 0;

        /// Get the listener to memory events (if any).
    virtual _Ret_maybenull_ hkDebugMemorySystemListener* getDebugMemorySystemListener() = 0;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
