// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#if defined(HK_COMPILER_GCC)
#   define HK_MUST_END_WITH_SEMICOLON
#else
#   define HK_MUST_END_WITH_SEMICOLON class MustEndWithSemiColon
#endif
#define HK_DECLARE_CLASS_NewPlacement(CLASS_NAME) \
    HK_DECLARE_MEMORY_TRACKER_HOOK(CLASS_NAME); \
    HK_INLINE _Ret_notnull_ _Post_writable_size_(nbytes) void* HK_CALL operator new(hk_size_t nbytes, _In_bytecount_(nbytes) void* p) HK_SINGLE_ATTR( hk::Reflect(false) ) { (void)nbytes; return p; } \
    HK_INLINE void HK_CALL operator delete(void*, hk_size_t) HK_SINGLE_ATTR( hk::Reflect(false) ) {} \
    HK_INLINE void HK_CALL operator delete(void*, void*) HK_SINGLE_ATTR( hk::Reflect(false) ) {} \
    HK_MUST_END_WITH_SEMICOLON



#define HK_DECLARE_PLACEMENT_ALLOCATOR() \
    typedef char hkUsesOldMacro; \
    HK_DECLARE_CLASS_NewPlacement(_OldMacroHack)

#include <Common/Base/Thread/Thread/hkThreadLocalData.h>
#include <Common/Base/Memory/Allocator/hkMemoryAllocator.h>
#include <Common/Base/Memory/Allocator/Lifo/hkLifoAllocator.h>

class hkLifoAllocator;
class hkReferencedObject;

class hkOstream;

namespace hkMemory
{
    HK_INLINE hk_size_t HK_CALL numBytesToFree(_In_bytecount_(nbytes) const void* obj, hk_size_t nbytes) { return nbytes; }
    _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL heapBlockAlloc(hk_size_t nbytes);
    void HK_CALL heapBlockFree(_In_opt_bytecount_(nbytes) void* p, hk_size_t nbytes);
}

    /// All Havok allocations are routed through hkMemoryRouter.
    /// Generally, each thread has a thread-local hkMemoryRouter instance which
    /// is initialized by the hkMemorySystem.
class HK_EXPORT_COMMON hkMemoryRouter
{
    public:
        HK_DECLARE_PLACEMENT_ALLOCATOR();
        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));

        typedef hkLifoAllocator Stack;

        typedef hkMemoryAllocator Allocator;

            /// Set the thread-local instance pointer to the supplied router.
            /// Note that instances are not ref counted and the caller is responsible for cleanup.
        static void HK_CALL replaceInstance(_In_ hkMemoryRouter* m);

            /// Set a global instance pointer to be used as a fallback if the per-thread instance is not set.
            /// Note that instances are not ref counted and the caller is responsible for cleanup.
        static void HK_CALL replaceFallbackInstance(_In_ hkMemoryRouter* m);

            /// Access the thread-local instance or the global fallback instance if the per-thread instance is not set.
            /// To set the global fallback instance see 'replaceFallbackInstance' or 's_fallbackRouter'.
        static inline hkMemoryRouter& HK_CALL getInstance();

            /// Access the thread-local instance.
            /// Note that this will still return null even if the global fallback instance is set.
        static inline _Ret_maybenull_ hkMemoryRouter* HK_CALL getInstancePtr();

            /// Construct an empty object.
        hkMemoryRouter();

            ///
        void resetPeakMemoryStatistics();

            /// Small thread local allocation in a stack pattern.
        inline Stack& stack() { return m_stack; }

            /// Temporary allocation, thread local. Often but not always in a stack pattern.
            /// Do not store the reference returned to this method if it might be used by a different thread.
        inline Allocator& temp() { return *m_temp; }
            ///
        inline void setTemp(_In_ Allocator* a) { m_temp = a; }

            /// Allocation which is likely to persist. Not thread local.
            /// Do not store the reference returned to this method if it might be used by a different thread. Use
            /// hkMemHeapAllocator instead to get a persistent pointer to the heap allocator.
        inline Allocator& heap() { return *m_heap; }
            ///
        inline void setHeap(_In_ Allocator* a) { m_heap = a; }

            /// Allocation which may break the rules. Not thread local.
            /// Do not store the reference returned to this method if it might be used by a different thread.
        inline Allocator& debug() { return *m_debug; }
            ///
        inline void setDebug(_In_ Allocator* a) { m_debug = a; }

            /// Allocator for the constraint solver. These may request large contiguous and frame local blocks.
            /// Do not store the reference returned to this method if it might be used by a different thread.
        inline Allocator& solver() { return *m_solver; }
            ///
        inline void setSolver(_In_ Allocator* a) { m_solver = a; }

            /// User data pointer, often used by the hkMemorySystem.
        inline _Ret_maybenull_ void* getUserData() const { return m_userData; }

            ///
        inline void setUserData(_In_opt_ void* p) { m_userData = p; }

            /// Helper to align an allocation request, note that the corresponding free method must be used.
        static _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL alignedAlloc(Allocator& b, int nbytes, int align);

            /// Free a block allocated with alignedAlloc.
        static void HK_CALL alignedFree( Allocator& b, _In_opt_ void* p );

        static void* HK_CALL alignedRealloc(Allocator& b, void* pold, int oldSize, int newSize, int alignment);

            /// Get the start address of the aligned allocation.
        static _Ret_notnull_ const void* HK_CALL getAlignedAllocStartAddress(Allocator& b, _In_ const void* ptr);

        static int HK_CALL getAlignedAllocatedSize(Allocator& b, const void* ptr, int nbytes);

            /// Helper to make an allocation which remembers the size internally.
        static _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL easyAlloc( Allocator& b, int nbytes );
            /// Returns the size of an 'easyAlloc' allocation.
        static hk_size_t HK_CALL getEasyAllocSize(Allocator& b, _In_ const void* ptr);
            /// Get the start address of the 'easyAlloc' allocation.
        static _Ret_notnull_ const void* HK_CALL getEasyAllocStartAddress(Allocator& b, _In_ const void* ptr);

            /// Free a block allocated with easyAlloc.
        static void HK_CALL easyFree( Allocator& b, _In_opt_ void* p );

        static HK_INLINE hk_size_t numBytesToFree(_In_opt_ const void* obj, hk_size_t nbytes)
        {
            return nbytes;
        }
        static HK_INLINE hk_size_t numBytesToFree(_In_ const hkReferencedObject* obj, hk_size_t nbytes);

        /// Calls advanceFrame on all allocator in this instance.
        void advanceFrame();

        /// Calls pushFrame on all allocator in this instance.
        void pushFrame();

        /// Calls popFrame on all allocator in this instance.
        void popFrame();

    protected:

        Stack m_stack;

        Allocator* m_temp;      ///< frame local allocations
        Allocator* m_heap;      ///< longer than frame local
        Allocator* m_debug;     ///< monitors, debugmem,
        Allocator* m_solver;    ///< special frame local allocator for Physics 2012's solver buffer, see hkSolverAllocator for details
        void* m_userData;

        static HK_THREAD_LOCAL(hkMemoryRouter*) s_memoryRouter;
    public:
        static hkMemoryRouter* s_fallbackRouter; ///< Optionally used as a fallback if no thread-local router is configured
};

inline hkMemoryRouter& HK_CALL hkMemoryRouter::getInstance()
{
    hkMemoryRouter* router = HK_THREAD_LOCAL_GET(s_memoryRouter);
    if (!router)
    {
        router = s_fallbackRouter;
    }
    return *router;
}
inline _Ret_maybenull_ hkMemoryRouter* HK_CALL hkMemoryRouter::getInstancePtr()
{
    return HK_THREAD_LOCAL_GET(s_memoryRouter);
}

/// A scope guard for a memory router sub-frame (or sequence of sub-frames). It
/// pushes the current frame onto the frame stack in its constructor and pops it
/// from the stack in it's destructor.
class hkMemoryRouterSubframeGuard
{
public:
    inline hkMemoryRouterSubframeGuard(hkMemoryRouter* memoryRouter)
        : m_memoryRouter(memoryRouter)
    {
        m_memoryRouter->pushFrame();
    }

    inline ~hkMemoryRouterSubframeGuard()
    {
        m_memoryRouter->popFrame();
    }

private:
    hkMemoryRouter* m_memoryRouter;
};

#if defined(HK_MEMORY_TRACKER_ENABLE)
    #include <Common/Base/Memory/Tracker/hkMemoryTracker.h>

    // Use when a function has a parameter that is only used when
    // memory tracking is enabled. Necessary to avoid warnings.
    #define HK_MEMORY_TRACKER_PARAMETER(PARAM) PARAM

    // Add a typed memory block.
    #define HK_MEMORY_TRACKER_ADD(TYPE_NAME, OBJ) \
        if( hkMemoryTracker* _trk = hkMemoryTracker::getInstancePtr() ) \
            _trk->addTyped( #TYPE_NAME, static_cast<TYPE_NAME*>(OBJ) )

    // Add a typed memory block with explicit info.
    #define HK_MEMORY_TRACKER_ADD_EXPLICIT(TYPE_NAME, OBJ, ...) \
        if( hkMemoryTracker* _trk = hkMemoryTracker::getInstancePtr() ) \
            _trk->addTyped( #TYPE_NAME, static_cast<TYPE_NAME*>(OBJ), __VA_ARGS__ )

    // Add a raw (no type) memory block.
    #define HK_MEMORY_TRACKER_ADD_RAW(NAME,PTR,SIZE) \
        if( hkMemoryTracker* _trk = hkMemoryTracker::getInstancePtr() ) \
            _trk->addBlock(NAME, hkMemoryTracker::BlockType(), PTR, SIZE, true)

    // Add a memory block passing the block type directly.
    #define HK_MEMORY_TRACKER_ADD_MANUAL(NAME, TYPE_PTR, OBJ, SIZE, ON_HEAP) \
        if( hkMemoryTracker* _trk = hkMemoryTracker::getInstancePtr() ) \
            _trk->addBlock( NAME, TYPE_PTR, OBJ, SIZE, ON_HEAP )

    // Remove a memory block
    #define HK_MEMORY_TRACKER_REMOVE(OBJ) \
        if( hkMemoryTracker* _trk = hkMemoryTracker::getInstancePtr() ) _trk->removeBlock(OBJ)

    
    #define HK_MEMORY_TRACKER_REMOVE_RAW(PTR) HK_MEMORY_TRACKER_REMOVE(PTR)
#else
#   if defined(HK_DEBUG_SLOW)
#       define HK_MEMORY_TRACKER_PARAMETER(PARAM) PARAM
#   else
#       define HK_MEMORY_TRACKER_PARAMETER(PARAM)
#   endif
    #define HK_MEMORY_TRACKER_ADD(TYPE_NAME, OBJ)
    #define HK_MEMORY_TRACKER_ADD_EXPLICIT(TYPE_NAME, OBJ, ...)
    #define HK_MEMORY_TRACKER_ADD_MANUAL(NAME, TYPE_PTR, OBJ, SIZE, ON_HEAP)
    #define HK_MEMORY_TRACKER_REMOVE(OBJ)
    #define HK_MEMORY_TRACKER_ADD_RAW(NAME,PTR,SIZE)
    
    #define HK_MEMORY_TRACKER_REMOVE_RAW(PTR)
#endif

#if defined(HK_COMPILER_ARMCC)
    #define HK_OPERATOR_DELETE
    #define HK_OPERATOR_NONVIRTUAL_DELETE
#else
    #define HK_OPERATOR_DELETE \
        HK_INLINE void HK_CALL operator delete(void*, void*) HK_SINGLE_ATTR( hk::Reflect(false) ) { } \
        HK_INLINE void HK_CALL operator delete[](void*, void*) HK_SINGLE_ATTR( hk::Reflect(false) ) { HK_BREAKPOINT(0); }
    #define HK_OPERATOR_NONVIRTUAL_DELETE \
        HK_INLINE void HK_CALL operator delete(void*, void*) HK_SINGLE_ATTR( hk::Reflect(false) ) { } \
        HK_INLINE void HK_CALL operator delete[](void*, void*) HK_SINGLE_ATTR( hk::Reflect(false) ) { }
#endif


HK_DETAIL_DIAG_CLANG_PUSH()
HK_DETAIL_DIAG_CLANG_OFF(c++11-extensions)

#if 1
#define HK_DECLARE_CLASS_ALLOCATOR_UNCHECKED(MEMORY_CLASS, ALLOCATOR) \
        typedef char hkUsesOldMacro; \
        HK_DECLARE_MEMORY_TRACKER_HOOK(_OldMacroHack); \
        HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new(hk_size_t nbytes) HK_SINGLE_ATTR( hk::Reflect(false) ) { \
            HK_ASSERT_OBJECT_SIZE_OK(nbytes); \
            hkReferencedObject* b = static_cast<hkReferencedObject*>(hkMemoryRouter::getInstance().ALLOCATOR().blockAlloc(static_cast<int>(nbytes))); \
            HK_MEMORY_TRACKER_ADD_MANUAL("!", HK_TRACKER_GET_HANDLE_UNCHECKED(typename _OldMacroHack::_TrackerType), b, nbytes, true); \
            return b; } \
        HK_INLINE void HK_CALL operator delete(_In_opt_bytecount_(nbytes) void* p, hk_size_t nbytes) HK_SINGLE_ATTR( hk::Reflect(false) ) { \
            const hkReferencedObject* b = static_cast<hkReferencedObject*>(p); \
            HK_MEMORY_TRACKER_REMOVE( p ); \
            hkMemoryRouter::getInstance().ALLOCATOR().blockFree(p, (b->getMemorySizeAndFlags() == hkReferencedObject::AUTO_MEMSIZE) ? static_cast<int>(nbytes) : b->getMemorySizeAndFlags()); } \
        HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new(hk_size_t nbytes, _In_bytecount_(nbytes) void* p) HK_SINGLE_ATTR( hk::Reflect(false) ) { (void)nbytes; return p; } \
        HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new[](hk_size_t nbytes, _In_bytecount_(nbytes) void* p) HK_SINGLE_ATTR( hk::Reflect(false) ) { HK_BREAKPOINT(0); (void)nbytes; return p; } \
        HK_OPERATOR_DELETE
#define HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR_BY_SIZE_UNCHECKED(MEMORY_CLASS, CLASS_NAME, ALLOCATOR) \
        HK_DECLARE_MEMORY_TRACKER_HOOK(CLASS_NAME); \
        HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new(hk_size_t nbytes) HK_SINGLE_ATTR( hk::Reflect(false) ) { \
            (void)nbytes; \
            HK_ASSERT_SLOW(0x6c787b7f, nbytes == sizeof(CLASS_NAME), "Incorrect allocation size. Check that the most derived class has an allocator declaration" ); \
            void* obj = hkMemoryRouter::getInstance().ALLOCATOR().blockAlloc(sizeof(CLASS_NAME)); \
            HK_MEMORY_TRACKER_ADD_MANUAL(#CLASS_NAME, HK_TRACKER_GET_HANDLE_UNCHECKED(CLASS_NAME), obj, nbytes, true); \
            return obj; }   \
        HK_INLINE void HK_CALL operator delete(_In_opt_bytecount_(nbytes) void* p, hk_size_t nbytes) HK_SINGLE_ATTR( hk::Reflect(false) ) { \
            (void)nbytes; \
            if (p) { \
                HK_ASSERT_SLOW(0x6c787b7f, nbytes == sizeof(CLASS_NAME), "Incorrect deallocation size. Check that the most derived class has an allocator declaration" ); \
                HK_MEMORY_TRACKER_REMOVE( static_cast<CLASS_NAME*>(p) ); \
                hkMemoryRouter::getInstance().ALLOCATOR().blockFree(p, sizeof(CLASS_NAME)); \
            } }\
        HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new(hk_size_t nbytes, _In_bytecount_(nbytes) void* p) HK_SINGLE_ATTR( hk::Reflect(false) ) { (void)nbytes; HK_ASSERT_SLOW(0x77bb90a1, nbytes == sizeof(CLASS_NAME), "Incorrect allocation size. Check that the most derived class has an allocator declaration"); return p; } \
        HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new[](hk_size_t nbytes, _In_bytecount_(nbytes) void* p) HK_SINGLE_ATTR( hk::Reflect(false) ) { (void)nbytes; return p; } \
        HK_OPERATOR_NONVIRTUAL_DELETE
    #define HK_DECLARE_CLASS_ALLOCATOR(A) HK_DECLARE_CLASS_ALLOCATOR_UNCHECKED(A,heap)
    #define HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(MC,CT) HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR_BY_SIZE_UNCHECKED(MC, CT, heap)
    #define HK_DECLARE_CLASS_DEBUG_ALLOCATOR(A) HK_DECLARE_CLASS_ALLOCATOR_UNCHECKED(A,debug)
    #define HK_DECLARE_NONVIRTUAL_CLASS_DEBUG_ALLOCATOR(MC,CT) HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR_BY_SIZE_UNCHECKED(MC, CT, heap)
#endif

#define HK_DECLARE_CLASS_AllocatorInternalDontUse(CLASS_NAME, TRACKER_TYPE) \
    HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new(hk_size_t nbytes) HK_SINGLE_ATTR( hk::Reflect(false) ) \
    { \
        CLASS_NAME* obj = static_cast<CLASS_NAME*>( hkMemoryRouter::getInstance().heap().blockAlloc(static_cast<int>(nbytes))); \
        HK_MEMORY_TRACKER_ADD_MANUAL(#CLASS_NAME, TRACKER_TYPE, obj, nbytes, true); \
        return obj; \
    } \
    HK_INLINE void HK_CALL operator delete(_In_opt_bytecount_(nbytes) void* p, hk_size_t nbytes) HK_SINGLE_ATTR( hk::Reflect(false) ) \
    { \
        if(p) \
        { \
            HK_MEMORY_TRACKER_REMOVE( static_cast<CLASS_NAME*>(p) ); \
            hkMemoryRouter::getInstance().heap().blockFree(p, static_cast<int>(hkMemoryRouter::numBytesToFree( static_cast<CLASS_NAME*>(p), nbytes)) ); \
        } \
    } \
    HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new(hk_size_t nbytes, _In_bytecount_(nbytes) void* p) HK_SINGLE_ATTR( hk::Reflect(false) ) { (void)nbytes; return p; } \
    HK_INLINE _Ret_notnull_ _Post_writable_byte_size_(nbytes) void* HK_CALL operator new[](hk_size_t nbytes, _In_bytecount_(nbytes) void* p) HK_SINGLE_ATTR( hk::Reflect(false) ) { HK_BREAKPOINT(0); (void)nbytes; return p; } \
    HK_OPERATOR_DELETE

    /// Default allocator macro. Overrides operators new and delete so that they use the Havok heap. Calls
    /// to new/delete will be tracked by the hkMemoryTracker  if enabled. If the class is not a template,
    /// instances will be explorable for outgoing pointers (use NewTemplate to achieve the same behavior on templates).
#define HK_DECLARE_CLASS_New(CLASS_NAME) \
    HK_DECLARE_CLASS_AllocatorInternalDontUse(CLASS_NAME, HK_TRACKER_GET_HANDLE_UNCHECKED(CLASS_NAME)); \
    HK_DECLARE_MEMORY_TRACKER_HOOK(CLASS_NAME)

    /// Overrides operators new and delete so that they use the Havok heap.
    /// Use this macro for template classes which need to be explorable by the hkMemoryTracker.
    /// A tracker layout will be generated for the class in <project_path>/_Auto/TemplateTypes/<filename>_Types.inl.
    /// The generated file must be included in the class header.
#define HK_DECLARE_CLASS_NewTemplate(CLASS_NAME) \
    HK_DECLARE_CLASS_AllocatorInternalDontUse(CLASS_NAME, HK_TRACKER_GET_HANDLE_UNCHECKED(CLASS_NAME)); \
    HK_DECLARE_MEMORY_TRACKER_HOOK_TEMPLATE(CLASS_NAME)

    /// Overrides operators new and delete so that they use the Havok heap. Use this macro if instances of the class
    /// must not be explored by the hkMemoryTracker.
#define HK_DECLARE_CLASS_NewOpaque(CLASS_NAME) \
    HK_DECLARE_CLASS_AllocatorInternalDontUse(CLASS_NAME, HK_REFLECT_GET_TYPE(hkReflect::Detail::Opaque)) \
    HK_SINGLE_RECORD_ATTR(hk::MemoryTracker(opaque=true))

// Manual tracking macros.
#ifdef HK_MEMORY_TRACKER_ENABLE

        /// Overrides operators new and delete so that they use the Havok heap. Use this macro together with
        /// HK_MEMORY_TRACKER_MANUAL_* to define a tracker layout for the class manually when the class is not visible
        /// to hkPreBuild.
        /// E.g.:
        /// MyStruct.h:
        ///     struct MyStruct : public MyParent { HK_DECLARE_CLASS(MyStruct, NewManual); void* a; int b; hkArray<char> c; };
        ///     template<typename T, int I> MyTemplate { HK_DECLARE_CLASS(MyTemplate, NewManual); T* a; };
        /// MyStruct.cpp:
        ///     HK_MEMORY_TRACKER_MANUAL_BEGIN(2, MyStruct);
        ///         HK_MEMORY_TRACKER_MANUAL_PARENT(MyParent);
        ///         HK_MEMORY_TRACKER_MANUAL_FIELD(a, void*);
        ///         HK_MEMORY_TRACKER_MANUAL_FIELD(c, hkArray<char>);
        ///     HK_MEMORY_TRACKER_MANUAL_END();
        /// MyStruct.inl:
        ///     HK_MEMORY_TRACKER_MANUAL_BEGIN_TEMPLATE((typename T, int I), 1, MyTemplate);
        ///         HK_MEMORY_TRACKER_MANUAL_FIELD(a, T*);
        ///     HK_MEMORY_TRACKER_MANUAL_END();
    #define HK_DECLARE_CLASS_NewManual(CLASS_NAME) \
        HK_DECLARE_CLASS_AllocatorInternalDontUse(CLASS_NAME, HK_TRACKER_GET_HANDLE_UNCHECKED(CLASS_NAME)); \
        struct _OldMacroHack { typedef CLASS_NAME _TrackerType; }; \
        typedef hkReflect::Detail::NotTracked ManualTrackerParent; \
        static hkReflect::Detail::TrackerRegNode ManualTrackerRegNode; \
        static hkUint16 _trackerValue; \
        static hkUlong ManualTrackerDefine()

        /// Begins a manual tracker layout.
    #define HK_MEMORY_TRACKER_MANUAL_BEGIN(NUM_FIELDS, ...) \
        HK_MT_DETAIL_REG(__VA_ARGS__); \
        HK_MT_DETAIL_HANDLE(__VA_ARGS__); \
        HK_MT_DETAIL_BEGIN(NUM_FIELDS, __VA_ARGS__)

        /// Begins a manual tracker layout for a template type.
        /// Note: TEMPLATE_PARAMS must be wrapped in parentheses, e.g. (typename T, int I).
    #define HK_MEMORY_TRACKER_MANUAL_BEGIN_TEMPLATE(TEMPLATE_PARAMS, NUM_FIELDS, ...) \
        template< HK_MT_DETAIL_UNWRAP TEMPLATE_PARAMS > \
        HK_MT_DETAIL_REG(__VA_ARGS__); \
        template< HK_MT_DETAIL_UNWRAP TEMPLATE_PARAMS > \
        HK_MT_DETAIL_HANDLE(__VA_ARGS__); \
        template< HK_MT_DETAIL_UNWRAP TEMPLATE_PARAMS > \
        HK_MT_DETAIL_BEGIN(NUM_FIELDS, __VA_ARGS__)

    #define HK_MT_DETAIL_BEGIN(NUM_FIELDS, ...) \
        hkUlong __VA_ARGS__::ManualTrackerDefine() \
        { \
            typedef __VA_ARGS__ ManualTrackerType; \
            static const char* manualTrackerName = #__VA_ARGS__; \
            static hkReflect::Detail::FixedArrayStorage<hkReflect::Detail::DeclsArray::Head, const hkReflect::Type*, NUM_FIELDS> manualTrackerDecls = \
            { \
                { NUM_FIELDS, 0, NUM_FIELDS, 0 }, { \
                    HK_PP_FOR(NUM_FIELDS, HK_MT_DETAIL_NULL) \
                } \
            }; \
            int manualTrackerIdx = 0

        /// Specifies a parent type for the current layout.
    #define HK_MEMORY_TRACKER_MANUAL_PARENT(...) HK_MT_DETAIL_PARENT(__VA_ARGS__)

        /// Adds a field to current layout.
    #define HK_MEMORY_TRACKER_MANUAL_FIELD(FIELD_NAME, ...) \
            static hkReflect::Detail::TypeData FIELD_NAME ## _typeData = \
            { \
                HK_FILTER_REFLECT_OPT(hkReflect::Opt::DECL_FORMAT), \
                (hkUlong)HK_TRACKER_GET_HANDLE(__VA_ARGS__), \
                HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECL_FORMAT, ((hkReflect::Decl::DECL_DATA_FIELD) << 16) | HK_ROFFSET_OF(FIELD_NAME, ManualTrackerType)), \
            }; \
            HK_ASSERT_NO_MSG(0x3b2ab7f6, manualTrackerIdx < HK_COUNT_OF(manualTrackerDecls.m_items)); \
            manualTrackerDecls.m_items[manualTrackerIdx++] = reinterpret_cast<const hkReflect::Type*>(&FIELD_NAME ## _typeData)

        /// Ends the current layout.
    #define HK_MEMORY_TRACKER_MANUAL_END() \
            HK_ASSERT_NO_MSG(0x9392090, manualTrackerIdx == HK_COUNT_OF(manualTrackerDecls.m_items)); \
            static hkReflect::Detail::TypeData manualTypeData = \
            { \
                HK_FILTER_REFLECT_OPT(hkReflect::Opt::FORMAT | hkReflect::Opt::NAME | hkReflect::Opt::SIZE_ALIGN | hkReflect::Opt::DECLS), \
                (hkUlong)HK_TRACKER_GET_HANDLE(ManualTrackerParent), \
                HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::FORMAT, hkReflect::Format::OfOpaque::Value), \
                HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::NAME, manualTrackerName), \
                HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::SIZE_ALIGN, sizeof(ManualTrackerType)), \
                HK_REFLECT_TYPE_OPTIONAL(hkReflect::Opt::DECLS, reinterpret_cast<const hkReflect::Detail::DeclsArray*>(&manualTrackerDecls)), \
            }; \
            return (hkUlong)manualTypeData; \
        }

    #define HK_MT_DETAIL_REG(...) \
        hkReflect::Detail::TrackerRegNode __VA_ARGS__::ManualTrackerRegNode(reinterpret_cast<hkUlong*>(ManualTrackerDefine()), \
            HK_TRACKER_GET_HANDLE_UNCHECKED(__VA_ARGS__), true)

    #define HK_MT_DETAIL_HANDLE(...) \
        hkUint16 __VA_ARGS__::_trackerValue = (hkUint16)(hkUlong)&__VA_ARGS__::ManualTrackerRegNode /* prevent stripping */

#ifdef HK_COMPILER_MSVC
    #define HK_MT_DETAIL_PARENT(...) \
        HK_DETAIL_DIAG_MSVC_PUSH() \
        HK_DETAIL_DIAG_MSVC_OFF(4458) \
        typedef __VA_ARGS__ ManualTrackerParent; \
        HK_DETAIL_DIAG_MSVC_POP()
#else
    #define HK_MT_DETAIL_PARENT(...) typedef __VA_ARGS__ ManualTrackerParent
#endif

    #define HK_MT_DETAIL_NULL(I) HK_NULL,
    #define HK_MT_DETAIL_UNWRAP(...) __VA_ARGS__

#else
    #define HK_DECLARE_CLASS_NewManual(CLASS_NAME) \
        HK_DECLARE_CLASS_AllocatorInternalDontUse(CLASS_NAME, 0);
    #define HK_MEMORY_TRACKER_MANUAL_BEGIN(NUM_FIELDS, ...)
    #define HK_MEMORY_TRACKER_MANUAL_BEGIN_TEMPLATE(TEMPLATE_PARAMS, NUM_FIELDS, ...)
    #define HK_MEMORY_TRACKER_MANUAL_PARENT(...)
    #define HK_MEMORY_TRACKER_MANUAL_FIELD(...)
    #define HK_MEMORY_TRACKER_MANUAL_END(...)
#endif

    /// As New, reuse the tracker layout of another type (specified with TrackAs).
    /// Normally called from HK_DECLARE_CLASS(..., NewExplicit, TrackAs(SomeOtherType), ...).
#define HK_DECLARE_CLASS_NewExplicit(CLASS_NAME) \
    HK_DECLARE_CLASS_AllocatorInternalDontUse(CLASS_NAME, HK_TRACKER_GET_HANDLE(typename _OldMacroHack::_TrackerType))

    /// Specify the type whose tracker layout must be reused. Use with NewExplicit.
#define HK_DECLARE_CLASS_TrackAs(...) \
    struct _OldMacroHack { typedef __VA_ARGS__ _TrackerType; }; HK_PP_IGNORE_ARGS


namespace hkReflect { namespace Detail {
    // Dummy type, used to flatten the layout of common containers.
    struct GenericArray
    {
        HK_DECLARE_CLASS(GenericArray, New);
        void* ptr;
        int size1;
        int size2;
    };
} }

// Deprecated functions

    /// Deprecated, use one of the hkMem*Alloc functions.
    template <typename TYPE>
    HK_INLINE _Ret_notnull_ _Post_writable_size_(numberOfObjects) TYPE* HK_CALL hkAllocate(int numberOfObjects, int cl)
    {
        hkMemoryRouter& a = hkMemoryRouter::getInstance();
        return static_cast<TYPE*>( hkMemoryRouter::easyAlloc( a.heap(), numberOfObjects*hkSizeOfTypeOrVoid<TYPE>::val ));
    }

    /// Convenience inline function to deallocate memory of the correct type
    template <typename TYPE>
    HK_INLINE void HK_CALL hkDeallocate(_In_opt_ TYPE* ptr)
    {
        hkMemoryRouter& a = hkMemoryRouter::getInstance();
        hkMemoryRouter::easyFree( a.heap(), static_cast<void *>(ptr));
    }

    /// Convenience inline function to allocate aligned memory of the correct type
    template <typename TYPE>
    HK_INLINE _Ret_notnull_ _Post_writable_size_(numberOfObjects) TYPE* HK_CALL hkAlignedAllocate(int alignment, int numberOfObjects, int cl)
    {
        hkMemoryRouter& a = hkMemoryRouter::getInstance();
        return static_cast<TYPE*>( hkMemoryRouter::alignedAlloc(a.heap(), numberOfObjects*hkSizeOfTypeOrVoid<TYPE>::val, alignment));
    }

    /// Convenience inline function to deallocate memory of the correct type
    template <typename TYPE>
    HK_INLINE void HK_CALL hkAlignedDeallocate(_In_opt_ TYPE* ptr)
    {
        hkMemoryRouter& a = hkMemoryRouter::getInstance();
        hkMemoryRouter::alignedFree( a.heap(), static_cast<void *>(ptr));
    }

    /// Convenience function to allocate memory of the correct type
    template <typename TYPE>
    HK_INLINE _Ret_notnull_ _Post_writable_size_(numberOfObjects) TYPE* HK_CALL hkAllocateChunk(int numberOfObjects, int cl)
    {
        return static_cast<TYPE*>(hkMemoryRouter::getInstance().heap().blockAlloc(numberOfObjects*hkSizeOfTypeOrVoid<TYPE>::val));
    }

    /// Convenience function to deallocate memory of the correct type
    template <typename TYPE>
    HK_INLINE void HK_CALL hkDeallocateChunk(_In_opt_bytecount_(_Inexpressible_()) TYPE* ptr, int numberOfObjects, int cl)
    {
        hkMemoryRouter::getInstance().heap().blockFree(static_cast<void*>(ptr), numberOfObjects*hkSizeOfTypeOrVoid<TYPE>::val);
    }

    


    template <typename TYPE>
    HK_INLINE _Ret_notnull_ _Post_writable_size_(n) TYPE* HK_CALL hkAllocateStack(int n, _In_opt_ const char* what=HK_NULL )
    {
        hkMemoryRouter& mem = hkMemoryRouter::getInstance();
        return static_cast<TYPE*>(mem.stack().fastBlockAlloc(HK_NEXT_MULTIPLE_OF(128,n*hkSizeOfTypeOrVoid<TYPE>::val)));
    }

    template <typename TYPE>
    HK_INLINE bool HK_CALL hkShrinkAllocatedStack(_In_opt_bytecount_(_Inexpressible_()) TYPE* ptr, int n)
    {
        return false;
    }

    template <typename TYPE>
    HK_INLINE void HK_CALL hkDeallocateStack(_In_opt_bytecount_(_Inexpressible_()) TYPE* ptr, int n)
    {
        hkMemoryRouter::getInstance().stack().fastBlockFree(static_cast<void*>(ptr), HK_NEXT_MULTIPLE_OF(128,n*hkSizeOfTypeOrVoid<TYPE>::val));
    }

// end deprecated


    // For each allocator, define helper functions to allocate and free memory blocks, create and destroy objects.
#define HK_TEMPLATE_ALLOCATOR(POOL, pool, TRACK) \
    template <typename TYPE> HK_INLINE _Ret_notnull_ _Post_writable_size_(n) TYPE* HK_CALL hkMem##POOL##BlockAlloc(int n) \
    { \
        return hkMemoryRouter::getInstance().pool()._blockAlloc<TYPE>( n ); \
    } \
    template <typename TYPE> HK_INLINE void HK_CALL hkMem##POOL##BlockFree(_In_opt_count_(n) TYPE* t, int n) \
    { \
        hkMemoryRouter::getInstance().pool()._blockFree<TYPE>( t, n ); \
    } \
    template <typename TYPE> HK_INLINE _Ret_notnull_ _Post_writable_size_(reqInOut) TYPE* HK_CALL hkMem##POOL##BufAlloc(int& reqInOut) \
    { \
        return hkMemoryRouter::getInstance().pool()._bufAlloc<TYPE>( reqInOut ); \
    } \
    template <typename TYPE> HK_INLINE void HK_CALL hkMem##POOL##BufFree(_In_opt_count_(n) TYPE* t, int n) \
    { \
        hkMemoryRouter::getInstance().pool()._bufFree<TYPE>( t, n ); \
    } \
    template <typename TYPE> HK_INLINE _Ret_notnull_ _Post_writable_size_(reqInOut) TYPE* HK_CALL hkMem##POOL##BufRealloc(_In_reads_(nold) TYPE* t, int nold, int& reqInOut) \
    { \
        return hkMemoryRouter::getInstance().pool()._bufRealloc<TYPE>( t, nold, reqInOut ); \
    } \
    HK_DETAIL_MEM_CREATE(POOL, TRACK, 0) \
    HK_DETAIL_MEM_CREATE(POOL, TRACK, 1) \
    HK_DETAIL_MEM_CREATE(POOL, TRACK, 2) \
    HK_DETAIL_MEM_CREATE(POOL, TRACK, 3) \
    HK_DETAIL_MEM_CREATE(POOL, TRACK, 4) \
    HK_DETAIL_MEM_CREATE(POOL, TRACK, 5) \
    HK_DETAIL_MEM_CREATE(POOL, TRACK, 6) \
    template <typename TYPE> \
    inline void HK_CALL hkMem##POOL##Destroy(_In_opt_ TYPE* obj) \
    { \
        if (obj) \
        { \
            HK_PREPROCESSOR_IF(TRACK, HK_MEMORY_TRACKER_REMOVE(obj),); \
            hkMem##POOL##BlockFree<TYPE>(obj, 1); \
        } \
    }

#define HK_DETAIL_MEM_CREATE(POOL, TRACK, ARG_NUM) \
    template <typename TYPE HK_PP_FOR(ARG_NUM, HK_DETAIL_MEM_CREATE_TPARAM)> \
    inline _Ret_notnull_ TYPE* HK_CALL hkMem##POOL##Create(HK_PP_FOR(ARG_NUM, HK_DETAIL_MEM_CREATE_PARAM)) \
    { \
        TYPE* obj = hkMem##POOL##BlockAlloc<TYPE>(1); \
        HK_PREPROCESSOR_IF(TRACK, HK_MEMORY_TRACKER_ADD(TYPE, obj),); \
        return new (reinterpret_cast<hkPlacementNewArg*>(obj)) TYPE(HK_PP_FOR(ARG_NUM, HK_DETAIL_MEM_CREATE_ARG)); \
    }
#define HK_DETAIL_MEM_CREATE_TPARAM(I) , typename P ## I
#define HK_DETAIL_MEM_CREATE_PARAM(I) P ## I p ## I HK_PP_COMMA_IF(I)
#define HK_DETAIL_MEM_CREATE_ARG(I) p ## I HK_PP_COMMA_IF(I)

HK_TEMPLATE_ALLOCATOR(Debug, debug, 0)
HK_TEMPLATE_ALLOCATOR(Solver, solver, 0)
HK_TEMPLATE_ALLOCATOR(Heap, heap, 1)
HK_TEMPLATE_ALLOCATOR(Temp, temp, 0)

    /// Returns a pointer to the heap allocator. Safe to use from different threads.
HK_EXPORT_COMMON _Ret_notnull_ hkMemoryAllocator* HK_CALL hkMemHeapAllocator();

#if defined(HK_DEBUG_SLOW) && !defined(HK_PLATFORM_NX)
extern HK_EXPORT_COMMON void HK_CALL HK_ASSERT_OBJECT_SIZE_OK_FUNC(hk_size_t nbytes);
#   define HK_ASSERT_OBJECT_SIZE_OK(A) HK_ASSERT_OBJECT_SIZE_OK_FUNC(A)
#else
#   define HK_ASSERT_OBJECT_SIZE_OK(A)
#endif

HK_DETAIL_DIAG_CLANG_POP()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
