// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

struct HK_EXPORT_COMMON hkMemoryClassStatistics
{
    hk_size_t m_size_in_use;
    int m_n_allocates;
    int m_n_news;
    hk_size_t m_new_size_in_use;
    int m_blocks_in_use;
    hk_size_t m_max_size_in_use;

    void init()
    {
        m_blocks_in_use = 0;
        m_max_size_in_use = 0;
        m_n_allocates = 0;
        m_n_news = 0;
        m_new_size_in_use = 0;
        m_size_in_use = 0;
    }

    void operator += (const hkMemoryClassStatistics& b)
    {
        this->m_blocks_in_use += b.m_blocks_in_use;
        this->m_max_size_in_use += b.m_max_size_in_use;
        this->m_n_allocates += b.m_n_allocates;
        this->m_n_news += b.m_n_news;
        this->m_new_size_in_use += b.m_new_size_in_use;
        this->m_size_in_use += b.m_size_in_use;
    }

    void operator -= (const hkMemoryClassStatistics& b)
    {
        this->m_blocks_in_use -= b.m_blocks_in_use;
        this->m_max_size_in_use -= b.m_max_size_in_use;
        this->m_n_allocates -= b.m_n_allocates;
        this->m_n_news -= b.m_n_news;
        this->m_new_size_in_use -= b.m_new_size_in_use;
        this->m_size_in_use -= b.m_size_in_use;
    }

};

struct HK_EXPORT_COMMON hkMemoryClassInfo
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkMemoryClassInfo);
    hkMemoryClassStatistics     m_classStats;
    const char*                 m_name;
    int                         m_parent;           //the parent class for this class
    int                         m_numSubClasses;    //the number of subclasses

    hkMemoryClassInfo(_In_opt_z_ const char* n, int parent)
        : m_name(n), m_parent(parent)
    {
    }
};

extern hkMemoryClassInfo hkMemoryClassesTable[];

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
