// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/Allocator/hkMemoryAllocator.h>

void HK_CALL HK_ASSERT_OBJECT_SIZE_OK_FUNC(hk_size_t nbytes)
{
    // object size must be representable in 15 bits.
    HK_ASSERT(0x13aa0880,  nbytes <= (hkUint16(-1)>>1), "Object is too big");
}

hkMemoryAllocator::~hkMemoryAllocator()
{
}

_Ret_notnull_ _Post_writable_byte_size_(reqBytesInOut)
void* hkMemoryAllocator::bufAlloc( int& reqBytesInOut )
{
    return blockAlloc(reqBytesInOut);
}

void hkMemoryAllocator::bufFree(_In_opt_bytecount_(numBytes) void* p, int numBytes)
{
    return blockFree(p, numBytes);
}

_Ret_notnull_ _Post_writable_byte_size_(reqBytesInOut)
void* hkMemoryAllocator::bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqBytesInOut )
{
    void* pnew = bufAlloc(reqBytesInOut);
    if ( pnew )
    {
        hkMemUtil::memCpy(pnew, pold, hkMath::min2(oldNumBytes,reqBytesInOut));
    }
    bufFree(pold, oldNumBytes);
    return pnew;
}

void hkMemoryAllocator::blockAllocBatch(_Out_writes_all_(numPtrs) void** ptrsOut, int numPtrs, int blockSize)
{
    for( int i = 0; i < numPtrs; ++i )
    {
        ptrsOut[i] = blockAlloc(blockSize);
    }
}
void hkMemoryAllocator::blockFreeBatch(_In_reads_(numPtrs) void** ptrsIn, int numPtrs, int blockSize)
{
    for( int i = 0; i < numPtrs; ++i )
    {
        if( ptrsIn[i] )
        {
            blockFree(ptrsIn[i], blockSize);
        }
    }
}

_Ret_notnull_ _Post_writable_byte_size_(numInOut * size)
void* hkMemoryAllocator::bufAlloc2(int size, int& numInOut)
{
    int nbytes;
    if (hkCheckMulSizes(size, numInOut, &nbytes).isFailure())
    {
        HK_FATAL_ERROR(0, "Memory allocation request overflow {}*{}", size, numInOut);
    }
    void* p = bufAlloc(nbytes);
    numInOut = nbytes / size;
    return p;
}

void hkMemoryAllocator::bufFree2(_In_opt_bytecount_(num * size) void* p, int size, int num)
{
    int nbytes;
    if (hkCheckMulSizes(size, num, &nbytes).isFailure())
    {
        HK_FATAL_ERROR(0, "Memory allocation request overflow {}*{}", size, num);
    }
    bufFree(p, nbytes);
}

_Ret_notnull_ _Post_writable_byte_size_(reqNumInOut * size)
void* hkMemoryAllocator::bufRealloc2(_In_reads_bytes_(oldNum * size) void* pold, int size, int oldNum, int& reqNumInOut)
{
    int reqBytes;
    if (hkCheckMulSizes(size, reqNumInOut, &reqBytes).isFailure())
    {
        HK_FATAL_ERROR(0, "Memory allocation request overflow {}*{}", size, reqNumInOut);
    }
    int curBytes;
    if (hkCheckMulSizes(size, oldNum, &curBytes).isFailure())
    {
        HK_FATAL_ERROR(0, "Memory allocation request overflow {}*{}", size, oldNum);
    }
    void* p = bufRealloc(pold, curBytes, reqBytes);
    reqNumInOut = reqBytes / size;
    return p;
}

_Ret_notnull_ _Post_writable_byte_size_(size * num)
void* hkMemoryAllocator::blockAlloc2(int size, int num)
{
    int nbytes;
    if (hkCheckMulSizes(size, num, &nbytes).isFailure())
    {
        HK_FATAL_ERROR(0, "Memory allocation request overflow {}*{}", size, num);
    }
    return blockAlloc(nbytes);
}

void hkMemoryAllocator::blockFree2(_In_opt_bytecount_(num * size) void* p, int size, int num)
{
    int nbytes;
    if (hkCheckMulSizes(size, num, &nbytes).isFailure())
    {
        HK_FATAL_ERROR(0, "Memory allocation request overflow {}*{}", size, num);
    }
    blockFree(p, nbytes);
}

_Analysis_noreturn_ void* hkMemoryAllocator::outOfMemory(_In_opt_z_ const char* msg)
{
    HK_FATAL_ERROR(0xdeadf00d, "Out of memory {}", msg ? msg : "");
    return nullptr; //not reached
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
