// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Memory/Allocator/hkMemoryAllocator.h>

    /// An allocator that gives out memory and never frees it. When cleared, all of the memory
    /// is freed in one operation. Chains allocations of blocks from which to give out memory
    /// to another allocator
class HK_EXPORT_COMMON hkTransientAllocator : public hkMemoryAllocator
{
    public:

        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));

        hkTransientAllocator(_In_ class hkMemoryAllocator* chainedAllocator, hkUint32 blockSize = 16384);
        ~hkTransientAllocator();

        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes);
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes);

        virtual void getMemoryStatistics( hkMemoryAllocator::MemoryStatistics& u ) const;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const;
        virtual void resetPeakMemoryStatistics();

        // Clear all allocations, but keep the memory blocks for future allocating
        void clear();
        // Clear and deallocate everything, the allocator is now back in its startup state apart
        // from statistics
        void clearAndDeallocate();

        _Ret_notnull_ class hkMemoryAllocator* getChainedAllocator() const { return m_chainedAllocator; }

    protected:

        void ensureBlockCanAllocate(int numBytes);
        HK_INLINE int roundUpTo16(int n)
        {
            return (n+15) & (~15);
        }

        struct LargeBlockInfo
        {
            void* m_alloc;
            int m_size;
            void set(void* alloc, int size) { m_alloc = alloc; m_size = size; }
        };

        hkUint32 m_currentUsed;
        hkUint32 m_peakUse;
        const int m_blockSize;
        int m_currentBlock;
        int m_currentBlockOffset;
        class hkMemoryAllocator* m_chainedAllocator;
        hkArrayBase<void*> m_blocks;
        hkArrayBase<LargeBlockInfo> m_largeBlocks;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
