// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/StackTracer/hkStackTracer.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Container/PointerMap/hkMap.h>

    /// Detects cases when the temp allocator should be used instead of the heap.
class HK_EXPORT_COMMON hkTempDetectAllocator : public hkMemoryAllocator
{
    public:
        HK_DECLARE_PLACEMENT_ALLOCATOR();

        hkTempDetectAllocator();

        typedef void (HK_CALL *OutputStringFunc)(_In_z_ const char* s, _In_opt_ void* userData);
        void init(_In_ hkMemoryAllocator* a, OutputStringFunc output, _In_opt_ void* outputUserData);
        void quit();

        virtual void pushFrame() override;
        virtual void popFrame() override;
        virtual void advanceFrame() override;

        virtual _Ret_notnull_ _Post_writable_byte_size_(size) void* blockAlloc( int size ) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(size) void* p, int size ) HK_OVERRIDE;

        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumInOut) void* bufAlloc(int& reqNumInOut) HK_OVERRIDE;
        virtual void bufFree(_In_opt_bytecount_(numBytes) void* p, int numBytes) HK_OVERRIDE;
        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumInOut) void* bufRealloc(_In_opt_bytecount_(oldNum) void* pold, int oldNum, int& reqNumInOut) HK_OVERRIDE;

        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(numBytes) const void* obj, int numBytes) const HK_OVERRIDE;

    protected:

        void internalFree(_In_bytecount_(size) void* p, int size);
        _Ret_notnull_ void* internalAlloc(_In_bytecount_(size) void* p, int size);

    public:

        typedef hkStackTracer::CallTree::TraceId TraceId;
        struct AllocInfo
        {
            hkUint64 m_threadId;
            TraceId m_allocId;
            int m_size;
            int m_pushCount;
        };

        hkCriticalSection m_lock;
        hkMemoryAllocator* m_child;
        hkStackTracer::CallTree m_callTree;
        hkStackTracer m_tracer;

            // Map of allocated address to callstack
        hkMapBase<void*, AllocInfo> m_allocs;
            // For freed memory map alloc locations to freed locations.
            // Special case: the free id is zero if we've given up on a pair.
            // This can happen when there are multiple freeing locations for a given allocation
            // or if the allocating thread is different to the freeing thread.
        hkMapBase<TraceId, TraceId> m_freeFromAlloc;

        struct SizeInfo
        {
            int m_minSize;
            int m_maxSize;
            hkUlong m_total;
            int m_count;
        };
        hkMapBase<TraceId, SizeInfo> m_sizeFromAlloc;

        OutputStringFunc m_outputFunc;
        void* m_outputFuncArg;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
