// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

    /// Simple manager which tracks statistics and forwards all calls to another allocator.
class HK_EXPORT_COMMON hkStatsAllocator : public hkMemoryAllocator
{
    public:
        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));

        hkStatsAllocator(_In_ hkMemoryAllocator* a);

        void init(_In_ hkMemoryAllocator* a);
        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc( int numBytes ) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;

        virtual void getMemoryStatistics( hkMemoryAllocator::MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(numBytes) const void* obj, int numBytes) const HK_OVERRIDE;
        virtual void resetPeakMemoryStatistics() HK_OVERRIDE;

    protected:

        mutable hkCriticalSection m_criticalSection;
        hkMemoryAllocator* m_alloc;
        MemoryStatistics m_stats;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
