// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

    /// Debugging passthrough allocator which remembers requests and forwards them to another allocator.
    /// WARNING: this class is extremely slow for large number of allocations.
    /// It maintains a linked list of all active allocations.
class HK_EXPORT_COMMON hkRecallAllocator : public hkMemoryAllocator
{
    //+hk.MemoryTracker(ignore=True)
    public:

        hkRecallAllocator(_In_ hkMemoryAllocator* a);

        void init(_In_ hkMemoryAllocator* a);
        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;

        virtual void getMemoryStatistics( hkMemoryAllocator::MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;
        virtual void resetPeakMemoryStatistics() HK_OVERRIDE;

        struct Header
        {
            protected:
                friend class hkRecallAllocator;
                Header* m_next;         // Next allocation in the list.
                int m_requestedSize;    // The size we requested from the next allocator.
                int m_payloadSize;      // The size which was requested from this allocator.

            public:
                int getRequestedSize() const { return m_requestedSize; }
                int getPayloadSize() const { return m_payloadSize; }
                _Ret_notnull_ const void* getPayload() const { return hkAddByteOffsetConst(this,16); }
                _Ret_notnull_ void* getPayload() { return hkAddByteOffset(this, 16); }
                _Ret_maybenull_ const Header* getNext() const { return m_next; }
        };
        _Ret_maybenull_ const Header* getHead() const { return m_head; }

    protected:

        mutable hkCriticalSection m_criticalSection;
        hkMemoryAllocator* m_alloc;
        MemoryStatistics m_stats;
        Header* m_head;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
