// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Common/Base/Container/PointerMap/hkMap.h>

    ///
class HK_EXPORT_COMMON hkPooledAllocator : public hkMemoryAllocator
{
    public:

        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));
            ///
        hkPooledAllocator();

            /// Initialize pooled memory allocator. If an initial block is specified, it is used to satisfy allocations. If not, or once filled,
            /// subsequent allocations will be made from the block allocator. The initial block must remain valid for the lifetime of the allocator.
        void init(_In_ hkMemoryAllocator* internal, _In_ hkMemoryAllocator* large, _Inout_ hkMemoryAllocator* blocks,
            int blockSize, _In_opt_bytecount_(initialBlockSize) void *initialBlock = HK_NULL, int initialBlockSize = 0);

            ///
        void quit();

        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;

        hkBool32 isOk() const;

        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;

            /// Purges allocated pools if there's no active allocations
        bool purge();

    protected:

        enum {
            MIN_ALIGNMENT = 4,
            MAX_ALIGNMENT = 16
        };
        void* m_curPtr;
        int m_curBytesLeft;

        int m_statsAllocated;
        int m_statsUsed;
        int m_statsPeak;

        hkMemoryAllocator* m_internal;
        hkMemoryAllocator* m_large;
        hkMemoryAllocator* m_block;
        int m_blockSize;
        hkMapBase<void*, int> m_largeAllocs;
        hkArrayBase<void*> m_blockAllocs;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
