// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// Records the memory request to the monitor stream and forwards to a child allocator.
    /// Use this with the details statistics to see the memory requests interleaved with the
    /// monitor timers. Note that this will require much more memory than the monitor timers.
class HK_EXPORT_COMMON hkMonitorAllocator : public hkMemoryAllocator
{
    public:
        HK_DECLARE_PLACEMENT_ALLOCATOR();

        hkMonitorAllocator() : m_child(HK_NULL), m_monitorTag(HK_NULL) {}
        hkMonitorAllocator(_In_ hkMemoryAllocator* child, _In_z_ const char* mtag);

        virtual _Ret_notnull_ _Post_writable_byte_size_(size) void* blockAlloc( int size ) HK_OVERRIDE;
        virtual void blockFree( _In_opt_bytecount_(size) void* p, int size ) HK_OVERRIDE;

        hkMemoryAllocator* m_child;
        const char* m_monitorTag;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
