// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/Allocator/Monitor/hkMonitorAllocator.h>
#include <Common/Base/Monitor/hkMonitorStream.h>

hkMonitorAllocator::hkMonitorAllocator(_In_ hkMemoryAllocator* child, _In_z_ const char* mtag)
    : m_child(child), m_monitorTag(mtag)
{
    HK_ASSERT_NO_MSG(0x54e4a336, mtag[0] == 'm');
}

_Ret_notnull_ _Post_writable_byte_size_(size) void* hkMonitorAllocator::blockAlloc( int size )
{
    void* p = m_child->blockAlloc(size);
    HK_MONITOR_MEMORY_ALLOC(m_monitorTag, p, size);
    return p;
}

void hkMonitorAllocator::blockFree(_In_opt_bytecount_(size) void* p, int size )
{
    HK_MONITOR_MEMORY_FREE(m_monitorTag, p, size);
    m_child->blockFree(p, size);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
