// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

    /// Simple manager which forwards all calls to malloc and free.
class HK_EXPORT_COMMON hkMallocAllocator : public hkMemoryAllocator
{
    public:
        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));

        hkMallocAllocator(int align=HK_REAL_ALIGNMENT) :
#if defined(HK_PLATFORM_PS4)
            m_align((align < 32) ? 32 : align),
#else
            m_align(align),
#endif
            m_currentUsed(0), m_peakUse(0)
        {}

            // may return null
        virtual _Ret_maybenull_ _Post_writable_byte_size_(numBytes) void* tryAlloc(int numBytes);
        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes) HK_OVERRIDE;

        virtual void getMemoryStatistics(hkMemoryAllocator::MemoryStatistics& u) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;
        virtual void resetPeakMemoryStatistics() HK_OVERRIDE;

        int m_align;

        static hkMallocAllocator *m_defaultMallocAllocator;

    protected:

        HK_ALIGN16(hkUint32 m_currentUsed); // aligned for hkAtomic::exchangeAdd32()

        hkUint32 m_peakUse;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
