// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkLinearBuffer::hkLinearBuffer(_In_bytecount_(bufferSize) void* bufferPtr, int bufferSize)
    : m_bufferCur(bufferPtr), m_bufferEnd(hkAddByteOffset(bufferPtr, bufferSize)), m_bufferStart(bufferPtr)
{
}

inline _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* hkLinearBuffer::blockAlloc(int numBytes)
{
    void* ret = m_bufferCur;
    m_bufferCur = hkAddByteOffset(m_bufferCur, numBytes);
    if( m_bufferCur > m_bufferEnd )
    {
        // not enough static space
        HK_FATAL_ERROR(0xdeadf11d, "hkLinearBuffer exhausted");
    }
    return ret;
}

template<typename T>
inline _Ret_notnull_ _Post_writable_size_(n) T* hkLinearBuffer::objAlloc(int n)
{
    HK_ASSERT_NO_MSG(0x1157e6cb, (hkUlong(m_bufferCur) % HK_ALIGN_OF(T)) == 0 );
    return static_cast<T*>(blockAlloc(n*sizeof(T)));
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
