// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class HK_EXPORT_COMMON hkLinearBuffer
{
public:
    //+hk.MemoryTracker(ignore=True)
    HK_DECLARE_PLACEMENT_ALLOCATOR();

    inline hkLinearBuffer(_In_bytecount_(bufferSize) void* buffer, int bufferSize);

    inline _Ret_notnull_ _Post_writable_byte_size_(n) void* blockAlloc(int n);
    inline void blockFree(_In_opt_ void* p, int n) {}

    template<typename T>
    inline _Ret_notnull_ _Post_writable_size_(n) T* objAlloc(int n = 1);

    template< hkUint32 BUFFER_SIZE >
    class Inplace;

    inline int getCapacity() const { return int(hkGetByteOffset(m_bufferStart, m_bufferEnd)); }
    inline int getUsed() const { return int(hkGetByteOffset(m_bufferStart, m_bufferCur)); }

protected:

    void* m_bufferCur;
    void* m_bufferEnd;
    void* m_bufferStart;
};

template< hkUint32 BUFFER_SIZE >
class hkLinearBuffer::Inplace : public hkLinearBuffer
{
public:
    //+hk.MemoryTracker(ignore=True)
    HK_DECLARE_PLACEMENT_ALLOCATOR();

    Inplace() : hkLinearBuffer(&m_buffer[0], BUFFER_SIZE) {}

protected:
    // allocation buffer
    HK_ALIGN_REAL(hkUint8 m_buffer[BUFFER_SIZE]);
};

#include <Common/Base/Memory/Allocator/Linear/hkLinearBuffer.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
