// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Memory/Allocator/Linear/hkLinearBuffer.h>

/// This allocator performs allocations from a given memory buffer. Memory chunks
/// taken from this buffer are never reused.
/// Eventually this allocator will run out of memory, it is only useful for debug
/// and designed for internal use only.

class HK_EXPORT_COMMON hkLinearAllocator : public hkMemoryAllocator
{
    public:

        //+hk.MemoryTracker(ignore=True)
        hkLinearAllocator(_In_bytecount_(bufferSize) void* buffer, int bufferSize);
        virtual ~hkLinearAllocator();
        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(n) void* p, int n) HK_OVERRIDE;
        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;

        template< hkUint32 BUFFER_SIZE >
        class Inplace;

    private:

        hkLinearBuffer m_buffer;
        // used for statistics
        hkUint32 m_inUse; // without overhead
        hkUint32 m_peakInUse; // usage peak without overhead
        // critical section used for multi-threading
        mutable hkCriticalSection m_criticalSection;
};

template< hkUint32 BUFFER_SIZE >
class HK_EXPORT_COMMON hkLinearAllocator::Inplace : public hkLinearAllocator
{
    public:
        //+hk.MemoryTracker(ignore=True)
        HK_DECLARE_PLACEMENT_ALLOCATOR();

        Inplace() : hkLinearAllocator(&m_buffer[0], BUFFER_SIZE) {}

    protected:
        // allocation buffer
        HK_ALIGN_REAL( hkUint8 m_buffer[BUFFER_SIZE] );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
