// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Memory/Allocator/Linear/hkLinearAllocator.h>
#include <Common/Base/Thread/Atomic/hkAtomicPrimitives.h>

// -------------------------------- Methods --------------------------------- //

hkLinearAllocator::hkLinearAllocator(_In_bytecount_(bufferSize) void* bufferPtr, int bufferSize)
    : m_buffer(bufferPtr, bufferSize), m_inUse(0), m_peakInUse(0), m_criticalSection(1000)
{}

hkLinearAllocator::~hkLinearAllocator()
{
}

_Ret_notnull_ _Post_writable_byte_size_(numBytesUnaligned) void* hkLinearAllocator::blockAlloc(int numBytesUnaligned)
{
    hkCriticalSectionLock lock(&m_criticalSection);

    int numBytes = HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT, numBytesUnaligned);
    void* p = m_buffer.blockAlloc(numBytes);
    // update statistics
    hkAtomic::exchangeAdd(&m_inUse, hkUint32(numBytesUnaligned));
    if(m_inUse > m_peakInUse)
    {
        m_peakInUse = m_inUse;
    }
    return p;
}

void hkLinearAllocator::blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes)
{
    // Static memory is never freed
    hkAtomic::add(&m_inUse, hkUint32(-numBytes));
}

HK_INLINE void hkLinearAllocator::getMemoryStatistics( MemoryStatistics& u ) const
{
    hkCriticalSectionLock lock( &m_criticalSection );

    u.m_allocated = m_buffer.getCapacity();
    u.m_inUse = m_inUse;
    u.m_peakInUse = m_peakInUse;
    u.m_available = m_buffer.getCapacity() - m_buffer.getUsed();
    u.m_totalAvailable = u.m_available;
    u.m_largestBlock = u.m_available;
}

HK_INLINE int hkLinearAllocator::getAllocatedSize(_In_bytecount_(numBytes) const void* obj, int numBytes) const
{
    return numBytes;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
