// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

_Ret_notnull_ _Post_writable_byte_size_(numBytesIn) void* hkLifoAllocator::fastBlockAlloc(int numBytesIn)
{
    int numBytes = HK_NEXT_MULTIPLE_OF(16, numBytesIn);

    void* next = static_cast<char*>(m_cur) + numBytes;
    if (numBytes <= m_slabSize && hkUlong(next) <= hkUlong(m_end))
    {
        void* ret = m_cur;
        m_cur = next;
        return ret;
    }
    else
    {
        return allocateFromNewSlab(numBytes);
    }
}


void hkLifoAllocator::fastBlockFree(_In_bytecount_(numBytesIn) void* p, int numBytesIn)
{
    int numBytes = HK_NEXT_MULTIPLE_OF(16, numBytesIn);
    if (numBytesIn <= m_slabSize &&
        (static_cast<char*>(p) + numBytes) == m_cur &&
        m_firstNonLifoEnd != p)
    {
        // usual case, free top
        m_cur = p;
    }
    else
    {
        slowBlockFree(p, numBytes);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
