// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Memory/Allocator/hkMemoryAllocator.h>
#include <Common/Base/Memory/Allocator/FreeList/hkFreeList.h>

class hkFixedSizeAllocator: public hkMemoryAllocator
{
    public:
        HK_DECLARE_PLACEMENT_ALLOCATOR();

        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;
        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* bufAlloc( int& reqNumBytesInOut ) HK_OVERRIDE;
        virtual void bufFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;
        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut) HK_OVERRIDE;
        virtual void blockAllocBatch(_Out_writes_all_(numPtrs) void** ptrsOut, int numPtrs, int blockSize) HK_OVERRIDE;
        virtual void blockFreeBatch(_In_reads_(numPtrs) void** ptrsIn, int numPtrs, int blockSize) HK_OVERRIDE;
        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;

            /// Ctor.
        void init(hk_size_t blockSize, hk_size_t align, hk_size_t allocatorBlockSize, _In_opt_ hkMemoryAllocator* allocator);

        hkFreeList m_freeList;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
