// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>

// this
#include <Common/Base/Memory/Allocator/FreeList/hkFixedSizeAllocator.h>

void hkFixedSizeAllocator::init(hk_size_t blockSize, hk_size_t align, hk_size_t allocatorBlockSize, _In_opt_ hkMemoryAllocator* allocator)
{
    // Set up to use the underlying allocator
#ifdef HK_PLATFORM_PS4
    align = hkMath::max2(align, 32);
#endif
    m_freeList.init(blockSize, align, allocatorBlockSize, allocator, HK_NULL);
}

_Ret_notnull_ _Post_writable_byte_size_(numBytes) void* hkFixedSizeAllocator::blockAlloc( int numBytes )
{
    HK_ASSERT_NO_MSG(0x323a2432, numBytes == int(m_freeList.getElementSize()));
    return m_freeList.alloc();
}

void hkFixedSizeAllocator::blockFree( void* p, int numBytes )
{
    HK_ASSERT_NO_MSG(0x343a2432, numBytes == int(m_freeList.getElementSize()));
    return m_freeList.free(p);
}

_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkFixedSizeAllocator::bufAlloc(int& reqNumBytesInOut)
{
    HK_ASSERT_NO_MSG(0x343a2432, reqNumBytesInOut == int(m_freeList.getElementSize()));
    return m_freeList.alloc();
}

void hkFixedSizeAllocator::bufFree(_In_opt_bytecount_(numBytes) void* p, int numBytes )
{
    HK_ASSERT_NO_MSG(0x343a2432, numBytes == int(m_freeList.getElementSize()));
    m_freeList.free(p);
}

_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkFixedSizeAllocator::bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut )
{
    HK_ASSERT_NO_MSG(0x343a2432, oldNumBytes <= int(m_freeList.getElementSize()) && reqNumBytesInOut <= int(m_freeList.getElementSize()));
    return pold;
}

void hkFixedSizeAllocator::blockAllocBatch(_Out_writes_all_(numPtrs) void** ptrsOut, int numPtrs, int blockSize)
{
    HK_ASSERT_NO_MSG(0x3243a432, blockSize == int(m_freeList.getElementSize()));
    m_freeList.allocBatch(ptrsOut, numPtrs);
}

void hkFixedSizeAllocator::blockFreeBatch(_In_reads_(numPtrs) void** ptrsIn, int numPtrs, int blockSize)
{
    HK_ASSERT_NO_MSG(0x32432432, blockSize == int(m_freeList.getElementSize()));
    m_freeList.freeBatch(ptrsIn, numPtrs);
}

void hkFixedSizeAllocator::getMemoryStatistics( MemoryStatistics& u ) const
{
    m_freeList.getMemoryStatistics(u);
}

int hkFixedSizeAllocator::getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const
{
    HK_ASSERT_NO_MSG(0x32432432, nbytes <= int(m_freeList.getElementSize()));
    return int(m_freeList.getElementSize());
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
