// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// Pads allocations and checks that padding is unmodified on free.
class HK_EXPORT_COMMON hkPaddedAllocator : public hkMemoryAllocator
{
    public:
        HK_RECORD_ATTR(hk::MemoryTracker(opaque=true));
            ///
        struct Cinfo
        {
                /// Default is 16 byte padding and values are signalling NaNs.
            Cinfo()
                : m_numQuadsPad(1)
                , m_padPattern(0x7ffdadad) // pAD begin. pAD End is +1 i.e. 0x7ffdadae
                , m_bodyPattern(0x7ffa110c) // Alloc body
                , m_alignPattern(0x16) // Align 16
                , m_freePattern(0x7fffefef) // Free
            {
            }

                /// Number of 16 byte pads
                /// (beginning and ending of the required block - after it has been aligned to 16 bytes).
            int m_numQuadsPad;
                /// Fill at ends.
            hkUint32 m_padPattern;
                /// Fill body of new allocation.
            hkUint32 m_bodyPattern;
                /// Fill extra alignment bytes to align the required block size to 16 bytes
            hkUint8 m_alignPattern;
                /// Scrub freed memory.
            hkUint32 m_freePattern;
        };

            /// Pad allocations with the given size.
        hkPaddedAllocator();

            /// Default fill values are used if not given.
        void init(_In_ hkMemoryAllocator* next, _In_opt_ const Cinfo* cinfo = HK_NULL );
            ///
        void quit();

        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc( int numBytes ) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT, numBytes)) void* p, int numBytes ) HK_OVERRIDE;

        hkBool32 isOk(_In_bytecount_(HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT, numBytes)) const void* p, int numBytes) const;

        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(numBytes) const void* obj, int numBytes) const HK_OVERRIDE;

        void setScrubValues(hkUint32 bodyValue, hkUint32 freeValue);

        struct Allocation { const void* address; int size; };
        Allocation getUnderlyingAllocation(_In_bytecount_(numBytes) const void* obj, int numBytes) const;

    protected:

        hkMemoryAllocator* m_next;
        Cinfo m_cinfo;
        int m_allocated;
        int m_inUse;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
