// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Physics/ContactPoint/hkContactPoint.h> // move to collide lib


#define P16 30000.0
#define P31 (P16 * 0x10000)

#define HK_QUADFLOAT_SINGLE(X) HK_QUADFLOAT_CONSTANT(X,X,X,X)
#define HK_QUADDOUBLE_SINGLE(X) HK_QUADDOUBLE_CONSTANT(X,X,X,X)

static const hkUint32 g_nanfBitPattern = 0x7FC00000;
static const hkUint32 g_inffBitPattern = 0x7f800000;
static const hkUint32 g_ninffBitPattern= 0xff800000;

static const hkUint64 g_nandBitPattern = 0x7FF8000000000000ull;
static const hkUint64 g_infdBitPattern = 0x7ff0000000000000ull;
static const hkUint64 g_ninfdBitPattern= 0xfff0000000000000ull;

// Integer constants to allow us to check for Inf/NaN faster
HK_ALIGN16(const unsigned int g_mantissaMaskf[4]) = {0x7f800000, 0x7f800000, 0x7f800000, 0x7f800000};
HK_ALIGN16(const unsigned long long g_mantissaMaskd[2])  = {0x7ff0000000000000ull, 0x7ff0000000000000ull};





HK_ALIGN_REAL(const hkQuadFloat32 g_vectorfConstants[HK_QUADREAL_END]) =
{
    HK_QUADFLOAT_SINGLE(0),
#if defined(HK_PLATFORM_WIIU)
    HK_QUADFLOAT_SINGLE(__NAN__), // GHS compiler cannot handle numeric_limits as compiletime constants - use compiler internal symbol
    HK_QUADFLOAT_SINGLE(INFINITY),
    HK_QUADFLOAT_SINGLE(-INFINITY),
#elif defined(HK_COMPILER_GCC) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_NX)
    HK_QUADFLOAT_SINGLE(NAN),
    HK_QUADFLOAT_SINGLE(INFINITY), //HK_QUADFLOAT_SINGLE( INF),
    HK_QUADFLOAT_SINGLE(-INFINITY), //HK_QUADFLOAT_SINGLE(-INF),
#else
    HK_QUADFLOAT_SINGLE(*(const hkFloat32*)&g_nanfBitPattern), // Start marker, Components that aren't loaded during hkVector4f::load() are initialized to this in Debug and Dev configurations.
    HK_QUADFLOAT_SINGLE(*(const hkFloat32*)&g_inffBitPattern), // Start marker, Components that aren't loaded during hkVector4f::load() are initialized to this in Debug and Dev configurations.
    HK_QUADFLOAT_SINGLE(*(const hkFloat32*)&g_ninffBitPattern), // Start marker, Components that aren't loaded during hkVector4f::load() are initialized to this in Debug and Dev configurations.
#endif
    HK_QUADFLOAT_SINGLE(-1),
    HK_QUADFLOAT_SINGLE(0),
    HK_QUADFLOAT_SINGLE(1),
    HK_QUADFLOAT_SINGLE(2),
    HK_QUADFLOAT_SINGLE(3),
    HK_QUADFLOAT_SINGLE(4),
    HK_QUADFLOAT_SINGLE(5),
    HK_QUADFLOAT_SINGLE(6),
    HK_QUADFLOAT_SINGLE(7),
    HK_QUADFLOAT_SINGLE(8),
    HK_QUADFLOAT_SINGLE(15),
    HK_QUADFLOAT_SINGLE(16),
    HK_QUADFLOAT_SINGLE(255),
    HK_QUADFLOAT_SINGLE(256),
    HK_QUADFLOAT_SINGLE(1<<23),

    HK_QUADFLOAT_SINGLE(0),
    HK_QUADFLOAT_SINGLE(1.0f/1),
    HK_QUADFLOAT_SINGLE(1.0f/2),
    HK_QUADFLOAT_SINGLE(1.0f/3),
    HK_QUADFLOAT_SINGLE(1.0f/4),
    HK_QUADFLOAT_SINGLE(1.0f/5),
    HK_QUADFLOAT_SINGLE(1.0f/6),
    HK_QUADFLOAT_SINGLE(1.0f/7),
    HK_QUADFLOAT_SINGLE(1.0f/8),
    HK_QUADFLOAT_SINGLE(1.0f/15),
    HK_QUADFLOAT_SINGLE(1.0f/127),
    HK_QUADFLOAT_SINGLE(1.0f/226),
    HK_QUADFLOAT_SINGLE(1.0f/255),

    HK_QUADFLOAT_CONSTANT(1,0,0,0),
    HK_QUADFLOAT_CONSTANT(0,1,0,0),
    HK_QUADFLOAT_CONSTANT(0,0,1,0),
    HK_QUADFLOAT_CONSTANT(0,0,0,1),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_MAX),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_HIGH),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_EPSILON),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_EPSILON * HK_FLOAT_EPSILON),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_MIN),
    HK_QUADFLOAT_SINGLE(-HK_FLOAT_MAX),
    HK_QUADFLOAT_SINGLE(-HK_FLOAT_MIN),

    HK_QUADFLOAT_CONSTANT(-1,1,-1,1),
    HK_QUADFLOAT_CONSTANT(1,-1,1,-1),
    HK_QUADFLOAT_CONSTANT( 1,0, 1,0),
    HK_QUADFLOAT_CONSTANT( 0,1, 0,1),
    HK_QUADFLOAT_CONSTANT( 1,1, 0,0),
    HK_QUADFLOAT_CONSTANT( 0,0, 1,1),
    HK_QUADFLOAT_CONSTANT( 1,2, 4,8),
    HK_QUADFLOAT_CONSTANT( 8,4, 2,1),
    HK_QUADFLOAT_SINGLE( 1.0f + 1.0f/256 ), // HK_QUADREAL_PACK_HALF
    HK_QUADFLOAT_SINGLE( P31 ),            // HK_QUADREAL_PACK16_UNIT_VEC
    HK_QUADFLOAT_SINGLE( 1.0f/P31 ),           // HK_QUADREAL_UNPACK16_UNIT_VEC

    HK_QUADFLOAT_SINGLE(HK_FLOAT_PI),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_PI*0.5f),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_PI*0.25f),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_PI*4.0f/3.0f),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_PI*2.0f),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_PI*4.0f),

    HK_QUADFLOAT_SINGLE(HK_FLOAT_DEG_TO_RAD),
    HK_QUADFLOAT_SINGLE(HK_FLOAT_RAD_TO_DEG),
};

HK_ALIGN_REAL(const hkQuadDouble64 g_vectordConstants[HK_QUADREAL_END]) =
{
    HK_QUADDOUBLE_SINGLE(0),    // begin
#if defined(HK_PLATFORM_WIIU)
    HK_QUADDOUBLE_SINGLE(__NAN__), // GHS compiler cannot handle numeric_limits as compiletime constants - use compiler internal symbol
    HK_QUADDOUBLE_SINGLE(INFINITY), //HK_QUADDOUBLE_SINGLE(__INF__),    // GHS compiler cannot handle numeric_limits as compiletime constants - use compiler internal symbol
    HK_QUADDOUBLE_SINGLE(-INFINITY), //HK_QUADDOUBLE_SINGLE(-__INF__), // GHS compiler cannot handle numeric_limits as compiletime constants - use compiler internal symbol
#elif defined(HK_COMPILER_GCC) || defined(HK_PLATFORM_IOS)
    HK_QUADDOUBLE_SINGLE(NAN),
    HK_QUADDOUBLE_SINGLE(INFINITY), //HK_QUADDOUBLE_SINGLE( INF),
    HK_QUADDOUBLE_SINGLE(-INFINITY), //HK_QUADDOUBLE_SINGLE(-INF),
#else
    HK_QUADDOUBLE_SINGLE(*(const hkDouble64*)&g_nandBitPattern), // Start marker, Components that aren't loaded during hkVector4d::load() are initialized to this in Debug and Dev configurations.
    HK_QUADDOUBLE_SINGLE(*(const hkDouble64*)&g_infdBitPattern), // Start marker, Components that aren't loaded during hkVector4f::load() are initialized to this in Debug and Dev configurations.
    HK_QUADDOUBLE_SINGLE(*(const hkDouble64*)&g_ninfdBitPattern), // Start marker, Components that aren't loaded during hkVector4f::load() are initialized to this in Debug and Dev configurations.
#endif
    HK_QUADDOUBLE_SINGLE(-1),
    HK_QUADDOUBLE_SINGLE(0),
    HK_QUADDOUBLE_SINGLE(1),
    HK_QUADDOUBLE_SINGLE(2),
    HK_QUADDOUBLE_SINGLE(3),
    HK_QUADDOUBLE_SINGLE(4),
    HK_QUADDOUBLE_SINGLE(5),
    HK_QUADDOUBLE_SINGLE(6),
    HK_QUADDOUBLE_SINGLE(7),
    HK_QUADDOUBLE_SINGLE(8),
    HK_QUADDOUBLE_SINGLE(15),
    HK_QUADDOUBLE_SINGLE(16),
    HK_QUADDOUBLE_SINGLE(255),
    HK_QUADDOUBLE_SINGLE(256),
    HK_QUADDOUBLE_SINGLE(1<<23),

    HK_QUADDOUBLE_SINGLE(0),
    HK_QUADDOUBLE_SINGLE(1.0/1),
    HK_QUADDOUBLE_SINGLE(1.0/2),
    HK_QUADDOUBLE_SINGLE(1.0/3),
    HK_QUADDOUBLE_SINGLE(1.0/4),
    HK_QUADDOUBLE_SINGLE(1.0/5),
    HK_QUADDOUBLE_SINGLE(1.0/6),
    HK_QUADDOUBLE_SINGLE(1.0/7),
    HK_QUADDOUBLE_SINGLE(1.0/8),
    HK_QUADDOUBLE_SINGLE(1.0/15),
    HK_QUADDOUBLE_SINGLE(1.0/127),
    HK_QUADDOUBLE_SINGLE(1.0/226),
    HK_QUADDOUBLE_SINGLE(1.0/255),

    HK_QUADDOUBLE_CONSTANT(1,0,0,0),
    HK_QUADDOUBLE_CONSTANT(0,1,0,0),
    HK_QUADDOUBLE_CONSTANT(0,0,1,0),
    HK_QUADDOUBLE_CONSTANT(0,0,0,1),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_MAX),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_HIGH),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_EPSILON),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_EPSILON * HK_DOUBLE_EPSILON),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_MIN),
    HK_QUADDOUBLE_SINGLE(-HK_DOUBLE_MAX),
    HK_QUADDOUBLE_SINGLE(-HK_DOUBLE_MIN),

    HK_QUADDOUBLE_CONSTANT(-1,1,-1,1),
    HK_QUADDOUBLE_CONSTANT(1,-1,1,-1),
    HK_QUADDOUBLE_CONSTANT( 1,0, 1,0),
    HK_QUADDOUBLE_CONSTANT( 0,1, 0,1),
    HK_QUADDOUBLE_CONSTANT( 1,1, 0,0),
    HK_QUADDOUBLE_CONSTANT( 0,0, 1,1),
    HK_QUADDOUBLE_CONSTANT( 1,2, 4,8),
    HK_QUADDOUBLE_CONSTANT( 8,4, 2,1),
    HK_QUADDOUBLE_SINGLE( 1.0 + 1.0/256 ), // HK_QUADDOUBLE_PACK_HALF
    HK_QUADDOUBLE_SINGLE( P31 ),               // HK_QUADDOUBLE_PACK16_UNIT_VEC
    HK_QUADDOUBLE_SINGLE( 1.0/P31 ),           // HK_QUADDOUBLE_UNPACK16_UNIT_VEC

    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_PI),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_PI*0.5),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_PI*0.25),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_PI*4.0/3.0),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_PI*2.0),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_PI*4.0),

    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_DEG_TO_RAD),
    HK_QUADDOUBLE_SINGLE(HK_DOUBLE_RAD_TO_DEG),
};

hkUchar hkVector4ComparisonMask_indexRemap[16][4] =
{
    { 0, 1, 2, 3 },
    { 0, 1, 2, 3 },
    { 1, 0, 2, 3 },
    { 0, 1, 2, 3 },
    { 2, 0, 1, 3 },
    { 0, 2, 1, 3 },
    { 1, 2, 0, 3 },
    { 0, 1, 2, 3 },
    { 3, 0, 1, 2 },
    { 0, 3, 1, 2 },
    { 1, 3, 0, 2 },
    { 0, 1, 3, 2 },
    { 2, 3, 0, 1 },
    { 0, 2, 3, 1 },
    { 1, 2, 3, 0 },
    { 0, 1, 2, 3 },
};

// function to build the above table
// void hknpCollision2DFastProcessUtil_buildFilterRemap()
// {
//  hkUchar remap[16][4];
//  for (int m = 0; m < 16; m++)
//  {
//      char bits[4] = { m&1, m&2, m&4, m&8 };
//      int s = 0;
//      for (int i =0; i < 4; i++ )
//      {
//          if ( bits[i] )
//          {
//              remap[m][s++] = hkUchar(i);
//          }
//      }
//      for (int i = 0; i < 4; i++ )
//      {
//          if ( !bits[i] )
//          {
//              remap[m][s++] = hkUchar(i);
//          }
//      }
//  }
//  for (int i = 0; i < 16; i++ )
//  {
//      Log_Info( "\t\t{}, {}, {}, {}, ", remap[i][0], remap[i][1], remap[i][2], remap[i][3] );
//  }
// }


void HK_CALL hkCheckFlushDenormals()
{
    bool checkFailed;

#if defined(HK_COMPILER_HAS_INTRINSICS_IA32) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    // _MM_GET_FLUSH_ZERO_MODE takes an argument but doesn't use it in MSVC, but not GCC
#if defined(HK_COMPILER_MSVC)
#   define DUMMY_ARG 1
#else
#   define DUMMY_ARG
#endif
#if ( defined(_MSC_VER) && (_MSC_VER >= 1700) ) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_MAC) || ((defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_LINUX)) && defined(HK_COMPILER_CLANG))
  // does not even like dummarg as nothing since __MM_GET is a macro too
    checkFailed = _MM_GET_FLUSH_ZERO_MODE( ) != _MM_FLUSH_ZERO_ON;
#else
    checkFailed = _MM_GET_FLUSH_ZERO_MODE( DUMMY_ARG ) != _MM_FLUSH_ZERO_ON;
#endif
#elif defined(HK_ARCH_ARM_64) && defined(HK_COMPILER_MSVC)
    
    __int64 result = _ReadStatusReg(ARM64_FPCR);
    checkFailed = (result & (1 << 24)) == 0;
#elif defined(HK_ARCH_ARM_64)
    unsigned long result;
    asm volatile("mrs %[result], FPCR" : [result] "=r" (result));
    checkFailed = (result & (1 << 24)) == 0;
#elif defined(HK_ARCH_ARM) && defined(HK_COMPILER_MSVC)
    
    #define CPVFP_FPSCR 10, 7, 1, 0, 0
    int result =  _MoveFromCoprocessor(CPVFP_FPSCR);
    checkFailed = (result & (1 << 24)) == 0;
#elif defined(HK_ARCH_ARM) && !defined(HK_PLATFORM_PSVITA)
    int result;
    asm volatile("vmrs %[result], FPSCR" : [result] "=r" (result));
    checkFailed = (result & (1 << 24)) == 0;
#else
    checkFailed = false;
#endif

    HK_WARN_ONCE_ON_DEBUG_IF(checkFailed, 0xDE404A11, "Flushing denormals is required inside Havok code. Please call _MM_SET_FLUSH_ZERO_MODE(_MM_FLUSH_ZERO_ON); or set the FPCR or FPSCR register correctly before stepping Havok. See the \"Using the Math Library\" section in the User Guide for more information.");
}
#define POPCNT_HELPER(I) I+0, I+1, I+1, I+2, I+1, I+2, I+2, I+3, I+1, I+2, I+2, I+3, I+2, I+3, I+3, I+4


const hkUchar hkMath_g_popcount_table8[256] =
{
    POPCNT_HELPER(0),
    POPCNT_HELPER(1),
    POPCNT_HELPER(1),
    POPCNT_HELPER(2),
    POPCNT_HELPER(1),
    POPCNT_HELPER(2),
    POPCNT_HELPER(2),
    POPCNT_HELPER(3),
    POPCNT_HELPER(1),
    POPCNT_HELPER(2),
    POPCNT_HELPER(2),
    POPCNT_HELPER(3),
    POPCNT_HELPER(2),
    POPCNT_HELPER(3),
    POPCNT_HELPER(3),
    POPCNT_HELPER(4)
};

#undef POPCNT_HELPER
#if  defined(HK_PLATFORM_WIIU)
extern hkFloat32  hkInfinityf;
extern hkDouble64 hkInfinityd;
hkFloat32  hkInfinityf = __INFINITY__;
hkDouble64 hkInfinityd = __INFINITY__;
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
