// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifdef HK_INT_VECTOR_NATIVE_PERMUTE8
    #if (defined(HK_PLATFORM_WIN32) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_DURANGO)) && defined(HK_SSE_VERSION) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) &&  defined(HK_ARCH_INTEL)
    #include <tmmintrin.h>  // _mm_shuffle_epi8
    #include <nmmintrin.h>  // _mm_popcnt_32
    #endif
#endif

namespace hkNVectorCompactAndCountUtils
{
    struct HK_EXPORT_COMMON Tables
    {
        HK_ALIGN16(static const hkIntVectorConstantU32 s_componentMasks[16][4]);
        static const int s_maskToBitCount[16];
    };
}

template <> HK_INLINE hkVector4Comparison hkVectorSort::vectorCompareT<HK_SORT_ASCENDING,   hkIntVector>    (const hkIntVector& a, const hkIntVector& b)    {   return a.compareLessThanS32(b); }
template <> HK_INLINE hkVector4Comparison hkVectorSort::vectorCompareT<HK_SORT_DESCENDING,  hkIntVector>    (const hkIntVector& a, const hkIntVector& b)    {   return b.compareLessThanS32(a); }
template <> HK_INLINE hkVector4Comparison hkVectorSort::vectorCompareT<HK_SORT_ASCENDING,   hkVector4>      (const hkVector4& a, const hkVector4& b)        {   return a.less(b);   }
template <> HK_INLINE hkVector4Comparison hkVectorSort::vectorCompareT<HK_SORT_DESCENDING,  hkVector4>      (const hkVector4& a, const hkVector4& b)        {   return b.less(a);   }

//
template <hkMathSortDir ORDER, typename KEYS>
HK_INLINE void hkVectorSort::sort(const KEYS& keys, KEYS* HK_RESTRICT keysOut)
{
    // Compare exchange [XY,ZW]
    KEYS    yxwz_v; yxwz_v.template setPermutation<hkVectorPermutation::YXWZ>(keys);
    KEYS    yyww; yyww.template setPermutation<hkVectorPermutation::YYWW>(keys);
    KEYS    xxzz; xxzz.template setPermutation<hkVectorPermutation::XXZZ>(keys);

    hkVector4Comparison c1 = vectorCompareT<ORDER>(yyww, xxzz);

    KEYS    k1; k1.setSelect(c1, yxwz_v, keys);

    // Compare exchange [XZ,YW]
    KEYS    zwxy_v; zwxy_v.template setPermutation<hkVectorPermutation::ZWXY>(k1);
    KEYS    zwzw; zwzw.template setPermutation<hkVectorPermutation::ZWZW>(k1);
    KEYS    xyxy; xyxy.template setPermutation<hkVectorPermutation::XYXY>(k1);

    hkVector4Comparison c2 = vectorCompareT<ORDER>(zwzw,xyxy);

    KEYS    k2; k2.setSelect(c2, zwxy_v, k1);

    // Compare exchange [YZ]
    KEYS    xzyw_v; xzyw_v.template setPermutation<hkVectorPermutation::XZYW>(k2);
    KEYS    xzzw; xzzw.template setPermutation<hkVectorPermutation::XZZW>(k2);
    KEYS    xyyw; xyyw.template setPermutation<hkVectorPermutation::XYYW>(k2);

    hkVector4Comparison c3 = vectorCompareT<ORDER>(xzzw,xyyw);

    KEYS    k3; k3.setSelect(c3, xzyw_v, k2);

    // Store results.
    *keysOut = k3;
}

//
template <hkMathSortDir ORDER, typename KEYS, typename VALUES>
HK_INLINE void hkVectorSort::sort(const KEYS& keys, const VALUES& values, KEYS* HK_RESTRICT keysOut, VALUES* HK_RESTRICT valuesOut)
{
    // Compare exchange [XY,ZW]
    VALUES  yxwz_v; yxwz_v.template setPermutation<hkVectorPermutation::YXWZ>(values);
    KEYS    yxwz_k; yxwz_k.template setPermutation<hkVectorPermutation::YXWZ>(keys);
    KEYS    yyww; yyww.template setPermutation<hkVectorPermutation::YYWW>(keys);
    KEYS    xxzz; xxzz.template setPermutation<hkVectorPermutation::XXZZ>(keys);

    hkVector4Comparison c1 = vectorCompareT<ORDER>(yyww, xxzz);

    KEYS    k1; k1.setSelect(c1, yxwz_k, keys);
    VALUES  v1; v1.setSelect(c1, yxwz_v, values);

    // Compare exchange [XZ,YW]
    VALUES  zwxy_v; zwxy_v.template setPermutation<hkVectorPermutation::ZWXY>(v1);
    KEYS    zwxy_k; zwxy_k.template setPermutation<hkVectorPermutation::ZWXY>(k1);
    KEYS    zwzw; zwzw.template setPermutation<hkVectorPermutation::ZWZW>(k1);
    KEYS    xyxy; xyxy.template setPermutation<hkVectorPermutation::XYXY>(k1);

    hkVector4Comparison c2 = vectorCompareT<ORDER>(zwzw,xyxy);

    KEYS    k2; k2.setSelect(c2, zwxy_k, k1);
    VALUES  v2; v2.setSelect(c2, zwxy_v, v1);

    // Compare exchange [YZ]
    VALUES  xzyw_v; xzyw_v.template setPermutation<hkVectorPermutation::XZYW>(v2);
    KEYS    xzyw_k; xzyw_k.template setPermutation<hkVectorPermutation::XZYW>(k2);
    KEYS    xzzw; xzzw.template setPermutation<hkVectorPermutation::XZZW>(k2);
    KEYS    xyyw; xyyw.template setPermutation<hkVectorPermutation::XYYW>(k2);

    hkVector4Comparison c3 = vectorCompareT<ORDER>(xzzw,xyyw);

    KEYS    k3; k3.setSelect(c3, xzyw_k, k2);
    VALUES  v3; v3.setSelect(c3, xzyw_v, v2);

    // Store results.
    *keysOut = k3;
    *valuesOut = v3;
}

//
template <hkMathSortDir ORDER, typename KEYS, typename VALUES0, typename VALUES1>
HK_INLINE void hkVectorSort::sort(const KEYS& keys, const VALUES0& values0, const VALUES1& values1, KEYS* HK_RESTRICT keysOut, VALUES0* HK_RESTRICT values0Out, VALUES1* HK_RESTRICT values1Out)
{
    // Compare exchange [XY,ZW]
    VALUES0 yxwz_v0; yxwz_v0.template setPermutation<hkVectorPermutation::YXWZ>(values0);
    VALUES1 yxwz_v1; yxwz_v1.template setPermutation<hkVectorPermutation::YXWZ>(values1);
    KEYS    yxwz_k; yxwz_k.template setPermutation<hkVectorPermutation::YXWZ>(keys);
    KEYS    yyww; yyww.template setPermutation<hkVectorPermutation::YYWW>(keys);
    KEYS    xxzz; xxzz.template setPermutation<hkVectorPermutation::XXZZ>(keys);

    hkVector4Comparison c1 = vectorCompareT<ORDER>(yyww, xxzz);

    KEYS    k1; k1.setSelect(c1, yxwz_k, keys);
    VALUES0 v10; v10.setSelect(c1, yxwz_v0, values0);
    VALUES1 v11; v11.setSelect(c1, yxwz_v1, values1);

    // Compare exchange [XZ,YW]
    VALUES0 zwxy_v0; zwxy_v0.template setPermutation<hkVectorPermutation::ZWXY>(v10);
    VALUES1 zwxy_v1; zwxy_v1.template setPermutation<hkVectorPermutation::ZWXY>(v11);
    KEYS    zwxy_k; zwxy_k.template setPermutation<hkVectorPermutation::ZWXY>(k1);
    KEYS    zwzw; zwzw.template setPermutation<hkVectorPermutation::ZWZW>(k1);
    KEYS    xyxy; xyxy.template setPermutation<hkVectorPermutation::XYXY>(k1);

    hkVector4Comparison c2 = vectorCompareT<ORDER>(zwzw,xyxy);

    KEYS    k2; k2.setSelect(c2, zwxy_k, k1);
    VALUES0 v20; v20.setSelect(c2, zwxy_v0, v10);
    VALUES1 v21; v21.setSelect(c2, zwxy_v1, v11);

    // Compare exchange [YZ]
    VALUES0 xzyw_v0; xzyw_v0.template setPermutation<hkVectorPermutation::XZYW>(v20);
    VALUES1 xzyw_v1; xzyw_v1.template setPermutation<hkVectorPermutation::XZYW>(v21);
    KEYS    xzyw_k; xzyw_k.template setPermutation<hkVectorPermutation::XZYW>(k2);
    KEYS    xzzw; xzzw.template setPermutation<hkVectorPermutation::XZZW>(k2);
    KEYS    xyyw; xyyw.template setPermutation<hkVectorPermutation::XYYW>(k2);

    hkVector4Comparison c3 = vectorCompareT<ORDER>(xzzw,xyyw);

    KEYS    k3; k3.setSelect(c3, xzyw_k, k2);
    VALUES0 v30; v30.setSelect(c3, xzyw_v0, v20);
    VALUES1 v31; v31.setSelect(c3, xzyw_v1, v21);

    // Store results.
    *keysOut = k3;
    *values0Out = v30;
    *values1Out = v31;
}


//

HK_INLINE _Ret_range_(0, 4) int hkVectorSort::GenericSimd::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut)
{
    hkIntVector xSplat; xSplat.setBroadcast<0>( vIn );
    hkIntVector ySplat; ySplat.setBroadcast<1>( vIn );
    hkIntVector zSplat; zSplat.setBroadcast<2>( vIn );
    hkIntVector wSplat; wSplat.setBroadcast<3>( vIn );

    hkIntVector vTemp1;    vTemp1.setAnd( xSplat, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][0].v );
    hkIntVector vTemp2;    vTemp2.setAnd( ySplat, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][1].v );
    hkIntVector vTemp3;    vTemp3.setAnd( zSplat, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][2].v );
    hkIntVector vTemp4;    vTemp4.setAnd( wSplat, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][3].v );

    hkIntVector vTempA;   vTempA.setOr( vTemp1, vTemp2 );
    hkIntVector vTempB;   vTempB.setOr( vTemp3, vTemp4 );
    vOut->setOr( vTempA, vTempB );

    return hkNVectorCompactAndCountUtils::Tables::s_maskToBitCount[mask];
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::GenericSimd::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1)
{
    hkIntVector xSplat0; xSplat0.setBroadcast<0>( vIn0 );
    hkIntVector ySplat0; ySplat0.setBroadcast<1>( vIn0 );
    hkIntVector zSplat0; zSplat0.setBroadcast<2>( vIn0 );
    hkIntVector wSplat0; wSplat0.setBroadcast<3>( vIn0 );

    hkIntVector xSplat1; xSplat1.setBroadcast<0>( vIn1 );
    hkIntVector ySplat1; ySplat1.setBroadcast<1>( vIn1 );
    hkIntVector zSplat1; zSplat1.setBroadcast<2>( vIn1 );
    hkIntVector wSplat1; wSplat1.setBroadcast<3>( vIn1 );

    hkIntVector vTempX0;    vTempX0.setAnd( xSplat0, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][0].v );
    hkIntVector vTempY0;    vTempY0.setAnd( ySplat0, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][1].v );
    hkIntVector vTempZ0;    vTempZ0.setAnd( zSplat0, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][2].v );
    hkIntVector vTempW0;    vTempW0.setAnd( wSplat0, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][3].v );

    hkIntVector vTempX1;    vTempX1.setAnd( xSplat1, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][0].v );
    hkIntVector vTempY1;    vTempY1.setAnd( ySplat1, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][1].v );
    hkIntVector vTempZ1;    vTempZ1.setAnd( zSplat1, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][2].v );
    hkIntVector vTempW1;    vTempW1.setAnd( wSplat1, hkNVectorCompactAndCountUtils::Tables::s_componentMasks[mask][3].v );

    hkIntVector vTempA0; vTempA0.setOr( vTempX0, vTempY0 );
    hkIntVector vTempB0; vTempB0.setOr( vTempZ0, vTempW0 );
    vOut0->setOr( vTempA0, vTempB0 );

    hkIntVector vTempA1; vTempA1.setOr( vTempX1, vTempY1 );
    hkIntVector vTempB1; vTempB1.setOr( vTempZ1, vTempW1 );
    vOut1->setOr( vTempA1, vTempB1 );

    return hkNVectorCompactAndCountUtils::Tables::s_maskToBitCount[mask];
}

//
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::GenericSimd::compactAndCount( const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut )
{
    hkVector4ComparisonMask::Mask mask = comp.getMask();
    return compactAndCount( mask, vIn, vOut );

}

//
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::GenericSimd::compactAndCount( const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1 )
{
    hkVector4ComparisonMask::Mask mask = comp.getMask();
    return compactAndCount( mask, vIn0, vIn1, vOut0, vOut1 );
}


/// SSE31 implementation of compactAndCount
/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::Shuffle8Bit::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut)
{
    vOut->setPermuteU8(vIn, hkVectorSort::s_compactVectorTable[mask].v);
    return hkNVectorCompactAndCountUtils::Tables::s_maskToBitCount[mask];
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::Shuffle8Bit::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1)
{
    const hkIntVector& perm = hkVectorSort::s_compactVectorTable[mask].v;
    vOut0->setPermuteU8(vIn0, perm);
    vOut1->setPermuteU8(vIn1, perm);
    return hkNVectorCompactAndCountUtils::Tables::s_maskToBitCount[mask];
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::Shuffle8Bit::compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut)
{
    return compactAndCount(comp.getMask(), vIn, vOut);
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::Shuffle8Bit::compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1)
{
    return compactAndCount(comp.getMask(), vIn0, vIn1, vOut0, vOut1);
}

#if defined(HK_ENABLE_SSE_CODE_PATH )
/// SSE31 implementation of compactAndCount, same as SSE3 but for the use of _mm_popcnt_u32 to count bits.
/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE31::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut)
{
    //vOut->setPermuteU8(vIn, hkVectorSort::g_compactVectorTable[mask].v);
    vOut->m_quad = _mm_shuffle_epi8(vIn.m_quad, hkVectorSort::s_compactVectorTable[mask].v.m_quad);
    return hkNVectorCompactAndCountUtils::Tables::s_maskToBitCount[mask];
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE31::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1)
{
    const hkIntVector& perm = hkVectorSort::s_compactVectorTable[mask].v;
    //vOut0->setPermuteU8(vIn0, perm);
    //vOut1->setPermuteU8(vIn1, perm);
    vOut0->m_quad = _mm_shuffle_epi8(vIn0.m_quad, perm.m_quad);
    vOut1->m_quad = _mm_shuffle_epi8(vIn1.m_quad, perm.m_quad);
    return hkNVectorCompactAndCountUtils::Tables::s_maskToBitCount[mask];
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE31::compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut)
{
    return compactAndCount(comp.getMask(), vIn, vOut);
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE31::compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1)
{
    return compactAndCount(comp.getMask(), vIn0, vIn1, vOut0, vOut1);
}

/// SSE40 implementation of compactAndCount, same as SSE3 but for the use of _mm_popcnt_u32 to count bits.
/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE42::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut)
{
    //vOut->setPermuteU8(vIn, hkVectorSort::g_compactVectorTable[mask].v);
    vOut->m_quad = _mm_shuffle_epi8(vIn.m_quad, hkVectorSort::s_compactVectorTable[mask].v.m_quad);
    return hkMath::countBitsSet(mask);
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE42::compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1)
{
    const hkIntVector& perm = hkVectorSort::s_compactVectorTable[mask].v;
    //vOut0->setPermuteU8(vIn0, perm);
    //vOut1->setPermuteU8(vIn1, perm);
    vOut0->m_quad = _mm_shuffle_epi8(vIn0.m_quad, perm.m_quad);
    vOut1->m_quad = _mm_shuffle_epi8(vIn1.m_quad, perm.m_quad);
    return hkMath::countBitsSet(mask);
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE42::compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut)
{
    return compactAndCount(comp.getMask(), vIn, vOut);
}

/// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
HK_INLINE _Ret_range_(0, 4) int hkVectorSort::SSE42::compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1)
{
    return compactAndCount(comp.getMask(), vIn0, vIn1, vOut0, vOut1);
}
#endif

// Compact and count code path selection.
#if defined(HK_INT_VECTOR_NATIVE_PERMUTE8) && !defined(HK_REAL_IS_DOUBLE)
#if HK_SSE_VERSION >= 0x42 && defined(HK_ARCH_INTEL)
#define HK_VECTOR_SORT_SELECT_COMPACT_AND_COUNT( _macro_ ) \
            if( hkHardwareInfo::hasFeatureSet( hkHardwareInfo::SSSE3, hkHardwareInfo::POPCNT ) ) \
                _macro_( ::hkVectorSort::SSE42 ); \
            else \
                _macro_( ::hkVectorSort::Shuffle8Bit )
#else
#define HK_VECTOR_SORT_SELECT_COMPACT_AND_COUNT( _macro_ ) \
                _macro_( ::hkVectorSort::Shuffle8Bit )
/*#define HK_VECTOR_SORT_COMPACT_AND_COUNT( _macro_ ) \
if( hkHardwareInfo::hasFeatureSet( hkHardwareInfo::Shuffle8Bit ) ) \
{ \
if( hkHardwareInfo::hasFeatureSet( hkHardwareInfo::POPCNT ) ) \
_macro_( ::hkVectorSort::SSE42 ); \
else \
_macro_( ::hkVectorSort::Shuffle8Bit ); \
} else _macro_( ::hkVectorSort::GenericSimd )
#endif*/
#endif
#elif defined(HK_ENABLE_SSE_CODE_PATH)
#define HK_VECTOR_SORT_SELECT_COMPACT_AND_COUNT( _macro_ ) \
            if( hkHardwareInfo::hasFeatureSet( hkHardwareInfo::SSSE3 ) ) \
                    _macro_( ::hkVectorSort::SSE31 ); \
            else \
                _macro_( ::hkVectorSort::GenericSimd )
#else
#define HK_VECTOR_SORT_SELECT_COMPACT_AND_COUNT( _macro_ ) \
        _macro_( ::hkVectorSort::GenericSimd )
#endif

//                 if( hkHardwareInfo::hasFeatureSet( hkHardwareInfo::POPCNT ) )
//                     _macro_( ::hkVectorSort::SSE42 );
//                 else

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
