// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#ifndef HK_MATH_MATH_H
#   error You need to include Common/Base/hkBase.h before this file.
#endif

#include <Common/Base/Math/Vector/hkIntVector.h>

#if (defined(HK_PLATFORM_WIN32) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_DURANGO)) && defined(HK_SSE_VERSION) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) && defined(HK_ARCH_INTEL) && !defined(__HAVOK_PARSER__)
#   define HK_ENABLE_SSE_CODE_PATH
#   include <nmmintrin.h>   // _mm_popcnt_u32
#   include <tmmintrin.h>   // _mm_shuffle_epi8
#endif

/// Set of sorting method for vectors, hkIntVector (four signed integers) and hkVector4.
struct HK_EXPORT_COMMON hkVectorSort
{
    // Some tables.
    struct HK_EXPORT_COMMON Tables
    {
        static const hkInt8 s_orderingTable[64][4];
        static const hkUint16 s_spreadMaskBits[4][16];
        static HK_ALIGN16( const hkIntVectorConstantU32 s_int25masks[5] );
    };

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkVectorSort);

    /// Compare two Vectors.
    template <hkMathSortDir ORDER, typename VecType>
    static HK_INLINE hkVector4Comparison vectorCompareT(const VecType& a, const VecType& b);

    /// Sort a vector.
    template <hkMathSortDir ORDER, typename KEYS>
    static HK_INLINE void sort(const KEYS& keys, KEYS* HK_RESTRICT keysOut);

    /// Sort a key and value pair of vectors.
    template <hkMathSortDir ORDER, typename KEYS, typename VALUES>
    static HK_INLINE void sort(const KEYS& keys, const VALUES& values, KEYS* HK_RESTRICT keysOut, VALUES* HK_RESTRICT valuesOut);

    /// Sort a key and value pair of vectors.
    template <hkMathSortDir ORDER, typename KEYS, typename VALUES0, typename VALUES1>
    static HK_INLINE void sort(const KEYS& keys, const VALUES0& values0, const VALUES1& values1, KEYS* HK_RESTRICT keysOut, VALUES0* HK_RESTRICT values0Out, VALUES1* HK_RESTRICT values1Out);

    //////////////////////////////////////////////////////////////////////////

    struct GenericSimd
    {
        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appear first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appear first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'mask' appear first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'mask' appear first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);

    };

    /// SSE base implementation

    HK_ALIGN16(static const hkIntVectorConstantU32 s_compactVectorTable[16]);


    /// Native Permute8Bit implementation of compactAndCount
    struct Shuffle8Bit
    {
        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);
    };

#if defined(HK_ENABLE_SSE_CODE_PATH)

    /// SSE31 implementation of compactAndCount, same as SSE3 but for the use of _mm_popcnt_u32 to count bits.
    struct SSE31
    {
        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);
    };

    /// SSE40 implementation of compactAndCount, same as SSE3 but for the use of _mm_popcnt_u32 to count bits.
    struct SSE42
    {
        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(hkVector4Comparison::Mask mask, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn, hkIntVector* HK_RESTRICT vOut);

        /// Compact an hkIntVector by permuting its elements such as the ones set in 'comp' appears first.
        static HK_INLINE _Ret_range_(0, 4) int compactAndCount(const hkVector4Comparison& comp, const hkIntVector& vIn0, const hkIntVector& vIn1, hkIntVector* HK_RESTRICT vOut0, hkIntVector* HK_RESTRICT vOut1);
    };
#endif

#if defined( HK_INT_VECTOR_NATIVE_PERMUTE8 )
#   if HK_SSE_VERSION >= 0x42
        typedef SSE42 Impl;
#   else
        typedef Shuffle8Bit Impl;
#   endif
#else
    typedef GenericSimd Impl;
#endif

};

#include <Common/Base/Math/Vector/hkVectorSort.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
