// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Math/Vector/hkVectorSort.h>
#include <Common/Base/Math/Vector/hkIntVector.h>

//
const int hkNVectorCompactAndCountUtils::Tables::s_maskToBitCount[16] = { 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4 };

//
const hkInt8 hkVectorSort::Tables::s_orderingTable[64][4] =
{
    { 3, 2, 1, 0 },
    { 3, 2, 0, 1 },
    { 3, 1, 2, 0 },
    { -1, -1, -1, -1 },
    { 2, 3, 1, 0 },
    { 2, 3, 0, 1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { 3, 0, 2, 1 },
    { 3, 1, 0, 2 },
    { 3, 0, 1, 2 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { 1, 3, 2, 0 },
    { -1, -1, -1, -1 },
    { 2, 1, 3, 0 },
    { -1, -1, -1, -1 },
    { 1, 2, 3, 0 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { 1, 3, 0, 2 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { 2, 0, 3, 1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { 0, 3, 2, 1 },
    { -1, -1, -1, -1 },
    { 0, 3, 1, 2 },
    { -1, -1, -1, -1 },
    { 0, 2, 3, 1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { 2, 1, 0, 3 },
    { 2, 0, 1, 3 },
    { 1, 2, 0, 3 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { -1, -1, -1, -1 },
    { 1, 0, 3, 2 },
    { 0, 1, 3, 2 },
    { -1, -1, -1, -1 },
    { 0, 2, 1, 3 },
    { 1, 0, 2, 3 },
    { 0, 1, 2, 3 }
};


//
const hkUint16 hkVectorSort::Tables::s_spreadMaskBits[4][16] =
{
    {
        0x0000 << 0,
        0x0001 << 0,
        0x0010 << 0,
        0x0011 << 0,
        0x0100 << 0,
        0x0101 << 0,
        0x0110 << 0,
        0x0111 << 0,
        0x1000 << 0,
        0x1001 << 0,
        0x1010 << 0,
        0x1011 << 0,
        0x1100 << 0,
        0x1101 << 0,
        0x1110 << 0,
        0x1111 << 0
    },

    {
        0x0000 << 1,
        0x0001 << 1,
        0x0010 << 1,
        0x0011 << 1,
        0x0100 << 1,
        0x0101 << 1,
        0x0110 << 1,
        0x0111 << 1,
        0x1000 << 1,
        0x1001 << 1,
        0x1010 << 1,
        0x1011 << 1,
        0x1100 << 1,
        0x1101 << 1,
        0x1110 << 1,
        0x1111 << 1
    },

    {
        0x0000 << 2,
        0x0001 << 2,
        0x0010 << 2,
        0x0011 << 2,
        0x0100 << 2,
        0x0101 << 2,
        0x0110 << 2,
        0x0111 << 2,
        0x1000 << 2,
        0x1001 << 2,
        0x1010 << 2,
        0x1011 << 2,
        0x1100 << 2,
        0x1101 << 2,
        0x1110 << 2,
        0x1111 << 2
    },

    {
        0x0000 << 3,
        0x0001 << 3,
        0x0010 << 3,
        0x0011 << 3,
        0x0100 << 3,
        0x0101 << 3,
        0x0110 << 3,
        0x0111 << 3,
        0x1000 << 3,
        0x1001 << 3,
        0x1010 << 3,
        0x1011 << 3,
        0x1100 << 3,
        0x1101 << 3,
        0x1110 << 3,
        0x1111 << 3
    }
};

//
#define INT25_MASK ((1<<25)-1)
HK_ALIGN16( const hkIntVectorConstantU32 hkVectorSort::Tables::s_int25masks[5] ) =
{
    HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, 0 ),
    HK_INT_VECTOR_CONSTANT_U32( INT25_MASK, 0, 0, 0 ),
    HK_INT_VECTOR_CONSTANT_U32( INT25_MASK, INT25_MASK, 0, 0 ),
    HK_INT_VECTOR_CONSTANT_U32( INT25_MASK, INT25_MASK, INT25_MASK, 0 ),
    HK_INT_VECTOR_CONSTANT_U32( INT25_MASK, INT25_MASK, INT25_MASK, INT25_MASK )
};
#undef INT25_MASK

//
#define HK_INT_ONE 0xffffffff
HK_ALIGN16(const hkIntVectorConstantU32 hkNVectorCompactAndCountUtils::Tables::s_componentMasks[16][4]) =
{
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)  ,
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)  ,
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)  ,
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)
    },
    {
        HK_INT_VECTOR_CONSTANT_U32( HK_INT_ONE, 0, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, HK_INT_ONE, 0, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, HK_INT_ONE, 0)  ,
        HK_INT_VECTOR_CONSTANT_U32( 0, 0, 0, HK_INT_ONE)
    }
};
#undef HK_INT_ONE

//
#if HK_ENDIAN_BIG   // ppc
#   define OPERAND(_index_)         (0x00010203 + 0x04040404 * (_index_))
#else   // intel
#   define OPERAND(_index_)         (0x03020100 + 0x04040404 * (_index_))
#endif

#define TABLE(_a,_b,_c,_d)          HK_INT_VECTOR_CONSTANT_U32(_a,_b,_c,_d)

HK_ALIGN16(const hkIntVectorConstantU32 hkVectorSort::s_compactVectorTable[16]) =
{
    TABLE(OPERAND(0), OPERAND(1), OPERAND(2), OPERAND(3)),  // 0000
    TABLE(OPERAND(0), OPERAND(1), OPERAND(2), OPERAND(3)),  // 0001
    TABLE(OPERAND(1), OPERAND(0), OPERAND(2), OPERAND(3)),  // 0010
    TABLE(OPERAND(0), OPERAND(1), OPERAND(2), OPERAND(3)),  // 0011
    TABLE(OPERAND(2), OPERAND(0), OPERAND(1), OPERAND(3)),  // 0100
    TABLE(OPERAND(0), OPERAND(2), OPERAND(1), OPERAND(3)),  // 0101
    TABLE(OPERAND(1), OPERAND(2), OPERAND(0), OPERAND(3)),  // 0110
    TABLE(OPERAND(0), OPERAND(1), OPERAND(2), OPERAND(3)),  // 0111
    TABLE(OPERAND(3), OPERAND(0), OPERAND(1), OPERAND(2)),  // 1000
    TABLE(OPERAND(0), OPERAND(3), OPERAND(1), OPERAND(2)),  // 1001
    TABLE(OPERAND(1), OPERAND(3), OPERAND(0), OPERAND(2)),  // 1010
    TABLE(OPERAND(0), OPERAND(1), OPERAND(3), OPERAND(2)),  // 1011
    TABLE(OPERAND(2), OPERAND(3), OPERAND(0), OPERAND(1)),  // 1100
    TABLE(OPERAND(0), OPERAND(2), OPERAND(3), OPERAND(1)),  // 1101
    TABLE(OPERAND(1), OPERAND(2), OPERAND(3), OPERAND(0)),  // 1110
    TABLE(OPERAND(0), OPERAND(1), OPERAND(2), OPERAND(3))   // 1111
};

#undef OPERAND
#undef LOOKUP_TYPE
#undef TABLE

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
