// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>


HK_ALIGN16 (const hkInt32 hkVector4fComparison_maskToComparison32[16*4]) =
{
    0,  0, 0, 0,
    ~0,  0, 0, 0,
    0, ~0, 0, 0,
    ~0, ~0, 0, 0,
    0,  0,~0, 0,
    ~0,  0,~0, 0,
    0, ~0,~0, 0,
    ~0, ~0,~0, 0,
    0,  0, 0,~0,
    ~0,  0, 0,~0,
    0, ~0, 0,~0,
    ~0, ~0, 0,~0,
    0,  0,~0,~0,
    ~0,  0,~0,~0,
    0, ~0,~0,~0,
    ~0, ~0,~0,~0,
};

HK_ALIGN16 (const hkInt32 hkVector4fComparison_zeroComponentMask[4][4]) =
{
    { hkInt32( 0x00000000 ), hkInt32( 0xffffffff ), hkInt32( 0xffffffff ), hkInt32( 0xffffffff ) },
    { hkInt32( 0xffffffff ), hkInt32( 0x00000000 ), hkInt32( 0xffffffff ), hkInt32( 0xffffffff ) },
    { hkInt32( 0xffffffff ), hkInt32( 0xffffffff ), hkInt32( 0x00000000 ), hkInt32( 0xffffffff ) },
    { hkInt32( 0xffffffff ), hkInt32( 0xffffffff ), hkInt32( 0xffffffff ), hkInt32( 0x00000000 ) }
};

#define I2M(I) (((I<<2) + (I<<(8+2)) + (I<<(16+2)) + (I<<(24+2))) + (0 + (1<<8) + (2<<16) + (3<<24)))   // 4I+0 4I+1 4I+2 4I+3
HK_ALIGN16 (const hkInt32 hkVector4f_indexToComponent32_SSE3[4*4]) =
{
    I2M(0), I2M(0), I2M(0), I2M(0),
    I2M(1), I2M(1), I2M(1), I2M(1),
    I2M(2), I2M(2), I2M(2), I2M(2),
    I2M(3), I2M(3), I2M(3), I2M(3),
};


void hkVector4f::setRotatedDir(const hkMatrix3f& a, hkVector4f_ b)
{
    _setRotatedDir(a,b);
}

void hkVector4f::setRotatedInverseDir(const hkMatrix3f& a, hkVector4f_ b)
{
    _setRotatedInverseDir(a,b);
}

void hkVector4f::setTransformedPos(const hkTransformf& a, hkVector4f_ b)
{
    _setTransformedPos(a,b);
}

void hkVector4f::setTransformedInversePos(const hkTransformf& a, hkVector4f_ b)
{
    _setTransformedInversePos(a,b);
}

void hkVector4f::setTransformedPos(const hkQsTransformf& a, hkVector4f_ b)
{
    _setTransformedPos(a,b);
}

void hkVector4f::setTransformedInversePos(const hkQsTransformf& a, hkVector4f_ b)
{
    _setTransformedInversePos(a,b);
}

void hkVector4f::setTransformedPos(const hkQTransformf& a, hkVector4f_ b)
{
    _setTransformedPos(a,b);
}

void hkVector4f::setTransformedInversePos(const hkQTransformf& a, hkVector4f_ b)
{
    _setTransformedInversePos(a,b);
}

void hkVector4f::setRotatedDir(hkQuaternionfParameter quat, hkVector4f_ direction)
{
    _setRotatedDir(quat,direction);
}

void hkVector4f::setRotatedInverseDir(hkQuaternionfParameter quat, hkVector4f_ direction)
{
    _setRotatedInverseDir(quat,direction);
}

#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>


void hkMath::computeTypeSizeAlign(_Inout_ hkReflect::Type* copy, _In_ const hkReflect::Type* orig, const hkReflect::RecordLayout::Options& opts)
{
    using namespace hkReflect;
    HK_ASSERT_NO_MSG(0x1cb0b93, TypeDetail::localHasOptional(copy, Opt::SIZE_ALIGN));
    TypeDetail::localCopyOptional(copy, orig, Opt::SIZE_ALIGN);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
