// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Math/Vector/hkIntVector.h>
#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>

class hkStringBuf;

// Optimized math functions
namespace hkVector4UtilInternal
{
    // Compute half the surface area of an AABB.
    static HK_INLINE hkSimdReal halfSurfaceArea( const hkAabb& aabb );

    // Compute the surface area of an AABB.
    static HK_INLINE hkSimdReal surfaceArea(const hkAabb& aabb);

    // Check for AABB overlaps using 6 separating axis.
    static HK_INLINE hkBool32   overlaps6(const hkAabb& aabbA, const hkAabb& aabbB, const hkTransform& BtoA, const hkTransform& AtoB);

    // Compute ray inverse direction from direction.
    static HK_INLINE void   computeRayInverseDirection(hkVector4Parameter dir, hkVector4& invDirOut);

    // Check for intersection with a ray starting at the origin between fraction zero and maxFraction.
    static HK_INLINE hkBool32   intersectRay(const hkAabb& aabb, hkVector4Parameter rayInvDir, hkSimdRealParameter maxFraction);

    // Check for intersection with a ray between fraction zero and maxFraction.
    static HK_INLINE hkBool32   intersectRay(const hkAabb& aabb, hkVector4Parameter rayOrg, hkVector4Parameter rayInvDir, hkSimdRealParameter maxFraction);

    // Check for intersection with a ray bundle between fraction zero and maxFraction.
    // The returned hkVector4Comparison components are set depending on which rays hit.
    static HK_INLINE hkVector4Comparison intersectRayBundle(const hkAabb& aabb, const hkFourTransposedPoints& rayOrg, const hkFourTransposedPoints& rayInvDir, hkVector4Parameter maxFraction);

}

#include <Common/Base/Math/Vector/hkVector4UtilInternal.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
