// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>

#include <Common/Base/Math/Vector/hkVector4Util.h>
#include <Common/Base/Container/String/hkStringBuf.h>

extern HK_EXPORT_COMMON HK_ALIGN16(const hkInt32 hkVector4Util_valueMask[4]) = { 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff };

//
template <typename FT>
bool HK_CALL hkVector4UtilImpl<FT>::computeAffineTransformFromTriangles(    Vec4_ sa, Vec4_ sb, Vec4_ sc,
    Vec4_ da, Vec4_ db, Vec4_ dc,
    Transform& transformOut)
{
    Vec4 c0,c1,c2;

    c0.setSub(sb,sa);
    c1.setSub(sc,sa);
    c2.setCross(c0,c1);
    Matrix3 sm; sm.setCols(c0,c1,c2);

    hkResult matrixInvertResult = sm.setInverse(sm);
    if( matrixInvertResult.isSuccess() )
    {
        c0.setSub(db,da);
        c1.setSub(dc,da);
        c2.setCross(c0,c1);
        Matrix3 dm; dm.setCols(c0,c1,c2);

        transformOut.getRotation().setMul(dm,sm);

        Vec4    offset; offset._setRotatedDir(transformOut.getRotation(), sa);

        transformOut.getTranslation().setSub(da, offset);

        return true;
    }
    return false;
}

//
template <typename FT>
const char* hkVector4UtilImpl<FT>::toString3(Vec4_ x, hkStringBuf& s, char separator)
{
    s.printf("%f%c%f%c%f",(float)x(0),separator,(float)x(1),separator,(float)x(2));
    return s;
}

//
template <typename FT>
const char* hkVector4UtilImpl<FT>::toString4(Vec4_ x, hkStringBuf& s, char separator)
{
    s.printf("%f%c%f%c%f%c%f",(float)x(0),separator,(float)x(1),separator,(float)x(2),separator,(float)x(3));
    return s;
}



template class HK_EXPORT_COMMON hkVector4UtilImpl<hkFloat32>;
template class HK_EXPORT_COMMON hkVector4UtilImpl<hkDouble64>;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
