// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
HK_INLINE hkDouble64 hkVector2d::signedDistanceToLineTimesLength( const hkVector2d& p0, const hkVector2d& p1 ) const
{
    return ((p1.x - p0.x)*(y - p0.y) - (x - p0.x)*(p1.y - p0.y));
}

HK_INLINE hkBool32 hkVector2d::rightOfLine( const hkVector2d& p0, const hkVector2d& p1 ) const
{
    return signedDistanceToLineTimesLength(p0,p1) < 0;
}

HK_INLINE hkBool32 hkVector2d::leftOfLine( const hkVector2d& p0, const hkVector2d& p1 ) const
{
    return signedDistanceToLineTimesLength(p0,p1) > 0;
}

#if defined(HK_PLATFORM_PSVITA) && defined(HK_COMPILER_SNC) 
#pragma control %push O=1
#endif
HK_INLINE hkBool32 hkVector2d::inCircumcircle( const hkVector2d& p0, const hkVector2d& p1, const hkVector2d& p2, hkDouble64 tolerance ) const
{
    hkVector4d a; a.set( p0.x - x, p1.x - x, p2.x - x );
    hkVector4d b; b.set( p0.y - y, p1.y - y, p2.y - y );
    hkVector4d temp1; temp1.setMul( a, a );
    hkVector4d temp2; temp2.setMul( b, b );
    hkVector4d c; c.setAdd( temp1, temp2 );
    hkVector4d vCross; vCross.setCross( b, c );
    return a.dot<3>( vCross ).getReal() > -tolerance; // XXX
}
#if defined(HK_PLATFORM_PSVITA) && defined(HK_COMPILER_SNC) 
#pragma control %pop O=1
#endif

HK_INLINE hkBool32 hkVector2d::equals( const hkVector2d& p0 ) const
{
    return x == p0.x && y == p0.y;
}

HK_INLINE hkDouble64 hkVector2d::dot( const hkVector2d& p ) const
{
    return x*p.x + y*p.y;
}

HK_INLINE void hkVector2d::setMax( const hkVector2d& a, const hkVector2d& b )
{
    x = hkMath::max2(a.x,b.x);
    y = hkMath::max2(a.y,b.y);
}

HK_INLINE void hkVector2d::setMin( const hkVector2d& a, const hkVector2d& b )
{
    x = hkMath::min2(a.x,b.x);
    y = hkMath::min2(a.y,b.y);
}

HK_INLINE void hkVector2d::setAll( hkDouble64 a )
{
    x = a;
    y = a;
}

HK_INLINE void hkVector2d::set( hkDouble64 a, hkDouble64 b )
{
    x = a;
    y = b;
}

HK_INLINE void hkVector2d::set( hkSimdDouble64Parameter a, hkSimdDouble64Parameter b )
{
    a.store<1>(&x);
    b.store<1>(&y);
}

HK_INLINE void hkVector2d::load(_In_reads_(2) const hkDouble64* p )
{
    x = p[0];
    y = p[1];
}

HK_INLINE void hkVector2d::convertToVector4( hkVector4d& vOut ) const
{
    vOut.load<2,HK_IO_BYTE_ALIGNED>( &x );
}

HK_INLINE void hkVector2d::convertToVector4( hkVector4d& vOut, hkDouble64 z ) const
{
    vOut.set(x, y, z, 0);
}

HK_INLINE void hkVector2d::convertFromVector4( hkVector4dParameter vIn )
{
    vIn.store<2,HK_IO_BYTE_ALIGNED>( &x );
}

HK_INLINE void hkVector2d::setPerp( const hkVector2d& a )
{
    hkDouble64 t = a.x; // alias safe
    x = -a.y;
    y =  t;
}

HK_INLINE void hkVector2d::setAdd( const hkVector2d& a, const hkVector2d& b )
{
    x = a.x + b.x;
    y = a.y + b.y;
}

HK_INLINE void hkVector2d::add( const hkVector2d& a )
{
    x += a.x;
    y += a.y;
}

HK_INLINE void hkVector2d::sub( const hkVector2d& a )
{
    x -= a.x;
    y -= a.y;
}

HK_INLINE void hkVector2d::setMul( const hkVector2d& v, hkDouble64 r )
{
    x = v.x * r;
    y = v.y * r;
}

HK_INLINE void hkVector2d::setMul( const hkVector2d& v, const hkVector2d& w )
{
    x = v.x * w.x;
    y = v.y * w.y;
}

HK_INLINE void hkVector2d::mul( hkDouble64 r )
{
    x *= r;
    y *= r;
}

HK_INLINE void hkVector2d::setAddMul( const hkVector2d& a, const hkVector2d& b, hkDouble64 r )
{
    x = a.x + b.x * r;
    y = a.y + b.y * r;
}

HK_INLINE void hkVector2d::addMul( const hkVector2d& a, const hkVector2d& b )
{
    x += a.x * b.x;
    y += a.y * b.y;
}

HK_INLINE void hkVector2d::addMul( const hkVector2d& a, hkDouble64 b )
{
    x += a.x * b;
    y += a.y * b;
}

HK_INLINE void hkVector2d::addMul( hkDouble64 a, const hkVector2d& b )
{
    x += a * b.x;
    y += a * b.y;
}

HK_INLINE void hkVector2d::setSub( const hkVector2d& a, const hkVector2d& b )
{
    x = a.x - b.x;
    y = a.y - b.y;
}

HK_INLINE void hkVector2d::setInterpolate( const hkVector2d& a, const hkVector2d& b, hkDouble64 t)
{
    x = a.x + t * (b.x-a.x);
    y = a.y + t * (b.y-a.y);
}

HK_INLINE hkDouble64 hkVector2d::distanceTo( const hkVector2d& p ) const
{
    hkDouble64 dx = x - p.x;
    hkDouble64 dy = y - p.y;
    return hkMath::sqrt( dx*dx + dy*dy );
}

HK_INLINE hkDouble64 hkVector2d::distanceToSquared( const hkVector2d& p ) const
{
    hkDouble64 dx = x - p.x;
    hkDouble64 dy = y - p.y;
    return dx * dx + dy * dy;
}

HK_INLINE void hkVector2d::setProject( hkVector4dParameter p, hkVector4dParameter ax, hkVector4dParameter ay )
{
    x = ax.dot<3>(p).getReal();
    y = ay.dot<3>(p).getReal();
}

inline void hkVector2d::normalize()
{
    normalize<HK_ACC_MID, HK_SQRT_SET_ZERO>();
}

inline hkDouble64 hkVector2d::normalizeWithLength()
{
    return normalizeWithLength<HK_ACC_MID, HK_SQRT_SET_ZERO>();
}

template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
HK_INLINE void hkVector2d::normalize()
{
    hkVector4d v;
    convertToVector4(v);
    v.normalize<2, A, S>();
    convertFromVector4(v);
}


template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
HK_INLINE hkDouble64 hkVector2d::normalizeWithLength()
{
    hkVector4d v;
    convertToVector4(v);
    hkSimdDouble64 len = v.normalizeWithLength<2, A, S>();
    convertFromVector4(v);

    return len.getReal();
}

HK_INLINE hkDouble64 hkVector2d::length() const
{
    return hkMath::sqrt(x*x + y*y);
}

HK_INLINE hkDouble64 hkVector2d::lengthSquared() const
{
    return x*x + y*y;
}

HK_INLINE void hkVector2d::setZero()
{
    x = y = 0;
}

HK_INLINE hkBool32 hkVector2d::lexLess( const hkVector2d& v ) const
{
    return (x<v.x) || (x==v.x && y<v.y);
}

//
//  Sets this = -v

HK_INLINE void hkVector2d::setNeg(const hkVector2d& v)
{
    x = -v.x;
    y = -v.y;
}

//
//  Computes the cross product of the two vectors

HK_INLINE hkDouble64 HK_CALL hkVector2d::cross(const hkVector2d& vA, const hkVector2d& vB)
{
    return vA.x * vB.y - vA.y * vB.x;
}

HK_INLINE void HK_CALL hkVector2d::cross(const hkVector2d& vA, const hkVector2d& vB, hkVector4d& crossOut)
{
    crossOut.set(0.0f, 0.0f, hkVector2d::cross(vA, vB));
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
