// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

/*static*/ HK_INLINE hkSimdFloat32 HK_CALL hkSimdFloat32::fromFloat(const hkFloat32& x)
{
    hkSimdFloat32 r;
    r.setFromFloat(x);
    return r;
}

/*static*/ HK_INLINE hkSimdFloat32 HK_CALL hkSimdFloat32::fromHalf(const hkHalf32& x)
{
    return hkSimdFloat32::fromFloat( x.m_value );
}

#if !defined(hkSimdFloat32_isSignBitSet)
hkBool32 hkSimdFloat32::isSignBitSet() const
{
    return isLessZero();
}
#endif

/*static*/ HK_INLINE hkSimdFloat32 HK_CALL hkSimdFloat32::fromHalf(const hkHalf16& x)
{
    hkSimdFloat32 r;
    r.setFromHalf(x);
    return r;
}

/*static*/ HK_INLINE hkSimdFloat32 HK_CALL hkSimdFloat32::fromUint16(const hkUint16& x)
{
    hkSimdFloat32 r;
    r.setFromUint16(x);
    return r;
}

/*static*/ HK_INLINE hkSimdFloat32 HK_CALL hkSimdFloat32::fromUint8(const hkUint8& x)
{
    hkSimdFloat32 r;
    r.setFromUint8(x);
    return r;
}

/*static*/ HK_INLINE hkSimdFloat32 HK_CALL hkSimdFloat32::fromInt32(const hkInt32& x)
{
    hkSimdFloat32 r;
#if defined(HK_COMPILER_GCC_VERSION) && (HK_COMPILER_GCC_VERSION >= 40800)  
    const int i = x;
    r.setFromInt32(i);
#else
    r.setFromInt32(x);
#endif
    return r;
}

void hkSimdFloat32::setFromHalf(const hkHalf32& x)
{
    setFromFloat( x.m_value );
}

template <int N>
void hkSimdFloat32::store(_Out_writes_all_(N) hkHalf32 *p ) const
{
    store<N>( &p->m_value);
}

template <int N>
void hkSimdFloat32::load(_In_reads_(N) const hkHalf32 *p )
{
    load<N>( &p->m_value);
}

template <int N, hkMathIoMode A>
void hkSimdFloat32::load(_In_reads_(N) const hkHalf32 *p )
{
    load<N,A>( &p->m_value );
}

template <int N, hkMathIoMode A>
void hkSimdFloat32::store(_Out_writes_all_(N) hkHalf32 *p ) const
{
    store<N,A>( &p->m_value );
}

template <int N, hkMathIoMode A, hkMathRoundingMode R>
void hkSimdFloat32::store(_Out_writes_all_(N) hkHalf32 *p ) const
{
    store<N,A,R>( &p->m_value );
}


void hkSimdFloat32::setAdd(hkScalarFParam a, hkScalarFParam b)      {   *this = a + b;      }
void hkSimdFloat32::setSub(hkScalarFParam a, hkScalarFParam b)      {   *this = a - b;      }
void hkSimdFloat32::setMul(hkScalarFParam a, hkScalarFParam b)      {   *this = a * b;      }
void hkSimdFloat32::setAddMul(hkScalarFParam a, hkScalarFParam b, hkScalarFParam c){    *this = a + (b * c);    }
void hkSimdFloat32::setSubMul(hkScalarFParam a, hkScalarFParam b, hkScalarFParam c){    *this = a - (b * c); }

void hkSimdFloat32::operator= (hkScalarFParam v)            {   m_real = v.m_real;  }
void hkSimdFloat32::operator+=(hkScalarFParam a)            {   setAdd( *this, a ); }
void hkSimdFloat32::operator-=(hkScalarFParam a)            {   setSub( *this, a ); }
void hkSimdFloat32::operator*=(hkScalarFParam a)            {   setMul( *this, a ); }
void hkSimdFloat32::operator/=(hkScalarFParam a)            {   setDiv( *this, a ); }

const hkSimdFloat32 hkSimdFloat32::operator/ (hkScalarFParam r) const   {   hkSimdFloat32 q;    q.setDiv(*this,r);  return q;   }

HK_DETAIL_DIAG_MSVC_PUSH();
HK_DETAIL_DIAG_MSVC_OFF(4723); // potential divide by 0

template <hkMathAccuracyMode A, hkMathDivByZeroMode D>
void hkSimdFloat32::div(hkScalarFParam a)           {   setDiv<A,D>( *this, a );    }
void hkSimdFloat32::div(hkScalarFParam a)           {   setDiv( *this, a ); }
void hkSimdFloat32::add(hkScalarFParam a)           {   setAdd( *this, a ); }
void hkSimdFloat32::sub(hkScalarFParam a)           {   setSub( *this, a ); }
void hkSimdFloat32::mul(hkScalarFParam a)           {   setMul( *this, a ); }

HK_DETAIL_DIAG_MSVC_POP();

hkVector4f hkSimdFloat32::operator*(hkVector4f_ v) const
{
    hkVector4f r; r.setMul(*this, v);
    return r;
}

template <int N>
void hkSimdFloat32::setDot( hkVector4fParameter a, hkVector4fParameter b ){ *this = a.dot<N>(b);    }
void hkSimdFloat32::addMul(hkScalarFParam a, hkScalarFParam b)  {   setAddMul( *this, a, b );   }
void hkSimdFloat32::subMul(hkScalarFParam a, hkScalarFParam b)  {   setSubMul( *this, a, b );   }

void hkSimdFloat32::setInterpolate( hkScalarFParam a, hkScalarFParam b, hkScalarFParam t ){
#if 1
    const hkSimdFloat32 bminusA = b-a;
    setAddMul( a, t, bminusA );
#else
    *this = ((getConstant(HK_QUADREAL_1) - t) * a) + (t * b);
#endif
}


HK_INLINE bool hkSimdFloat32::approxEqual(hkScalarFParam v, hkScalarFParam epsilon) const
{
    hkSimdFloat32 t; t.setAbs(*this - v);
    return t.isLess(epsilon);
}

void hkSimdFloat32::setClamped( hkScalarFParam a, hkScalarFParam minVal, hkScalarFParam maxVal )
{
    // This ensures that if a is NAN, clamped will be maxVal afterwards
    const hkVector4fComparison maxValGtA = maxVal.greater(a);
    hkSimdFloat32 clamped; clamped.setSelect(maxValGtA, a, maxVal);
    setMax(minVal, clamped);
}

//
//  Returns the reciprocal value of self.
//  Accuracy: 23 bit, divide-by-0 not checked

HK_INLINE const hkSimdFloat32 hkSimdFloat32::reciprocal() const
{
    hkSimdFloat32 r;
    r.setReciprocal(*this);
    return r;
}

#ifndef HK_DISABLE_OLD_VECTOR4_INTERFACE

//
// old interface
//
HK_INLINE hkVector4fComparison hkSimdFloat32::isNegative() const { return lessZero(); }
HK_INLINE hkVector4fComparison hkSimdFloat32::isPositive() const { return greaterEqualZero(); }
HK_INLINE hkBool32 hkSimdFloat32::isZero() const { return isEqualZero(); }
HK_INLINE hkVector4fComparison hkSimdFloat32::compareLessThanZero() const { return lessZero(); }
HK_INLINE hkVector4fComparison hkSimdFloat32::compareGreaterThanZero() const { return greaterZero(); }
HK_INLINE hkVector4fComparison hkSimdFloat32::compareLessThan(hkScalarFParam a) const { return less(a); }
HK_INLINE hkVector4fComparison hkSimdFloat32::compareLessThanEqual(hkScalarFParam a) const { return lessEqual(a); }
HK_INLINE hkVector4fComparison hkSimdFloat32::compareGreaterThan(hkScalarFParam a) const { return greater(a); }
HK_INLINE hkVector4fComparison hkSimdFloat32::compareGreaterThanEqual(hkScalarFParam a) const { return greaterEqual(a); }

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
