// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

/*static*/ HK_INLINE hkSimdDouble64 HK_CALL hkSimdDouble64::fromFloat(const hkDouble64& x)
{
    hkSimdDouble64 r;
    r.setFromFloat(x);
    return r;
}

/*static*/ HK_ALWAYS_INLINE hkSimdDouble64 HK_CALL hkSimdDouble64::fromHalf(const hkHalf32& x)
{
    return fromFloat( x.m_value );
}

/*static*/ HK_INLINE hkSimdDouble64 HK_CALL hkSimdDouble64::fromHalf(const hkHalf16& x)
{
    hkSimdDouble64 r;
    r.setFromHalf(x);
    return r;
}

/*static*/ HK_INLINE hkSimdDouble64 HK_CALL hkSimdDouble64::fromUint16(const hkUint16& x)
{
    hkSimdDouble64 r;
    r.setFromUint16(x);
    return r;
}

/*static*/ HK_INLINE hkSimdDouble64 HK_CALL hkSimdDouble64::fromUint8(const hkUint8& x)
{
    hkSimdDouble64 r;
    r.setFromUint8(x);
    return r;
}

/*static*/ HK_INLINE hkSimdDouble64 HK_CALL hkSimdDouble64::fromInt32(const hkInt32& x)
{
    hkSimdDouble64 r;
    r.setFromInt32(x);
    return r;
}

HK_INLINE void hkSimdDouble64::setFromHalf(const hkHalf32& h)
{
    setFromFloat( h.m_value );
}

template <int N>
HK_INLINE void hkSimdDouble64::store(_Out_ hkHalf32 *p) const
{
    store<N>( &p->m_value );
}

template <int N>
HK_INLINE void hkSimdDouble64::load(_In_ const hkHalf32 *p)
{
    load<N>( &p->m_value );
}

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdDouble64::load(_In_ const hkHalf32 *p)
{
    load<N,A>( &p->m_value );
}

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdDouble64::store(_Out_  hkHalf32 *p) const
{
    store<N,A>( &p->m_value );
}

template <int N, hkMathIoMode A, hkMathRoundingMode R>
HK_INLINE void hkSimdDouble64::store(_Out_ hkHalf32 *p ) const
{
    store<N,A,R>( &p->m_value );
}


HK_INLINE void hkSimdDouble64::operator= (hkSimdDouble64Parameter v)
{
    m_real = v.m_real;
}

HK_INLINE void hkSimdDouble64::setAdd(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b)
{
    *this = a + b;
}
HK_INLINE void hkSimdDouble64::setSub(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b)
{
    *this = a - b;
}
HK_INLINE void hkSimdDouble64::setMul(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b)
{
    *this = a * b;
}

HK_INLINE void hkSimdDouble64::setAddMul(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b, hkSimdDouble64Parameter c)
{
    *this = a + (b * c);
}
HK_INLINE void hkSimdDouble64::setSubMul(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b, hkSimdDouble64Parameter c)
{
    *this = a - (b * c);
}

/// Return the product of self and \a v. ( return self * v )
hkVector4d hkSimdDouble64::operator* (hkVector4dParameter v) const
{
    hkVector4d r; r.setMul(*this, v);
    return r;
}

template <int N>
HK_INLINE void hkSimdDouble64::setDot( hkVector4dParameter a, hkVector4dParameter b )   {       *this = a.dot<N>(b);    }
HK_INLINE void hkSimdDouble64::setDiv(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b){    setDiv<HK_ACC_FULL,HK_DIV_IGNORE>(a,b);}



void hkSimdDouble64::operator+=(hkSimdDouble64Parameter a)  {   setAdd( *this, a ); }
void hkSimdDouble64::operator-=(hkSimdDouble64Parameter a)  {   setSub( *this, a ); }
void hkSimdDouble64::operator*=(hkSimdDouble64Parameter a)  {   setMul( *this, a ); }
void hkSimdDouble64::operator/=(hkSimdDouble64Parameter a)  {   setDiv( *this, a ); }

void hkSimdDouble64::add(hkSimdDouble64Parameter a)         {   setAdd( *this, a ); }
void hkSimdDouble64::sub(hkSimdDouble64Parameter a)         {   setSub( *this, a ); }
void hkSimdDouble64::mul(hkSimdDouble64Parameter a)         {   setMul( *this, a ); }

template <hkMathAccuracyMode A, hkMathDivByZeroMode D>
void hkSimdDouble64::div(hkSimdDouble64Parameter a)         {   setDiv<A,D>( *this, a );    }
void hkSimdDouble64::div(hkSimdDouble64Parameter a)         {   setDiv( *this, a ); }

void hkSimdDouble64::addMul(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b)   {   setAddMul( *this, a, b );   }
void hkSimdDouble64::subMul(hkSimdDouble64Parameter a, hkSimdDouble64Parameter b)   {   setSubMul( *this, a, b );   }


HK_INLINE void hkSimdDouble64::setInterpolate( hkSimdDouble64Parameter a, hkSimdDouble64Parameter b, hkSimdDouble64Parameter t )
{
#if 1
    const hkSimdDouble64 bminusA = b-a;
    setAddMul( a, t, bminusA );
#else
    *this = ((getConstant(HK_QUADREAL_1) - t) * a) + (t * b);
#endif
}



HK_INLINE bool hkSimdDouble64::approxEqual(hkSimdDouble64Parameter v, hkSimdDouble64Parameter epsilon) const
{
    hkSimdDouble64 t; t.setAbs(*this - v);
    return t.isLess(epsilon);
}

HK_INLINE void hkSimdDouble64::setClamped( hkSimdDouble64Parameter a, hkSimdDouble64Parameter minVal, hkSimdDouble64Parameter maxVal )
{
    // This ensures that if a is NAN, clamped will be maxVal afterwards
    const hkVector4dComparison maxValGtA = maxVal.greater(a);
    hkSimdDouble64 clamped; clamped.setSelect(maxValGtA, a, maxVal);
    setMax(minVal, clamped);
}

//
//  Returns the reciprocal value of self.
//  Accuracy: 23 bit, divide-by-0 not checked

HK_INLINE const hkSimdDouble64 hkSimdDouble64::reciprocal() const
{
    hkSimdDouble64 r;
    r.setReciprocal(*this);
    return r;
}

#ifndef HK_DISABLE_OLD_VECTOR4_INTERFACE

//
// old interface
//
HK_INLINE hkVector4dComparison hkSimdDouble64::isNegative() const { return lessZero(); }
HK_INLINE hkVector4dComparison hkSimdDouble64::isPositive() const { return greaterEqualZero(); }
HK_INLINE hkBool32 hkSimdDouble64::isZero() const { return isEqualZero(); }
HK_INLINE hkVector4dComparison hkSimdDouble64::compareLessThanZero() const { return lessZero(); }
HK_INLINE hkVector4dComparison hkSimdDouble64::compareGreaterThanZero() const { return greaterZero(); }
HK_INLINE hkVector4dComparison hkSimdDouble64::compareLessThan(hkSimdDouble64Parameter a) const { return less(a); }
HK_INLINE hkVector4dComparison hkSimdDouble64::compareLessThanEqual(hkSimdDouble64Parameter a) const { return lessEqual(a); }
HK_INLINE hkVector4dComparison hkSimdDouble64::compareGreaterThan(hkSimdDouble64Parameter a) const { return greater(a); }
HK_INLINE hkVector4dComparison hkSimdDouble64::compareGreaterThanEqual(hkSimdDouble64Parameter a) const { return greaterEqual(a); }

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
