// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Math/Vector/hkPackedVector3.h>

/// Compressed hkTransformf into 16 bytes.
/// For accuracy informations, please refer to hkPackedVector3 and hkPackUnitVector.
struct HK_EXPORT_COMMON hkPackedTransform
{
    HK_INLINE void  pack(const hkTransformf& t)     { hkQuaternionf q; q.set(t.getRotation()); m_translation.pack(t.getTranslation()); m_orientation.pack(q.m_vec); }
    HK_INLINE void  unpack(hkTransformf& t) const   { hkQuaternionf q; m_orientation.unpack(&q.m_vec); m_translation.unpack(t.getTranslation()); t.getRotation().set(q); }

    HK_INLINE void  pack(const hkTransformd& t)     { hkQuaterniond q; q.set(t.getRotation()); m_translation.pack(t.getTranslation()); m_orientation.pack(q.m_vec); }
    HK_INLINE void  unpack(hkTransformd& t) const   { hkQuaterniond q; m_orientation.unpack(&q.m_vec); m_translation.unpack(t.getTranslation()); t.getRotation().set(q); }


    hkPackedVector3         m_translation;  ///< Compressed translation.
    hkPackedUnitVector<4>   m_orientation;  ///< Compressed orientation.
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
