// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Math/Vector/hkIntVector.h>

#define HK_QUADINT_SINGLE(X) HK_QUADINT_CONSTANT(X, X, X, X)

HK_ALIGN16(const hkUint32 g_intVectorConstants[HK_QUADINT_END][4]) =
{
    HK_QUADINT_SINGLE(0xdeadbeef), // start marker, Components that aren't loaded during hkIntVector::load() are initialized to this in Debug and Dev configurations.

    HK_QUADINT_SINGLE(0),
    HK_QUADINT_SINGLE(1),
    HK_QUADINT_SINGLE(2),
    HK_QUADINT_SINGLE(4),
    HK_QUADINT_CONSTANT(0, 1, 2, 3),
    HK_QUADINT_CONSTANT(0x3f000000, 0x3f000001, 0x3f000002, 0x3f000003),
    HK_QUADINT_SINGLE(3),
    HK_QUADINT_CONSTANT(0xffff, 0xffff, 0xffff, 0xffff),

    // Permutation constants, for Xbox broadcast(i)
    HK_QUADINT_SINGLE(0x00010203),
    HK_QUADINT_SINGLE(0x04050607),
    HK_QUADINT_SINGLE(0x08090A0B),
    HK_QUADINT_SINGLE(0x0C0D0E0F)
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
