// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Sets the vertex bundle to the given vertices

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::set( Vec4_ vA, Vec4_ vB, Vec4_ vC, Vec4_ vD )
{
    Vec4 v0 = vA;
    Vec4 v1 = vB;
    Vec4 v2 = vC;
    Vec4 v3 = vD;

    hkMath::transpose( v0, v1, v2, v3 );

    m_vertices[0] = v0;
    m_vertices[1] = v1;
    m_vertices[2] = v2;
}

//
//  Extracts the vectors from the vertex bundle
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::extract( Vec4& vA, Vec4& vB, Vec4& vC, Vec4& vD ) const
{
    vA = m_vertices[0];
    vB = m_vertices[1];
    vC = m_vertices[2];
    vD.setZero();

    hkMath::transpose( vA, vB, vC, vD );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::extractWithW( Vec4_ wABCD, Vec4& vA, Vec4& vB, Vec4& vC, Vec4& vD ) const
{
    vA = m_vertices[0];
    vB = m_vertices[1];
    vC = m_vertices[2];
    vD = wABCD;

    hkMath::transpose( vA, vB, vC, vD );
}


//
//  Extracts the vector at index from the bundle
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::extract( int index, Vec4& vI ) const
{
    HK_ASSERT_NO_MSG( 0x66e853d, index >= 0 && index < 4 );

#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    Vec4 v[4];
    extract( v[0], v[1], v[2], v[3] );
    vI = v[index];
#else
    vI.set( m_vertices[0]( index ), m_vertices[1]( index ), m_vertices[2]( index ), hkFloat32( 0 ) );
#endif
}

//
//  Sets the vertex bundle to the same vertex
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setAll( Vec4_ v )
{
    m_vertices[0].setAll( v.template getComponent<0>() );
    m_vertices[1].setAll( v.template getComponent<1>() );
    m_vertices[2].setAll( v.template getComponent<2>() );
}

//
//  Sets this = v - a

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setAdd( const hkFourTransposedPointsImpl<FT>& v, Vec4_ a )
{
    Vec4 ax;  ax.setAll( a.template getComponent<0>() );
    Vec4 ay;  ay.setAll( a.template getComponent<1>() );
    Vec4 az;  az.setAll( a.template getComponent<2>() );
    m_vertices[0].setAdd( v.m_vertices[0], ax );
    m_vertices[1].setAdd( v.m_vertices[1], ay );
    m_vertices[2].setAdd( v.m_vertices[2], az );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setSub( const hkFourTransposedPointsImpl<FT>& v, Vec4_ a )
{
    Vec4 ax;  ax.setAll( a.template getComponent<0>() );
    Vec4 ay;  ay.setAll( a.template getComponent<1>() );
    Vec4 az;  az.setAll( a.template getComponent<2>() );

    m_vertices[0].setSub( v.m_vertices[0], ax );
    m_vertices[1].setSub( v.m_vertices[1], ay );
    m_vertices[2].setSub( v.m_vertices[2], az );
}

//
//  Sets this = a - v
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setSub( Vec4_ a, const hkFourTransposedPointsImpl<FT>& v )
{
    Vec4 ax;  ax.setAll( a.template getComponent<0>() );
    Vec4 ay;  ay.setAll( a.template getComponent<1>() );
    Vec4 az;  az.setAll( a.template getComponent<2>() );

    m_vertices[0].setSub( ax, v.m_vertices[0] );
    m_vertices[1].setSub( ay, v.m_vertices[1] );
    m_vertices[2].setSub( az, v.m_vertices[2] );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setSub( const hkFourTransposedPointsImpl<FT>& v, const hkFourTransposedPointsImpl<FT>& a )
{
    m_vertices[0].setSub( v.m_vertices[0], a.m_vertices[0] );
    m_vertices[1].setSub( v.m_vertices[1], a.m_vertices[1] );
    m_vertices[2].setSub( v.m_vertices[2], a.m_vertices[2] );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setAdd( const hkFourTransposedPointsImpl<FT>& v, const hkFourTransposedPointsImpl<FT>& a )
{
    m_vertices[0].setAdd( v.m_vertices[0], a.m_vertices[0] );
    m_vertices[1].setAdd( v.m_vertices[1], a.m_vertices[1] );
    m_vertices[2].setAdd( v.m_vertices[2], a.m_vertices[2] );
}

template <typename FT>
template <hkMathAccuracyMode A, hkMathDivByZeroMode D>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setDiv( const hkFourTransposedPointsImpl<FT>& a, const hkFourTransposedPointsImpl<FT>& b )
{
    m_vertices[0].setDiv<A, D>( a.m_vertices[0], b.m_vertices[0] );
    m_vertices[1].setDiv<A, D>( a.m_vertices[1], b.m_vertices[1] );
    m_vertices[2].setDiv<A, D>( a.m_vertices[2], b.m_vertices[2] );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setMulC( const hkFourTransposedPointsImpl<FT>& v, Vec4_ a )
{
    Vec4 ax;  ax.setAll( a.template getComponent<0>() );
    Vec4 ay;  ay.setAll( a.template getComponent<1>() );
    Vec4 az;  az.setAll( a.template getComponent<2>() );

    m_vertices[0].setMul( v.m_vertices[0], ax );
    m_vertices[1].setMul( v.m_vertices[1], ay );
    m_vertices[2].setMul( v.m_vertices[2], az );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setMulT( const hkFourTransposedPointsImpl<FT>& v, Vec4_ a )
{
    m_vertices[0].setMul( v.m_vertices[0], a );
    m_vertices[1].setMul( v.m_vertices[1], a );
    m_vertices[2].setMul( v.m_vertices[2], a );
}


template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setMul( const hkFourTransposedPointsImpl<FT>& v, const hkFourTransposedPointsImpl<FT>& a )
{
    m_vertices[0].setMul( v.m_vertices[0], a.m_vertices[0] );
    m_vertices[1].setMul( v.m_vertices[1], a.m_vertices[1] );
    m_vertices[2].setMul( v.m_vertices[2], a.m_vertices[2] );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setMul( const hkFourTransposedPointsImpl<FT>& a, Scalar_ b )
{
    m_vertices[0].setMul( a.m_vertices[0], b );
    m_vertices[1].setMul( a.m_vertices[1], b );
    m_vertices[2].setMul( a.m_vertices[2], b );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setMin( const hkFourTransposedPointsImpl<FT>& v, const hkFourTransposedPointsImpl<FT>& a )
{
    m_vertices[0].setMin( v.m_vertices[0], a.m_vertices[0] );
    m_vertices[1].setMin( v.m_vertices[1], a.m_vertices[1] );
    m_vertices[2].setMin( v.m_vertices[2], a.m_vertices[2] );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setMax( const hkFourTransposedPointsImpl<FT>& v, const hkFourTransposedPointsImpl<FT>& a )
{
    m_vertices[0].setMax( v.m_vertices[0], a.m_vertices[0] );
    m_vertices[1].setMax( v.m_vertices[1], a.m_vertices[1] );
    m_vertices[2].setMax( v.m_vertices[2], a.m_vertices[2] );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::horizontalMin( Vec4& minOut ) const
{
    Vec4 min01; min01.setMin( m_vertices[0], m_vertices[1] );
    minOut.setMin( min01, m_vertices[2] );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::horizontalMax( Vec4& maxOut ) const
{
    Vec4 max01; max01.setMax( m_vertices[0], m_vertices[1] );
    maxOut.setMax( max01, m_vertices[2] );
}


//
//  Sets v0 = b*c0, v1 = b*c1, etc.

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setOuterProduct( Vec4_ b, Vec4_ c )
{
    m_vertices[0].setMul( c, b.template getComponent<0>() );
    m_vertices[1].setMul( c, b.template getComponent<1>() );
    m_vertices[2].setMul( c, b.template getComponent<2>() );
}


//
//  Sets v0 += b*c0, v1 = b*c1, etc.
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::addOuterProduct( Vec4_ b, Vec4_ c )
{
    m_vertices[0].addMul( c, b.template getComponent<0>() );
    m_vertices[1].addMul( c, b.template getComponent<1>() );
    m_vertices[2].addMul( c, b.template getComponent<2>() );
}


//
//  Sets v0 -= b*c0, v1 = b*c1, etc.
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::subOuterProduct( Vec4_ b, Vec4_ c )
{
    m_vertices[0].subMul( c, b.template getComponent<0>() );
    m_vertices[1].subMul( c, b.template getComponent<1>() );
    m_vertices[2].subMul( c, b.template getComponent<2>() );
}


//
//  Returns the dot3 of this and a
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::dot3( Vec4_ a, Vec4& dotOut ) const
{
    Vec4 ax;  ax.template setBroadcast<0>( a );
    Vec4 ay;  ay.template setBroadcast<1>( a );
    Vec4 az;  az.template setBroadcast<2>( a );

    ax.mul( m_vertices[0] );
    ay.mul( m_vertices[1] );
    az.mul( m_vertices[2] );

    dotOut.setAdd( ax, ay );
    dotOut.add( az );
}

//
//  Returns the dot3 of this and a
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::dot3( const hkFourTransposedPointsImpl<FT>& a, Vec4& dotOut ) const
{
    Vec4 vx;  vx.setMul( m_vertices[0], a.m_vertices[0] );
    vx.addMul( m_vertices[1], a.m_vertices[1] );
    vx.addMul( m_vertices[2], a.m_vertices[2] );
    dotOut = vx;
}

//
//  Translates the points along direction dir by distances(i), i.e. x(i) = v.x(i) + dir.x * distances(i), etc..
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setAddMul( const hkFourTransposedPointsImpl<FT>& v, Vec4_ dir, Vec4_ distances )
{
    m_vertices[0].setAddMul( v.m_vertices[0], distances, dir.template getComponent<0>() );
    m_vertices[1].setAddMul( v.m_vertices[1], distances, dir.template getComponent<1>() );
    m_vertices[2].setAddMul( v.m_vertices[2], distances, dir.template getComponent<2>() );
}

//
//  Sets this = projection of each point on the given Aabb
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setAabbProjection( const hkFourTransposedPointsImpl<FT>& v, const hkAabb& aabb )
{
    Vec4 mmin; mmin.set( aabb.m_min ); // float double conversion
    Vec4 mmax; mmax.set( aabb.m_max ); // float double conversion
    {
        Vec4 xMin;    xMin.template setBroadcast<0>( mmin );
        Vec4 xMax;    xMax.template setBroadcast<0>( mmax );
        Vec4 x;   x.setMax( xMin, v.m_vertices[0] );    m_vertices[0].setMin( xMax, x );
    }

    {
        Vec4 yMin;    yMin.template setBroadcast<1>( mmin );
        Vec4 yMax;    yMax.template setBroadcast<1>( mmax );
        Vec4 y;   y.setMax( yMin, v.m_vertices[1] );    m_vertices[1].setMin( yMax, y );
    }

    {
        Vec4 zMin;    zMin.template setBroadcast<2>( mmin );
        Vec4 zMax;    zMax.template setBroadcast<2>( mmax );
        Vec4 z;   z.setMax( zMin, v.m_vertices[2] );    m_vertices[2].setMin( zMax, z );
    }
}

//
//  Translates the points along direction -dir by distances(i), i.e. x(i) = v.x(i) - dir.x * distances(i), etc..
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setSubMul( const hkFourTransposedPointsImpl<FT>& v, Vec4_ dir, Vec4_ distances )
{
    m_vertices[0].setSubMul( v.m_vertices[0], distances, dir.template getComponent<0>() );
    m_vertices[1].setSubMul( v.m_vertices[1], distances, dir.template getComponent<1>() );
    m_vertices[2].setSubMul( v.m_vertices[2], distances, dir.template getComponent<2>() );
}

//
//  Returns the dot4 of this and a, with the w-coordinates of this assumed to be 1
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::dot4xyz1( Vec4_ a, Vec4& dotOut ) const
{
    dotOut.template setBroadcast<3>( a );
    dotOut.addMul( m_vertices[0], a.template getComponent<0>() );
    dotOut.addMul( m_vertices[1], a.template getComponent<1>() );
    dotOut.addMul( m_vertices[2], a.template getComponent<2>() );
}

//
//  Sets v0 += a, v1 += a, etc.
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::add( Vec4_ a )
{
    Vec4 ax; ax.template setBroadcast<0>( a );
    Vec4 ay; ay.template setBroadcast<1>( a );
    Vec4 az; az.template setBroadcast<2>( a );

    m_vertices[0].add( ax );
    m_vertices[1].add( ay );
    m_vertices[2].add( az );
}
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::add( const hkFourTransposedPointsImpl<FT>& v )
{
    m_vertices[0].add( v.m_vertices[0] );
    m_vertices[1].add( v.m_vertices[1] );
    m_vertices[2].add( v.m_vertices[2] );
}

//
//  Sets v0 -= a, v1 -= a, etc.
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::sub( Vec4_ a )
{
    Vec4 ax; ax.template setBroadcast<0>( a );
    Vec4 ay; ay.template setBroadcast<1>( a );
    Vec4 az; az.template setBroadcast<2>( a );

    m_vertices[0].sub( ax );
    m_vertices[1].sub( ay );
    m_vertices[2].sub( az );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::sub( const hkFourTransposedPointsImpl<FT>& v )
{
    m_vertices[0].sub( v.m_vertices[0] );
    m_vertices[1].sub( v.m_vertices[1] );
    m_vertices[2].sub( v.m_vertices[2] );
}


//
//  Multiply all components by a
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::mul( Scalar_ a )
{
    m_vertices[0].mul( a );
    m_vertices[1].mul( a );
    m_vertices[2].mul( a );
}

template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::mul( const hkFourTransposedPointsImpl<FT>& v )
{
    m_vertices[0].mul( v.m_vertices[0] );
    m_vertices[1].mul( v.m_vertices[1] );
    m_vertices[2].mul( v.m_vertices[2] );
}


//
//  Sets this = v + u * a
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setAddMulT( const hkFourTransposedPointsImpl<FT>& v, const hkFourTransposedPointsImpl<FT>& u, Vec4_ a )
{
    m_vertices[0].setAddMul( v.m_vertices[0], u.m_vertices[0], a );
    m_vertices[1].setAddMul( v.m_vertices[1], u.m_vertices[1], a );
    m_vertices[2].setAddMul( v.m_vertices[2], u.m_vertices[2], a );
}

//
//  Sets this = v - u * a
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setSubMulT( const hkFourTransposedPointsImpl<FT>& v, const hkFourTransposedPointsImpl<FT>& u, Vec4_ a )
{
    m_vertices[0].setSubMul( v.m_vertices[0], u.m_vertices[0], a );
    m_vertices[1].setSubMul( v.m_vertices[1], u.m_vertices[1], a );
    m_vertices[2].setSubMul( v.m_vertices[2], u.m_vertices[2], a );
}

//
//  Sets this += ui * a, i = 0..3
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::addMulT( const hkFourTransposedPointsImpl<FT>& u, Vec4_ a )
{
    m_vertices[0].addMul( u.m_vertices[0], a );
    m_vertices[1].addMul( u.m_vertices[1], a );
    m_vertices[2].addMul( u.m_vertices[2], a );
}

//
//  Sets this -= ui * a, i = 0..3
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::subMulT( const hkFourTransposedPointsImpl<FT>& u, Vec4_ a )
{
    m_vertices[0].subMul( u.m_vertices[0], a );
    m_vertices[1].subMul( u.m_vertices[1], a );
    m_vertices[2].subMul( u.m_vertices[2], a );
}

//
//  Sets this *= a
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::mulT( Vec4_ a )
{
    m_vertices[0].mul( a );
    m_vertices[1].mul( a );
    m_vertices[2].mul( a );
}

//
//  Sets this = cross(n, v)
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setCross( Vec4_ n, const hkFourTransposedPointsImpl<FT>& v )
{
    const Scalar nx = n.template getComponent<0>();
    const Scalar ny = n.template getComponent<1>();
    const Scalar nz = n.template getComponent<2>();

    Vec4 v0;  v0.setMul( v.m_vertices[2], ny ); // ny * z0123
    Vec4 v1;  v1.setMul( v.m_vertices[0], nz ); // nz * x0123
    Vec4 v2;  v2.setMul( v.m_vertices[1], nx ); // nx * y0123

    v0.subMul( v.m_vertices[1], nz ); // ny * z0123 - nz * y0123
    v1.subMul( v.m_vertices[2], nx ); // nz * x0123 - nx * z0123
    v2.subMul( v.m_vertices[0], ny ); // nx * y0123 - ny * x0123

    m_vertices[0] = v0;
    m_vertices[1] = v1;
    m_vertices[2] = v2;
}

//
//  Sets this = cross(v, n)
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setCross( const hkFourTransposedPointsImpl<FT>& v, Vec4_ n )
{
    const Scalar nx = n.template getComponent<0>();
    const Scalar ny = n.template getComponent<1>();
    const Scalar nz = n.template getComponent<2>();

    Vec4 v0;  v0.setMul( v.m_vertices[1], nz ); // y0123 * nz
    Vec4 v1;  v1.setMul( v.m_vertices[2], nx ); // z0123 * nx
    Vec4 v2;  v2.setMul( v.m_vertices[0], ny ); // x0123 * ny

    v0.subMul( v.m_vertices[2], ny ); // y0123 * nz - z0123 * ny
    v1.subMul( v.m_vertices[0], nz ); // z0123 * nx - x0123 * nz
    v2.subMul( v.m_vertices[1], nx ); // x0123 * ny - y0123 * nx

    m_vertices[0] = v0;
    m_vertices[1] = v1;
    m_vertices[2] = v2;
}

//
//  Flips the signs, i.e. v0 = sign(ax) * v0, ..., v3 = sign(aw) * v3
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::flipSigns( Vec4_ a )
{
    m_vertices[0].setFlipSign( m_vertices[0], a );
    m_vertices[1].setFlipSign( m_vertices[1], a );
    m_vertices[2].setFlipSign( m_vertices[2], a );
}

//
//  Selects a set of vectors i.e. vi = mask(i) ? ai : bi, for i = 0..3
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setSelect( const Comparison& mask, const hkFourTransposedPointsImpl<FT>& trueVecs, const hkFourTransposedPointsImpl<FT>& falseVecs )
{
    m_vertices[0].setSelect( mask, trueVecs.m_vertices[0], falseVecs.m_vertices[0] );
    m_vertices[1].setSelect( mask, trueVecs.m_vertices[1], falseVecs.m_vertices[1] );
    m_vertices[2].setSelect( mask, trueVecs.m_vertices[2], falseVecs.m_vertices[2] );
}

//
//  Sets this = Transpose(m) * v
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::_setTransformedInverseDir( const Matrix3& m, const hkFourTransposedPointsImpl<FT>& v )
{
    Vec4 vDots0;  v.dot3( m.template getColumn<0>(), vDots0 );
    Vec4 vDots1;  v.dot3( m.template getColumn<1>(), vDots1 );
    Vec4 vDots2;  v.dot3( m.template getColumn<2>(), vDots2 );

    m_vertices[0] = vDots0;
    m_vertices[1] = vDots1;
    m_vertices[2] = vDots2;
}

//
//  Sets this = Transpose(Rotation(m)) * (v - Translation(m))
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::_setTransformedInversePos( const Transform& m, const hkFourTransposedPointsImpl<FT>& v )
{
    hkFourTransposedPointsImpl tmp;
    tmp.setSub( v, m.getTranslation() );

    setTransformedInverseDir( m.getRotation(), tmp );
}

//
//  Sets this = m * v
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::_setRotatedDir( const Matrix3& m, const hkFourTransposedPointsImpl<FT>& v )
{
    Vec4 outLine0, outLine1, outLine2;
    {
        const Vec4& c0 = m.template getColumn<0>();
        const Vec4& l0 = v.m_vertices[0];
        const Scalar m00 = c0.template getComponent<0>();
        const Scalar m10 = c0.template getComponent<1>();
        const Scalar m20 = c0.template getComponent<2>();

        outLine0.setMul( m00, l0 );   // l0 = (m00 * ax, m00 * bx, m00 * cx, m00 * dx)
        outLine1.setMul( m10, l0 );   // l1 = (m10 * ax, m10 * bx, m10 * cx, m10 * dx)
        outLine2.setMul( m20, l0 );   // l2 = (m20 * ax, m20 * bx, m20 * cx, m20 * dx)
    }

    {
        const Vec4& c1 = m.template getColumn<1>();
        const Vec4& l1 = v.m_vertices[1];
        const Scalar m01 = c1.template getComponent<0>();
        const Scalar m11 = c1.template getComponent<1>();
        const Scalar m21 = c1.template getComponent<2>();

        outLine0.addMul( m01, l1 );   // l0 = (m00 * ax + m01 * ay, m00 * bx + m01 * by, m00 * cx + m01 * cy, m00 * dx + m01 * dy)
        outLine1.addMul( m11, l1 );   // l1 = (m10 * ax + m11 * ay, m10 * bx + m11 * by, m10 * cx + m11 * cy, m10 * dx + m11 * dy)
        outLine2.addMul( m21, l1 );   // l2 = (m20 * ax + m21 * ay, m20 * bx + m01 * by, m20 * cx + m21 * cy, m20 * dx + m21 * dy)
    }

    {
        const Vec4& c2 = m.template getColumn<2>();
        const Vec4& l2 = v.m_vertices[2];
        const Scalar m02 = c2.template getComponent<0>();
        const Scalar m12 = c2.template getComponent<1>();
        const Scalar m22 = c2.template getComponent<2>();

        outLine0.addMul( m02, l2 );   // l0 = (mLine0 * a, mLine0 * b, mLine0 * c, mLine0 * d)
        outLine1.addMul( m12, l2 );   // l1 = (mLine1 * a, mLine1 * b, mLine1 * c, mLine1 * d)
        outLine2.addMul( m22, l2 );   // l2 = (mLine2 * a, mLine2 * b, mLine2 * c, mLine2 * d)
    }

    m_vertices[0] = outLine0;
    m_vertices[1] = outLine1;
    m_vertices[2] = outLine2;
}

//
//  Normalizes all 4 points
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::normalize()
{
    Vec4 lengthsSquared;
    dot3( *this, lengthsSquared );

    Vec4 lengthsInv;
    
    lengthsInv.setSqrtInverse( lengthsSquared );

    m_vertices[0].mul( lengthsInv );
    m_vertices[1].mul( lengthsInv );
    m_vertices[2].mul( lengthsInv );
}

//
//  Permutes the vectors
template <typename FT>
template <hkVectorPermutation::Permutation perm>
HK_INLINE void hkFourTransposedPointsImpl<FT>::setPermutation( const hkFourTransposedPointsImpl<FT>& pts )
{
    m_vertices[0].template setPermutation<perm>( pts.m_vertices[0] );
    m_vertices[1].template setPermutation<perm>( pts.m_vertices[1] );
    m_vertices[2].template setPermutation<perm>( pts.m_vertices[2] );
}

//
//  Computes the average of the four points
template <typename FT>
HK_INLINE void hkFourTransposedPointsImpl<FT>::computeAverage( Vec4& avgOut ) const
{
    Vec4 v0, v1, v2, v3;
    extract( v0, v1, v2, v3 );
    v0.add( v1 );
    v2.add( v3 );
    v0.add( v2 );
    avgOut.setMul( Scalar::fromFloat( 0.25f ), v0 );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
