// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>
#include <Geometry/Collide/Types/hkcdVertex.h>
#include <Common/Base/Math/Vector/hkIntVector.h>


template <typename FT>
void hkFourTransposedPointsImpl<FT>::setTransformedInverseDir( const Matrix3& m, const hkFourTransposedPointsImpl<FT>& v )
{
    _setTransformedInverseDir( m, v );
}

//
//  Sets this = Transpose(Rotation(m)) * (v - Translation(m))
template <typename FT>
void hkFourTransposedPointsImpl<FT>::setTransformedInversePos( const Transform& m, const hkFourTransposedPointsImpl<FT>& v )
{
    _setTransformedInversePos( m, v );
}

//
//  Sets this = m * v
template <typename FT>
void hkFourTransposedPointsImpl<FT>::setRotatedDir( const Matrix3& m, const hkFourTransposedPointsImpl<FT>& v )
{
    _setRotatedDir( m, v );
}

//
//  Copies the points from a Vec4 array into a hkFourTransposedPointsImpl array
template <typename FT>
void HK_CALL hkFourTransposedPointsImpl<FT>::copyVertexData( _In_reads_( numVerts ) const Vec4* HK_RESTRICT src, const int numVerts,
    hkArray<hkFourTransposedPointsImpl<FT>>& pointsOut )
{
    const int paddedSize = HK_NEXT_MULTIPLE_OF( 4, numVerts );
    const int numBatches = numVerts >> 2;

    hkFourTransposedPointsImpl* HK_RESTRICT dst = pointsOut.expandBy( paddedSize >> 2 );
    for ( int bi = 0; bi < numBatches; bi++, src += 4 )
    {
        dst[bi].set( src[0], src[1], src[2], src[3] );
    }

    // Last batch
    const int numRemaining = numVerts - (numBatches << 2);
    if ( numRemaining > 0 )
    {
        // Get remaining vertices
        Vec4 verts[4];
        for ( int i = 0; i < numRemaining; i++ )
        {
            verts[i] = src[i];
        }

        // Fill rest with the last vertex
        for ( int i = numRemaining; i < 4; i++ )
        {
            verts[i] = src[numRemaining - 1];
        }

        dst[numBatches].set( verts[0], verts[1], verts[2], verts[3] );
    }
}


//
//  Computes the distance from all vertices to the given Aaabb
template <typename FT>
void hkFourTransposedPointsImpl<FT>::computeAabbDistanceSq( const hkAabb& aabb, Vec4& distancesOut ) const
{
    // Project points on AABB
    hkFourTransposedPointsImpl proj;
    proj.setAabbProjection( *this, aabb );
    proj.setSub( proj, *this );
    proj.dot3( proj, distancesOut );
}

template <typename FT>
void hkFourTransposedPointsImpl<FT>::getOriginalVertices( _In_reads_( HK_NEXT_MULTIPLE_OF( 4, numVertices ) / 4 ) const hkFourTransposedPointsImpl* verts4in, int numVertices,
    _Inout_updates_all_( HK_NEXT_MULTIPLE_OF( 4, numVertices ) ) hkcdVertex* verticesOut )
{
    const hkFourTransposedPointsImpl* HK_RESTRICT vIn = verts4in;
    hkcdVertex* HK_RESTRICT vOut = verticesOut;
    int numFours = int( unsigned( numVertices + 3 ) / 4 );
    hkIntVector indices = hkIntVector::getConstant<HK_QUADINT_0123>();
    const hkIntVector& indicesStep = hkIntVector::getConstant<HK_QUADINT_4>();
    for ( int bi = 0; bi < numFours; bi++ )
    {
        hkVector4 x; x.set( vIn[bi].m_vertices[0] );    // float double conversion
        hkVector4 y; y.set( vIn[bi].m_vertices[1] );
        hkVector4 z; z.set( vIn[bi].m_vertices[2] );
        hkVector4 w; indices.storeInto24LowerBitsOfReal( w );

        hkMath::transpose( x, y, z, w );

        vOut[0].assign( x );
        vOut[1].assign( y );
        vOut[2].assign( z );
        vOut[3].assign( w );

        vOut += 4;
        indices.setAddU32( indices, indicesStep );
    }
    int nv = numVertices; // ensure the padding vertices duplicate the last one
    for ( int i = nv; i < numFours * 4; ++i )
    {
        verticesOut[i] = verticesOut[nv - 1];
    }
}

template<typename FT> hkReflect::Detail::AddrAndType hkFourTransposedPointsImpl<FT>::getExactType( void ) const
{
    return hkReflect::Detail::AddrAndType(this, hkReflect::getType<hkFourTransposedPointsImpl<FT> >() );
}
template<typename FT> hkTrait::Yes hkFourTransposedPointsImpl<FT>::operator== ( const hkTrait::TypeIsPod& ) const { return true; } ;

template class hkFourTransposedPointsImpl<hkFloat32>;
template class hkFourTransposedPointsImpl<hkDouble64>;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
