// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 DURANGO PS4 ANDROID_X86
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


/*static*/ const hkSimdFloat32 HK_CALL hkSimdFloat32::convert(const hkSingleFloat32& x)
{
    hkSimdFloat32 sr;
    sr.m_real = x;
    //HK_MATH_ASSERT(0x7c3a4d98, x.m128_i32[0] == x.m128_i32[1] && x.m128_i32[0] == x.m128_i32[2] && x.m128_i32[0] == x.m128_i32[3], "invalid simd scalar");
    return sr;
}

template<int vectorConstant>
HK_ALWAYS_INLINE const hkSimdFloat32 HK_CALL hkSimdFloat32::getConstant()
{
    static_assert(
        (vectorConstant>HK_QUADREAL_BEGIN) && (vectorConstant<HK_QUADREAL_END) &&
        (vectorConstant!=HK_QUADREAL_1000) && (vectorConstant!=HK_QUADREAL_0100) && (vectorConstant!=HK_QUADREAL_0010) && (vectorConstant!=HK_QUADREAL_0001) &&
        (vectorConstant!=HK_QUADREAL_m11m11) && (vectorConstant!=HK_QUADREAL_1m11m1) && (vectorConstant!=HK_QUADREAL_1248) && (vectorConstant!=HK_QUADREAL_8421) &&
        (vectorConstant!=HK_QUADREAL_0011) && (vectorConstant!=HK_QUADREAL_1010) && (vectorConstant!=HK_QUADREAL_0101)  && (vectorConstant!=HK_QUADREAL_1100)
        , "HK_SIMDFLOAT_ILLEGAL_CONSTANT_REQUEST");
    return convert(*(g_vectorfConstants + vectorConstant));
}

/*static*/ const hkSimdFloat32 HK_CALL hkSimdFloat32::getConstant(hkVectorConstant vectorConstant)
{
    HK_MATH_ASSERT( 0x909ff234,
        (vectorConstant>HK_QUADREAL_BEGIN) && (vectorConstant<HK_QUADREAL_END) &&
        (vectorConstant!=HK_QUADREAL_1000) && (vectorConstant!=HK_QUADREAL_0100) && (vectorConstant!=HK_QUADREAL_0010) && (vectorConstant!=HK_QUADREAL_0001) &&
        (vectorConstant!=HK_QUADREAL_m11m11) && (vectorConstant!=HK_QUADREAL_1m11m1) && (vectorConstant!=HK_QUADREAL_1248) && (vectorConstant!=HK_QUADREAL_8421) &&
        (vectorConstant!=HK_QUADREAL_0011) && (vectorConstant!=HK_QUADREAL_1010) && (vectorConstant!=HK_QUADREAL_0101)  && (vectorConstant!=HK_QUADREAL_1100)
        , "not a simdreal constant");
    return convert(*(g_vectorfConstants + vectorConstant));
}

#if !defined(HK_DISABLE_IMPLICIT_SIMDREAL_FLOAT_CONVERSION)
hkSimdFloat32::hkSimdFloat32(const hkFloat32& x)
{
    m_real = _mm_set1_ps(x);
}
#endif
#if !defined(HK_DISABLE_IMPLICIT_SIMDREAL_FLOAT_CONVERSION)
hkSimdFloat32::operator hkFloat32() const
{
    return _mm_cvtss_f32(m_real);
}
#endif

hkFloat32 hkSimdFloat32::getReal() const
{
    return _mm_cvtss_f32(m_real);
}

void hkSimdFloat32::setFromFloat(const hkFloat32& x)
{
    __m128 fx = _mm_load_ss(&x);
    m_real = _mm_shuffle_ps(fx,fx,_MM_SHUFFLE(0,0,0,0));
}

void hkSimdFloat32::setFromFloat(const hkDouble64& x)
{
    __m128d d = _mm_load_sd(&x);
    __m128 f = _mm_cvtpd_ps(d);
    m_real = _mm_shuffle_ps(f,f,_MM_SHUFFLE(0,0,0,0));
}

void hkSimdFloat32::setFromHalf(const hkHalf16& h)
{
    float x; h.store(&x);
    setFromFloat(x);
}

void hkSimdFloat32::setFromInt32(const hkInt32&  x)
{
    __m128 ix = _mm_cvtsi32_ss(_mm_setzero_ps(),x);
    m_real = _mm_shuffle_ps(ix,ix,_MM_SHUFFLE(0,0,0,0));
}


void hkSimdFloat32::setFromUint16(const hkUint16& x)
{
    int i = x;
    setFromInt32(i);
}

void hkSimdFloat32::setFromUint8(const hkUint8& x)
{
    int i = x;
    setFromInt32(i);
}

void hkSimdFloat32::setZero()
{
    m_real = _mm_setzero_ps();
}


void hkSimdFloat32::storeSaturateInt32(_Out_ hkInt32* HK_RESTRICT result) const
{
    *result = _mm_cvtsi128_si32(_mm_cvttps_epi32(m_real));
}


void hkSimdFloat32::storeSaturateUint16(_Out_ hkUint16* HK_RESTRICT result) const
{
    hkSingleFloat32 clamped   = _mm_max_ps(m_real,_mm_setzero_ps());
    clamped = _mm_min_ps(clamped,_mm_set1_ps(65535.0f));
    *result = hkUint16(_mm_cvtsi128_si32(_mm_cvttps_epi32(clamped)));
}


const hkSimdFloat32 hkSimdFloat32::operator+ (hkSimdFloat32Parameter r) const
{
    return hkSimdFloat32::convert(_mm_add_ps(m_real,r.m_real));
}

const hkSimdFloat32 hkSimdFloat32::operator- (hkSimdFloat32Parameter r) const
{
    return hkSimdFloat32::convert(_mm_sub_ps(m_real,r.m_real));
}

const hkSimdFloat32 hkSimdFloat32::operator* (hkSimdFloat32Parameter r) const
{
    return hkSimdFloat32::convert(_mm_mul_ps(m_real,r.m_real));
}


bool hkSimdFloat32::operator< (hkSimdFloat32Parameter r) const
{
    return _mm_ucomilt_ss(m_real, r.m_real);
}

bool hkSimdFloat32::operator<= (hkSimdFloat32Parameter r) const
{
    return _mm_ucomile_ss(m_real, r.m_real);
}

bool hkSimdFloat32::operator> (hkSimdFloat32Parameter r) const
{
    return _mm_ucomigt_ss(m_real, r.m_real);
}

bool hkSimdFloat32::operator>= (hkSimdFloat32Parameter r) const
{
    return _mm_ucomige_ss(m_real, r.m_real);
}

bool hkSimdFloat32::operator== (hkSimdFloat32Parameter r) const
{
    return _mm_ucomieq_ss(m_real, r.m_real);
}

bool hkSimdFloat32::operator!= (hkSimdFloat32Parameter r) const
{
    return _mm_ucomineq_ss(m_real, r.m_real);
}

const hkSimdFloat32 hkSimdFloat32::operator-() const
{
    return hkSimdFloat32::convert(_mm_sub_ps(_mm_setzero_ps(),m_real));
}

const hkVector4fComparison hkSimdFloat32::less(hkSimdFloat32Parameter a) const
{
    return hkVector4fComparison::convert(_mm_cmplt_ps(m_real, a.m_real));
}

const hkVector4fComparison hkSimdFloat32::greater(hkSimdFloat32Parameter a) const
{
    return hkVector4fComparison::convert(_mm_cmpgt_ps(m_real, a.m_real));
}

const hkVector4fComparison hkSimdFloat32::greaterEqual(hkSimdFloat32Parameter a) const
{
    return hkVector4fComparison::convert(_mm_cmpge_ps(m_real, a.m_real));
}

const hkVector4fComparison hkSimdFloat32::lessEqual(hkSimdFloat32Parameter a) const
{
    return hkVector4fComparison::convert(_mm_cmple_ps(m_real, a.m_real));
}

const hkVector4fComparison hkSimdFloat32::equal(hkSimdFloat32Parameter a) const
{
    return hkVector4fComparison::convert(_mm_cmpeq_ps(m_real, a.m_real));
}

const hkVector4fComparison hkSimdFloat32::notEqual(hkSimdFloat32Parameter a) const
{
    return hkVector4fComparison::convert(_mm_cmpneq_ps(m_real, a.m_real));
}

const hkVector4fComparison hkSimdFloat32::lessZero() const
{
    return hkVector4fComparison::convert(_mm_cmplt_ps(m_real, _mm_setzero_ps()));
}

const hkVector4fComparison hkSimdFloat32::lessEqualZero() const
{
    return hkVector4fComparison::convert(_mm_cmple_ps(m_real, _mm_setzero_ps()));
}

const hkVector4fComparison hkSimdFloat32::greaterZero() const
{
    return hkVector4fComparison::convert(_mm_cmpgt_ps(m_real, _mm_setzero_ps()));
}

const hkVector4fComparison hkSimdFloat32::greaterEqualZero() const
{
    return hkVector4fComparison::convert(_mm_cmpge_ps(m_real, _mm_setzero_ps()));
}

const hkVector4fComparison hkSimdFloat32::equalZero() const
{
    return hkVector4fComparison::convert(_mm_cmpeq_ps(m_real, _mm_setzero_ps()));
}

const hkVector4fComparison hkSimdFloat32::notEqualZero() const
{
    return hkVector4fComparison::convert(_mm_cmpneq_ps(m_real, _mm_setzero_ps()));
}

hkBool32 hkSimdFloat32::isLess(hkSimdFloat32Parameter a) const
{
    return _mm_ucomilt_ss(m_real, a.m_real);
}

hkBool32 hkSimdFloat32::isLessEqual(hkSimdFloat32Parameter a) const
{
    return _mm_ucomile_ss(m_real, a.m_real);
}

hkBool32 hkSimdFloat32::isGreater(hkSimdFloat32Parameter a) const
{
    return _mm_ucomigt_ss(m_real, a.m_real);
}

hkBool32 hkSimdFloat32::isGreaterEqual(hkSimdFloat32Parameter a) const
{
    return _mm_ucomige_ss(m_real, a.m_real);
}

hkBool32 hkSimdFloat32::isEqual(hkSimdFloat32Parameter a) const
{
    return _mm_ucomieq_ss(m_real, a.m_real);
}

hkBool32 hkSimdFloat32::isNotEqual(hkSimdFloat32Parameter a) const
{
    return _mm_ucomineq_ss(m_real, a.m_real);
}

hkBool32 hkSimdFloat32::isLessZero() const
{
    return _mm_ucomilt_ss(m_real, _mm_setzero_ps());
}

#define hkSimdFloat32_isSignBitSet
hkBool32 hkSimdFloat32::isSignBitSet() const
{
    return _mm_movemask_ps(m_real);
}


hkBool32 hkSimdFloat32::isLessEqualZero() const
{
    return _mm_ucomile_ss(m_real, _mm_setzero_ps());
}

hkBool32 hkSimdFloat32::isGreaterZero() const
{
    return _mm_ucomigt_ss(m_real, _mm_setzero_ps());
}

hkBool32 hkSimdFloat32::isGreaterEqualZero() const
{
    return _mm_ucomige_ss(m_real, _mm_setzero_ps());
}

hkBool32 hkSimdFloat32::isEqualZero() const
{
    return _mm_ucomieq_ss(m_real, _mm_setzero_ps());
}

hkBool32 hkSimdFloat32::isNotEqualZero() const
{
    return _mm_ucomineq_ss(m_real, _mm_setzero_ps());
}

hkBool32 hkSimdFloat32::isOk() const
{
    const hkSingleFloat32 nanMask = _mm_cmpord_ps(m_real, m_real);
    return _mm_movemask_ps(nanMask);
}

void hkSimdFloat32::setSelect( hkVector4fComparisonParameter comp, hkSimdFloat32Parameter trueValue, hkSimdFloat32Parameter falseValue )
{
    HK_MATH_ASSERT(0xc78f08e, comp.allAreSet() || (comp.getMask() == hkVector4ComparisonMask::MASK_NONE), "illegal compare mask");
#if HK_SSE_VERSION >= 0x41
    m_real = _mm_blendv_ps(falseValue.m_real, trueValue.m_real, comp.m_mask);
#else
    m_real = _mm_or_ps( _mm_and_ps(comp.m_mask, trueValue.m_real), _mm_andnot_ps(comp.m_mask, falseValue.m_real) );
#endif
}

void hkSimdFloat32::setClampedZeroOne( hkSimdFloat32Parameter a )
{
    // This ensures that if a is NAN, clamped will be 1 afterwards
    const __m128 one = g_vectorfConstants[HK_QUADREAL_1];
    __m128 GT = _mm_cmpgt_ps( one, a.m_real );
#if HK_SSE_VERSION >= 0x41
    __m128 clamped = _mm_blendv_ps(one, a.m_real, GT);
#else
    __m128 clamped = _mm_or_ps( _mm_and_ps(GT, a.m_real), _mm_andnot_ps(GT, one) );
#endif
    m_real = _mm_max_ps(_mm_setzero_ps(), clamped);
}

void hkSimdFloat32::zeroIfFalse( hkVector4fComparisonParameter comp )
{
    HK_MATH_ASSERT(0xc78f08e, comp.allAreSet() || (comp.getMask() == hkVector4ComparisonMask::MASK_NONE), "illegal compare mask");
    m_real = _mm_and_ps(comp.m_mask, m_real);
}

void hkSimdFloat32::zeroIfTrue( hkVector4fComparisonParameter comp )
{
    HK_MATH_ASSERT(0xc78f08e, comp.allAreSet() || (comp.getMask() == hkVector4ComparisonMask::MASK_NONE), "illegal compare mask");
    m_real = _mm_andnot_ps(comp.m_mask, m_real);
}

void hkSimdFloat32::setMin(  hkSimdFloat32Parameter a, hkSimdFloat32Parameter b )
{
    m_real = _mm_min_ps( a.m_real, b.m_real );
}

void hkSimdFloat32::setMax(  hkSimdFloat32Parameter a, hkSimdFloat32Parameter b )
{
    m_real = _mm_max_ps( a.m_real, b.m_real );
}

void hkSimdFloat32::setAbs(  hkSimdFloat32Parameter a )
{
    m_real = hkMath::quadFabs(a.m_real);
}

void hkSimdFloat32::setFloor(  hkSimdFloat32Parameter a )
{
    m_real = hkMath::quadFloor(a.m_real);
}

void hkSimdFloat32::setMod(  hkSimdFloat32Parameter a, hkSimdFloat32Parameter b )
{
    m_real = hkMath::quadMod(a.m_real,b.m_real);
}

void hkSimdFloat32::setFlipSign(hkSimdFloat32Parameter v, hkSimdFloat32Parameter sSign)
{
    const __m128i mask = _mm_slli_epi32(_mm_srli_epi32(_mm_castps_si128(sSign.m_real),31),31);
    m_real = _mm_xor_ps(v.m_real, _mm_castsi128_ps(mask));
}

void hkSimdFloat32::setFlipSign(hkSimdFloat32Parameter v, hkVector4fComparisonParameter mask)
{
    HK_MATH_ASSERT(0x5831c04, mask.allAreSet() || (mask.getMask() == hkVector4ComparisonMask::MASK_NONE), "illegal compare mask");
    const __m128i maskS = _mm_slli_epi32(_mm_srli_epi32(_mm_castps_si128(mask.m_mask),31),31);
    m_real = _mm_xor_ps(v.m_real, _mm_castsi128_ps(maskS));
}





//
// advanced interface
//

namespace hkSimdReal_AdvancedInterface
{
    
    HK_ALWAYS_INLINE hkSingleFloat32 singleSelect( const hkSingleFloat32& mask, const hkSingleFloat32& trueValue, const hkSingleFloat32& falseValue )
    {
#if HK_SSE_VERSION >= 0x41
        return _mm_blendv_ps(falseValue, trueValue, mask);
#else
        return _mm_or_ps( _mm_and_ps(mask, trueValue), _mm_andnot_ps(mask, falseValue) );
#endif
    }

    template<hkMathAccuracyMode ACC>
    HK_ALWAYS_INLINE void avoidDivideByZeroInDebug(const hkSingleFloat32& equalsZero, hkSingleFloat32& x)
    {
#if defined(HK_ALLOW_FPU_EXCEPTION_CHECKING) 
        if(ACC == HK_ACC_FULL)
        {
            x = singleSelect( equalsZero, g_vectorfConstants[HK_QUADREAL_1], x );
        }
#endif
    }

template <hkMathAccuracyMode A, hkMathDivByZeroMode D>
struct unrollf_setReciprocal { static HK_ALWAYS_INLINE void apply(hkSingleFloat32& self, const hkSingleFloat32& a)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <hkMathAccuracyMode A>
struct unrollf_setReciprocal<A, HK_DIV_IGNORE> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a)
{
    switch (A)
    {
        case HK_ACC_23_BIT: self = hkMath::quadReciprocal(a); break;
        case HK_ACC_12_BIT: self = _mm_rcp_ps(a); break;
        default:         self = _mm_div_ps(g_vectorfConstants[HK_QUADREAL_1],a); break; // HK_ACC_FULL
    }
} };
template <hkMathAccuracyMode A>
struct unrollf_setReciprocal<A, HK_DIV_SET_ZERO> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a)
{
    const hkSingleFloat32 equalsZero = _mm_cmpeq_ps(a, _mm_setzero_ps());

    hkSingleFloat32 aNonZero = a;
    avoidDivideByZeroInDebug<A>(equalsZero, aNonZero);

    hkSingleFloat32 e; unrollf_setReciprocal<A, HK_DIV_IGNORE>::apply(e, aNonZero);
    self = _mm_andnot_ps(equalsZero, e);
} };
template <hkMathAccuracyMode A>
struct unrollf_setReciprocal<A, HK_DIV_SET_HIGH> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a)
{
    const hkSingleFloat32 equalsZero = _mm_cmpeq_ps(a, _mm_setzero_ps());
    hkSingleFloat32 aNonZero = a; avoidDivideByZeroInDebug<A>(equalsZero, aNonZero);

    hkSingleFloat32 e; unrollf_setReciprocal<A, HK_DIV_IGNORE>::apply(e, aNonZero);
    hkSingleFloat32 huge = _mm_set1_ps(HK_FLOAT_HIGH);
#if HK_SSE_VERSION >= 0x41
    self = _mm_blendv_ps(e, huge, equalsZero);
#else
    self = _mm_or_ps( _mm_and_ps(equalsZero, huge), _mm_andnot_ps(equalsZero, e) );
#endif
} };
template <hkMathAccuracyMode A>
struct unrollf_setReciprocal<A, HK_DIV_SET_MAX> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a)
{
    const hkSingleFloat32 equalsZero = _mm_cmpeq_ps(a, _mm_setzero_ps());
    hkSingleFloat32 aNonZero = a;
    avoidDivideByZeroInDebug<A>(equalsZero, aNonZero);

    hkSingleFloat32 e; unrollf_setReciprocal<A, HK_DIV_IGNORE>::apply(e, aNonZero);
    hkSingleFloat32 huge = _mm_set1_ps(HK_FLOAT_MAX);
#if HK_SSE_VERSION >= 0x41
    self = _mm_blendv_ps(e, huge, equalsZero);
#else
    self = _mm_or_ps( _mm_and_ps(equalsZero, huge), _mm_andnot_ps(equalsZero, e) );
#endif
} };

template <hkMathAccuracyMode A>
struct unrollf_setReciprocal<A, HK_DIV_SET_ZERO_AND_ONE> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a)
{
    unrollf_setReciprocal<A, HK_DIV_SET_ZERO>::apply(self, a);
    const hkSingleFloat32 one = g_vectorfConstants[HK_QUADREAL_1];
    const hkSingleFloat32 absVal = hkMath::quadFabs(_mm_sub_ps(self, one));
    const hkSingleFloat32 lessEqualEps = _mm_cmple_ps(absVal, g_vectorfConstants[HK_QUADREAL_EPS]);
#if HK_SSE_VERSION >= 0x41
    self = _mm_blendv_ps(self, one, lessEqualEps);
#else
    self = _mm_or_ps( _mm_and_ps(lessEqualEps, one), _mm_andnot_ps(lessEqualEps, self) );
#endif
} };

} // namespace

template <hkMathAccuracyMode A, hkMathDivByZeroMode D>
void hkSimdFloat32::setReciprocal(hkSimdFloat32Parameter a)
{
    hkSimdReal_AdvancedInterface::unrollf_setReciprocal<A,D>::apply(m_real,a.m_real);
}

void hkSimdFloat32::setReciprocal(hkSimdFloat32Parameter a)
{
    hkSimdReal_AdvancedInterface::unrollf_setReciprocal<HK_ACC_MID,HK_DIV_IGNORE>::apply(m_real,a.m_real);
}

namespace hkSimdReal_AdvancedInterface
{

template <hkMathAccuracyMode A, hkMathDivByZeroMode D>
struct unrollf_setDiv { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a, const hkSingleFloat32& b)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <hkMathAccuracyMode A>
struct unrollf_setDiv<A, HK_DIV_IGNORE> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a, const hkSingleFloat32& b)
{
    switch (A)
    {
        case HK_ACC_23_BIT: self = _mm_mul_ps(a, hkMath::quadReciprocal(b)); break;
        case HK_ACC_12_BIT: self = _mm_mul_ps(a, _mm_rcp_ps(b)); break;
        default:            self = _mm_div_ps(a, b); break; // HK_ACC_FULL
    }
} };

template <hkMathAccuracyMode A>
struct unrollf_setDiv<A, HK_DIV_SET_ZERO> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a, const hkSingleFloat32& b)
{
    const hkSingleFloat32 equalsZero = _mm_cmpeq_ps(b, _mm_setzero_ps());

    hkSingleFloat32 bNonZero = b;
    avoidDivideByZeroInDebug<A>(equalsZero, bNonZero);

    hkSingleFloat32 e; unrollf_setDiv<A, HK_DIV_IGNORE>::apply(e, a, bNonZero);
    self = _mm_andnot_ps(equalsZero, e);
} };

template <hkMathAccuracyMode A>
struct unrollf_setDiv<A, HK_DIV_SET_HIGH> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a, const hkSingleFloat32& b)
{
    const hkSingleFloat32 equalsZero = _mm_cmpeq_ps(b, _mm_setzero_ps());
    hkSingleFloat32 bNonZero = b;
    avoidDivideByZeroInDebug<A>(equalsZero, bNonZero);

    hkSingleFloat32 e; unrollf_setDiv<A, HK_DIV_IGNORE>::apply(e, a, bNonZero);
    hkSingleFloat32 huge = _mm_set1_ps(HK_FLOAT_HIGH);
#if HK_SSE_VERSION >= 0x41
    self = _mm_blendv_ps(e, huge, equalsZero);
#else
    self = _mm_or_ps( _mm_and_ps(equalsZero, huge), _mm_andnot_ps(equalsZero, e) );
#endif
} };

template <hkMathAccuracyMode A>
struct unrollf_setDiv<A, HK_DIV_SET_MAX> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a, const hkSingleFloat32& b)
{
    const hkSingleFloat32 equalsZero = _mm_cmpeq_ps(b, _mm_setzero_ps());
    hkSingleFloat32 bNonZero = b;
    avoidDivideByZeroInDebug<A>(equalsZero, bNonZero);

    hkSingleFloat32 e; unrollf_setDiv<A, HK_DIV_IGNORE>::apply(e, a, bNonZero);
    hkSingleFloat32 huge = _mm_set1_ps(HK_FLOAT_MAX);
#if HK_SSE_VERSION >= 0x41
    self = _mm_blendv_ps(e, huge, equalsZero);
#else
    self = _mm_or_ps( _mm_and_ps(equalsZero, huge), _mm_andnot_ps(equalsZero, e) );
#endif
} };

template <hkMathAccuracyMode A>
struct unrollf_setDiv<A, HK_DIV_SET_ZERO_AND_ONE> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, const hkSingleFloat32& a, const hkSingleFloat32& b)
{
    unrollf_setDiv<A, HK_DIV_SET_ZERO>::apply(self, a, b);
    const hkSingleFloat32 one = g_vectorfConstants[HK_QUADREAL_1];
    const hkSingleFloat32 absVal = hkMath::quadFabs(_mm_sub_ps(self, one));
    const hkSingleFloat32 lessEqualEps = _mm_cmple_ps(absVal, g_vectorfConstants[HK_QUADREAL_EPS]);
#if HK_SSE_VERSION >= 0x41
    self = _mm_blendv_ps(self, one, lessEqualEps);
#else
    self = _mm_or_ps( _mm_and_ps(lessEqualEps, one), _mm_andnot_ps(lessEqualEps, self) );
#endif
} };

} // namespace

template <hkMathAccuracyMode A, hkMathDivByZeroMode D>
void hkSimdFloat32::setDiv(hkSimdFloat32Parameter a, hkSimdFloat32Parameter b)
{
    hkSimdReal_AdvancedInterface::unrollf_setDiv<A,D>::apply(m_real, a.m_real, b.m_real);
}

void hkSimdFloat32::setDiv(hkSimdFloat32Parameter a, hkSimdFloat32Parameter b)
{
    hkSimdReal_AdvancedInterface::unrollf_setDiv<HK_ACC_MID,HK_DIV_IGNORE>::apply(m_real,a.m_real,b.m_real);
}


namespace hkSimdReal_AdvancedInterface
{

template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
struct unrollf_sqrt { HK_ALWAYS_INLINE static hkSingleFloat32 apply(const hkSingleFloat32& self)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
    return _mm_setzero_ps();
} };
template <hkMathAccuracyMode A>
struct unrollf_sqrt<A, HK_SQRT_IGNORE> { HK_ALWAYS_INLINE static hkSingleFloat32 apply(const hkSingleFloat32& self)
{
    switch (A)
    {
        case HK_ACC_23_BIT: return _mm_mul_ps(self,hkMath::quadReciprocalSquareRoot(self)); break;
        case HK_ACC_12_BIT: return _mm_mul_ps(self,_mm_rsqrt_ps(self)); break;
        default:         return _mm_sqrt_ps(self); break; // HK_ACC_FULL
    }
} };
template <hkMathAccuracyMode A>
struct unrollf_sqrt<A, HK_SQRT_SET_ZERO> { HK_ALWAYS_INLINE static hkSingleFloat32 apply(const hkSingleFloat32& self)
{
    const hkSingleFloat32 equalsZero = _mm_cmple_ps(self, _mm_setzero_ps());
    const hkSingleFloat32 e = unrollf_sqrt<A, HK_SQRT_IGNORE>::apply(self);
    return _mm_andnot_ps(equalsZero, e);
} };

} // namespace

template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
HK_INLINE const hkSimdFloat32 hkSimdFloat32::sqrt() const
{
    return hkSimdFloat32::convert(hkSimdReal_AdvancedInterface::unrollf_sqrt<A,S>::apply(m_real));
}

HK_INLINE const hkSimdFloat32 hkSimdFloat32::sqrt() const
{
    return hkSimdFloat32::convert(hkSimdReal_AdvancedInterface::unrollf_sqrt<HK_ACC_MID,HK_SQRT_SET_ZERO>::apply(m_real));
}



namespace hkSimdReal_AdvancedInterface
{

template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
struct unrollf_sqrtInverse { HK_ALWAYS_INLINE static hkSingleFloat32 apply(const hkSingleFloat32& self)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
    return _mm_setzero_ps();
} };
template <hkMathAccuracyMode A>
struct unrollf_sqrtInverse<A, HK_SQRT_IGNORE> { HK_ALWAYS_INLINE static hkSingleFloat32 apply(const hkSingleFloat32& self)
{
    switch (A)
    {
        case HK_ACC_23_BIT: return hkMath::quadReciprocalSquareRoot(self); break;
        case HK_ACC_12_BIT: return _mm_rsqrt_ps(self); break;
        default:            return _mm_div_ps(g_vectorfConstants[HK_QUADREAL_1], _mm_sqrt_ps(self)); break; // HK_ACC_FULL
    }
} };
template <hkMathAccuracyMode A>
struct unrollf_sqrtInverse<A, HK_SQRT_SET_ZERO> { HK_ALWAYS_INLINE static hkSingleFloat32 apply(const hkSingleFloat32& self)
{
    const hkSingleFloat32 equalsZero = _mm_cmple_ps(self, _mm_setzero_ps());

    hkSingleFloat32 selfNonZero = self; avoidDivideByZeroInDebug<A>(equalsZero, selfNonZero);

    const hkSingleFloat32 e = unrollf_sqrtInverse<A, HK_SQRT_IGNORE>::apply(selfNonZero);
    return _mm_andnot_ps(equalsZero, e);
} };
} // namespace

template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
const HK_INLINE hkSimdFloat32 hkSimdFloat32::sqrtInverse() const
{
    return hkSimdFloat32::convert(hkSimdReal_AdvancedInterface::unrollf_sqrtInverse<A,S>::apply(m_real));
}

const HK_INLINE hkSimdFloat32 hkSimdFloat32::sqrtInverse() const
{
    return hkSimdFloat32::convert(hkSimdReal_AdvancedInterface::unrollf_sqrtInverse<HK_ACC_MID,HK_SQRT_SET_ZERO>::apply(m_real));
}



namespace hkSimdReal_AdvancedInterface
{
template <hkMathIoMode A>
struct unrollf_load { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat32* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <hkMathIoMode A>
struct unrollf_load_D { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkDouble64* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <>
struct unrollf_load<HK_IO_BYTE_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat32* HK_RESTRICT p)
{
    self = _mm_load1_ps(p);
} };
template <>
struct unrollf_load_D<HK_IO_BYTE_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkDouble64* HK_RESTRICT p)
{
    __m128d a = _mm_load_sd(p);
    __m128 f = _mm_cvtpd_ps(a);
    self = _mm_shuffle_ps(f,f,_MM_SHUFFLE(0,0,0,0));
} };
template <>
struct unrollf_load<HK_IO_NATIVE_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat32* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkFloat32)-1) ) == 0, "pointer must be aligned to native size of hkFloat32.");
    unrollf_load<HK_IO_BYTE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_load_D<HK_IO_NATIVE_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkDouble64* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkDouble64)-1) ) == 0, "pointer must be aligned to native size of hkDouble64.");
    unrollf_load_D<HK_IO_BYTE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_load<HK_IO_SIMD_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat32* HK_RESTRICT p)
{
    unrollf_load<HK_IO_NATIVE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_load_D<HK_IO_SIMD_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkDouble64* HK_RESTRICT p)
{
    unrollf_load_D<HK_IO_NATIVE_ALIGNED>::apply(self,p);
} };
} // namespace

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdFloat32::load(_In_ const hkFloat32 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_load<A>::apply(m_real, p);
}

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdFloat32::load(_In_ const hkDouble64 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_load_D<A>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::load(_In_ const hkFloat32 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_load<HK_IO_SIMD_ALIGNED>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::load(_In_ const hkDouble64 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_load_D<HK_IO_SIMD_ALIGNED>::apply(m_real, p);
}




namespace hkSimdReal_AdvancedInterface
{
template <hkMathIoMode A>
struct unrollf_loadH { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkHalf16* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <>
struct unrollf_loadH<HK_IO_BYTE_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkHalf16* HK_RESTRICT p)
{
    __m128 h = _mm_castsi128_ps( _mm_cvtsi32_si128(p->getStorage() << 16) );
    self = _mm_shuffle_ps( h,h, _MM_SHUFFLE(0,0,0,0) );
} };
template <>
struct unrollf_loadH<HK_IO_NATIVE_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkHalf16* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkHalf16)-1) ) == 0, "pointer must be aligned to native size of hkHalf16.");
    unrollf_loadH<HK_IO_BYTE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_loadH<HK_IO_SIMD_ALIGNED> { HK_ALWAYS_INLINE static void apply(hkSingleFloat32& self, _In_ const hkHalf16* HK_RESTRICT p)
{
    unrollf_loadH<HK_IO_NATIVE_ALIGNED>::apply(self,p);
} };
} // namespace

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdFloat32::load(_In_ const hkHalf16 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_loadH<A>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::load(_In_ const hkHalf16 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_loadH<HK_IO_SIMD_ALIGNED>::apply(m_real, p);
}




namespace hkSimdReal_AdvancedInterface
{
template <hkMathIoMode A>
struct unrollf_loadF16 { HK_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat16* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <>
struct unrollf_loadF16<HK_IO_BYTE_ALIGNED> { HK_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat16* HK_RESTRICT p)
{
    hkFloat32 tmp = p[0].getFloat32();
    self = _mm_load1_ps((const float*)&tmp);
} };
template <>
struct unrollf_loadF16<HK_IO_NATIVE_ALIGNED> { HK_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat16* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkFloat16)-1) ) == 0, "pointer must be aligned to native size of hkFloat16.");
    unrollf_loadF16<HK_IO_BYTE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_loadF16<HK_IO_SIMD_ALIGNED> { HK_INLINE static void apply(hkSingleFloat32& self, _In_ const hkFloat16* HK_RESTRICT p)
{
    unrollf_loadF16<HK_IO_NATIVE_ALIGNED>::apply(self,p);
} };
} // namespace

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdFloat32::load(_In_ const hkFloat16 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_loadF16<A>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::load(_In_ const hkFloat16 *p )
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_loadF16<HK_IO_SIMD_ALIGNED>::apply(m_real, p);
}



namespace hkSimdReal_AdvancedInterface
{
template <hkMathIoMode A>
struct unrollf_store { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat32* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <hkMathIoMode A>
struct unrollf_store_D { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkDouble64* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <>
struct unrollf_store<HK_IO_BYTE_ALIGNED> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat32* HK_RESTRICT p)
{
    _mm_store_ss( p, self );
} };
template <>
struct unrollf_store_D<HK_IO_BYTE_ALIGNED> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkDouble64* HK_RESTRICT p)
{
    __m128d d = _mm_cvtps_pd(self);
    _mm_store_sd( p, d );
} };
template <>
struct unrollf_store<HK_IO_NATIVE_ALIGNED> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat32* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkFloat32)-1) ) == 0, "pointer must be aligned to native size of hkFloat32.");
    unrollf_store<HK_IO_BYTE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_store_D<HK_IO_NATIVE_ALIGNED> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkDouble64* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkDouble64)-1) ) == 0, "pointer must be aligned to native size of hkDouble64.");
    unrollf_store_D<HK_IO_BYTE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_store<HK_IO_SIMD_ALIGNED> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat32* HK_RESTRICT p)
{
    unrollf_store<HK_IO_NATIVE_ALIGNED>::apply(self,p);
} };
template <>
struct unrollf_store_D<HK_IO_SIMD_ALIGNED> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkDouble64* HK_RESTRICT p)
{
    unrollf_store_D<HK_IO_NATIVE_ALIGNED>::apply(self,p);
} };
} // namespace

template <int N, hkMathIoMode A, hkMathRoundingMode R>
HK_INLINE void hkSimdFloat32::store( _In_ hkFloat32 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_store<A>::apply(m_real, p);
}

template <int N, hkMathIoMode A, hkMathRoundingMode R>
HK_INLINE void hkSimdFloat32::store( _Out_ hkDouble64 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_store_D<A>::apply(m_real, p);
}

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdFloat32::store( _Out_ hkFloat32 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_store<A>::apply(m_real, p);
}

template <int N, hkMathIoMode A>
HK_INLINE void hkSimdFloat32::store( _Out_ hkDouble64 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_store_D<A>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::store( _Out_ hkFloat32 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_store<HK_IO_SIMD_ALIGNED>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::store( _Out_ hkDouble64 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_store_D<HK_IO_SIMD_ALIGNED>::apply(m_real, p);
}




namespace hkSimdReal_AdvancedInterface
{
template <hkMathIoMode A, hkMathRoundingMode R>
struct unrollf_storeH {HK_ALWAYS_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkHalf16* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <hkMathRoundingMode R>
struct unrollf_storeH<HK_IO_BYTE_ALIGNED,R> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkHalf16* HK_RESTRICT p)
{
    __m128  vs0;
    if (R == HK_ROUND_NEAREST)
        vs0 = _mm_mul_ps( self, g_vectorfConstants[HK_QUADREAL_PACK_HALF] );
    else
        vs0 = self;
    __m128i tmp0 = _mm_srai_epi32( _mm_castps_si128(vs0), 16 );
    __m128i tmp1 = _mm_packs_epi32(tmp0, tmp0);
    float ftmp1; _mm_store_ss(&ftmp1, _mm_castsi128_ps(tmp1));
    const hkHalf16* HK_RESTRICT htmp1 = (const hkHalf16* HK_RESTRICT)&ftmp1;
    p[0] = htmp1[0];
} };
template <hkMathRoundingMode R>
struct unrollf_storeH<HK_IO_NATIVE_ALIGNED,R> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkHalf16* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkHalf16)-1) ) == 0, "pointer must be aligned to native size of hkHalf16.");
    unrollf_storeH<HK_IO_BYTE_ALIGNED,R>::apply(self,p);
} };
template <hkMathRoundingMode R>
struct unrollf_storeH<HK_IO_SIMD_ALIGNED,R> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkHalf16* HK_RESTRICT p)
{
    unrollf_storeH<HK_IO_NATIVE_ALIGNED,R>::apply(self,p);
} };
} // namespace

template <int N, hkMathIoMode A, hkMathRoundingMode R>
HK_INLINE void hkSimdFloat32::store(_Out_ hkHalf16 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_storeH<A,R>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::store( _Out_ hkHalf16 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_storeH<HK_IO_SIMD_ALIGNED,HK_ROUND_DEFAULT>::apply(m_real, p);
}




namespace hkSimdReal_AdvancedInterface
{
template <hkMathIoMode A, hkMathRoundingMode R>
struct unrollf_storeF16 { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat16* HK_RESTRICT p)
{
    HK_SIMDFLOAT_TEMPLATE_CONFIG_NOT_IMPLEMENTED;
} };
template <hkMathRoundingMode R>
struct unrollf_storeF16<HK_IO_BYTE_ALIGNED,R> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat16* HK_RESTRICT p)
{
    hkFloat32 tmp;
    _mm_store_ss(&tmp, self);
    p[0].setReal<(R == HK_ROUND_NEAREST)>(tmp);
} };
template <hkMathRoundingMode R>
struct unrollf_storeF16<HK_IO_NATIVE_ALIGNED,R> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat16* HK_RESTRICT p)
{
    HK_MATH_ASSERT(0x64211c2f, ( ((hkUlong)p) & (sizeof(hkFloat16)-1) ) == 0, "pointer must be aligned to native size of hkFloat16.");
    unrollf_storeF16<HK_IO_BYTE_ALIGNED,R>::apply(self,p);
} };
template <hkMathRoundingMode R>
struct unrollf_storeF16<HK_IO_SIMD_ALIGNED,R> { HK_INLINE static void apply(const hkSingleFloat32& self, _Out_ hkFloat16* HK_RESTRICT p)
{
    unrollf_storeF16<HK_IO_NATIVE_ALIGNED,R>::apply(self,p);
} };
} // namespace

template <int N, hkMathIoMode A, hkMathRoundingMode R>
HK_INLINE void hkSimdFloat32::store( _Out_ hkFloat16 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_storeF16<A,R>::apply(m_real, p);
}

template <int N>
HK_INLINE void hkSimdFloat32::store( _Out_ hkFloat16 *p ) const
{
    HK_SIMDFLOAT_DIMENSION_CHECK;
    hkSimdReal_AdvancedInterface::unrollf_storeF16<HK_IO_SIMD_ALIGNED,HK_ROUND_DEFAULT>::apply(m_real, p);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
