// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Math/Vector/hkIntVector.h>
//HK_REFLECTION_PARSER_EXCLUDE_FILE

/// Helper class to pack vectors in various formats
namespace hkVectorPackUtility
{
    /// decode an unsigned integer into 3 floats, the precision being NUM_BITS_X, NUM_BITS_Y, #totalBitsInT-NUM_BITS_X-NUM_BITS_Y.
    /// To use this method you have to include
    /// #include <Common/Base/Math/Vector/hkIntVector.h>
    template< typename T, int NUM_BITS_X, int NUM_BITS_Y >
    HK_INLINE void decode3(const T& i, _Inout_ hkVector4f* HK_RESTRICT vectorOut);

    /// Decode 3 fractions between [0..1.0]
    template< typename T, int NUM_BITS_X, int NUM_BITS_Y >
    HK_INLINE void decodeFractions3( const T& i, _Inout_ hkVector4f* HK_RESTRICT vectorOut );

#if defined(HK_REAL_IS_FLOAT)
    /// Encode
    template< typename T, int NUM_BITS_X, int NUM_BITS_Y >
    HK_INLINE void  encode3(const hkAabb& aabb, hkVector4fParameter vertex, _Inout_ T* HK_RESTRICT output);
#endif // defined(HK_REAL_IS_FLOAT)

    /// Store all components of vector to the stream if the corresponding bit in the mask m is set, returns the pointer
    /// after the last element written.
    HK_INLINE _Ret_notnull_ hkFloat32*  filteredStoreToStream(hkVector4fParameter vector, hkVector4ComparisonMask::Mask m, _Out_writes_bytes_(_Inexpressible_(filteredStoreToStream_calcOffset * 4)) hkFloat32* dest);
}

#include <Common/Base/Math/Vector/Packing/hkVectorfPackUtility.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
